/*
    Launcher.h

    Interface declaration of the Launcher class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "InternalProjectModule.h"

@class NSMutableArray, NSMutableDictionary;
@class NSTask, NSFileHandle;

@interface Launcher : InternalProjectModule
{
  id launchButton;
  id stderr;
  id stdout;
  id stdin;
  id workingDirectory;

  NSMutableArray * arguments;
  NSMutableDictionary * environment;

  NSTask * task;
  NSFileHandle * stdinHandle,
               * stdoutHandle,
               * stderrHandle;
}

- (void) launch: (id)sender;
- (void) chooseWorkingDirectory: (id)sender;
- (void) showArguments: (id)sender;
- (void) showEnvironment: (id)sender;

- (void) taskTerminated;

- (void) writeStdin: sender;
- (void) readStdout;
- (void) readStderr;

@end
