/*
    NSArrayAdditions.m

    Implementation of the additions to the NSArray class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "NSArrayAdditions.h"
#import "NSDictionaryAdditions.h"

@implementation NSArray (PMAdditions)

- makeDeeplyMutableEquivalent
{
  id (*ObjectAtIndex)(id, SEL, unsigned int) =
    (id (*)(id, SEL, unsigned int)) [self methodForSelector:
    @selector(objectAtIndex:)];
  void (*AddObject)(id, SEL, id);
  NSMutableArray * mutableCopy;
  unsigned int i, n;
  Class arrayClass = [NSArray class],
        dictionaryClass = [NSDictionary class];

  n = [self count];

  mutableCopy = [NSMutableArray arrayWithCapacity: n];
  AddObject = (void (*)(id, SEL, id)) [mutableCopy methodForSelector:
    @selector(addObject:)];

  for (i=0; i < n; i++)
    {
      id object;

      object = ObjectAtIndex(self, @selector(objectAtIndex:), i);
      if ([object isKindOfClass: arrayClass] ||
          [object isKindOfClass: dictionaryClass])
        {
          AddObject(mutableCopy, @selector(addObject:), [object
            makeDeeplyMutableEquivalent]);
        }
      else
        {
          AddObject(mutableCopy, @selector(addObjecT:), object);
        }
    }

  return mutableCopy;
}

@end
