/*
    ProjectWindowController.h

    Interface declaration of the ProjectWindowController class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <AppKit/NSWindowController.h>
#import <AppKit/NSMenu.h>

@class NSArray, NSString, NSToolbar, NSToolbarItem, NSBox;

@class Builder;
@class ProjectDocument, ProjectModule;

typedef enum {
  AttributesTab,
  FilesTab,
  FrameworksTab,
  BuildTab,
  RunTab,
  DebugTab,
  SubprojectsTab
} ProjectWindowTab;

@interface ProjectWindowController : NSWindowController
{
  NSBox * box;

  ProjectWindowTab currentTab;
  ProjectModule * currentModule;

  // weak reference
  ProjectDocument * owner;

  NSArray * itemIdentifiers;
}

+ (NSArray *) toolbarItemIdentifiersForProjectCapabilities: (int) capabilities;

- initWithWindowNibName: (NSString *) nibName
          ownerDocument: (ProjectDocument *) anOwner;

- (void) switchView: sender;

- (void) selectView: (ProjectWindowTab) tag;
- (ProjectWindowTab) currentTab;
- (ProjectModule *) currentModule;

// actions of menu items switching project tabs
- (void) viewAttributes: sender;
- (void) viewFrameworks: sender;
- (void) viewFiles: sender;
- (void) viewBuild: sender;
- (void) viewLaunch: sender;
- (void) viewDebug: sender;
- (void) viewSubprojects: sender;

// toolbar delegate methods
- (NSToolbarItem*)toolbar: (NSToolbar*)toolbar
    itemForItemIdentifier: (NSString*)itemIdentifier
willBeInsertedIntoToolbar: (BOOL)flag;
- (NSArray*) toolbarAllowedItemIdentifiers: (NSToolbar*)toolbar;
- (NSArray*) toolbarDefaultItemIdentifiers: (NSToolbar*)toolbar;
- (NSArray *) toolbarSelectableItemIdentifiers: (NSToolbar *)toolbar;

@end
