/***************************************************************************
                          job_appendnfstodatabase.cpp  -  description
                             -------------------
    begin                : Wed Feb 27 2002
    copyright            : (C) 2002 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_appendnfstodatabase.h"

#include "job_disconnectfromdatabase.h"
#include "database.h"
#include "datadispatcher.h"
#include "jobmanager.h"

#ifdef EMBEDDED 
  #include <mysql.h>
#endif

Job_AppendNFSToDatabase::Job_AppendNFSToDatabase(LVI_NFSExport *_Export)
  : Export(_Export)
{}

void Job_AppendNFSToDatabase::run()
{
  int error = 0;

  if (verbose==8) qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

#ifdef EMBEDDED 
  mysql_thread_init(); 
#endif
  app->lock();
  datadispatcher->eventAddEditLock();
  datadispatcher->eventStartedAppendingNFS(Export);
  app->unlock();

//    QList<TRACK> *files =     getFileList(new QDir(Export->getPath()), false);

  QList<TRACK> *files = readTags(getFileList(new QDir(Export->getPath()), false), true);

  for(TRACK *curr = files->first(); curr != 0; curr = files->next()) curr->path.replace(0, Export->getPath().length(), "");

  database->lock();
  int NfsID = database->appendTracks(files, MEDIUM_NFS, Export->getLabel(), Export->getDevice(), 0, true, 0);
  error = database->getError();
  database->unlock();
  
  if(!error) {
    database->lock();
    app->lock();

    MEDIUM medium;
    medium.id       = NfsID;
    medium.type     = MEDIUM_NFS;
    medium.label    = Export->getLabel();
    medium.path     = Export->getDevice();

    datadispatcher->eventNewLocalAlbumDelta(NfsID, database->getLocalAlbumDelta(NfsID));
    datadispatcher->eventNewArtistDelta(database->getArtistDelta());
    datadispatcher->eventNewMedium(&medium);
    datadispatcher->eventNewTrackListing(database->getLastQuery());

    error  = database->getError();

    if(!error) datadispatcher->eventStoppedAppendingNFS(Export);
    datadispatcher->eventRemoveEditLock();

    app->unlock();
    database->unlock();
  }
  
  if(error) {
    app->lock();
    datadispatcher->eventStoppedAppendingNFS(Export);
    app->unlock();
    jobman->lock();
    jobman->addJob(new Job_DisconnectFromDatabase());
    jobman->unlock();
  }
  
  for(TRACK *curr = files->first(); curr != 0; curr = files->next()) delete curr;
  delete files;
  
  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
#ifdef EMBEDDED 
  mysql_thread_end(); 
#endif

  if (verbose==8) qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

  exit();
}

Job_AppendNFSToDatabase::~Job_AppendNFSToDatabase() {}
