/***************************************************************************
                 job_countdata.cpp  -  description
                             -------------------
    begin                : Wed Jan 8 2002
    copyright            : (C) 2003 by Markus Kalkbrenner
    email                : mkalkbrenner@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_countdata.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"
#include "gui.h"

#include <iostream>

#ifdef EMBEDDED
#include <mysql.h>
#endif

Job_CountData::Job_CountData() {}

void Job_CountData::run() {
    int error;

    if (verbose==8)
        qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

    #ifdef EMBEDDED

    mysql_thread_init();
    #endif

    database->lock()
    ;

    int countArtists = database->getCountColumnDistinctFromTable("artist", "tracks");
    int countTracks  = database->getCountFromTable("tracks");
    int countCovers = database->getCountColumnDistinctFromTable("cover_id", "albums");
    int countLyrics = database->getCountColumnDistinctFromTable("lyrics_id", "tracks");
    int countImages = database->getCountColumnDistinctFromTable("image_id", "artists");
    error = database->getError();

    database->unlock();

    if(!error) {

        QString status;
        status.sprintf(_(" Artists: %d "), countArtists);
        StatusEvent* se = new StatusEvent( new STATUSDATA( status, 3) );
        QApplication::postEvent( gui->getPlaylisting(), se );

        status.sprintf(_(" Tracks: %d "), countTracks);
        se = new StatusEvent( new STATUSDATA( status, 4) );
        QApplication::postEvent( gui->getPlaylisting(), se );

        /* TRANSLATORS: short form of 'Images' 'Covers' 'Lyrics' */
        status.sprintf(_(" Ima.:%d Cov.:%d Lyr.:%d"), countImages, countCovers, countLyrics);
        se = new StatusEvent( new STATUSDATA( status, 6) );
        QApplication::postEvent( gui->getPlaylisting(), se );
    }

    jobman->lock()
    ;
    jobman->jobDone(this);
    jobman->unlock();
    #ifdef EMBEDDED

    mysql_thread_end();
    #endif

    if (verbose==8)
        qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

    exit();
}

Job_CountData::~Job_CountData() {}
