.TH PROSODYCTL 1 "2009-07-02"

.SH NAME
prosodyctl \- Manage a Prosody XMPP server

.SH SYNOPSIS
\fBprosodyctl\fP \fIcommand\fP [\fI--help\fP]

.SH DESCRIPTION
\fBprosodyctl\fP is the control tool for the Prosody XMPP server. It may be
used to control the server daemon and manage users.

\fBprosodyctl\fP needs to be executed with sufficient privileges to perform
its commands. This typically means executing \fBprosodyctl\fP as the root user.
If a user named "prosody" is found then \fBprosodyctl\fP will change to that
user before executing its commands.

.SH COMMANDS
.SS User Management
In the following commands users are identified by a Jabber ID, \fIjid\fP, of the
usual form: user@domain.

.IP "\fBadduser\fP \fIjid\fP"
Adds a user with Jabber ID, \fIjid\fP, to the server. You will be
prompted to enter the user's password.

.IP "\fBpasswd\fP \fIjid\fP"
Changes the password of an existing user with Jabber ID, \fIjid\fP. You will be
prompted to enter the user's new password.

.IP "\fBdeluser\fP \fIjid\fP"
Deletes an existing user with Jabber ID, \fIjid\fP, from the server.

.SS Daemon Management
Although \fBprosodyctl\fP has commands to manage the \fBprosody\fP daemon it is
recommended that you utilize your distributions daemon management features if
you attained Prosody through a package.

To perform daemon control commands \fBprosodyctl\fP needs a \fIpidfile\fP value
specified in \fI/etc/prosody/prosody.cfg.lua\fP. Failure to do so will cause
\fBprosodyctl\fP to complain.

.IP \fBstart\fP
Starts the \fBprosody\fP server daemon. If run as root \fBprosodyctl\fP will
attempt to change to a user named "prosody" before executing. This operation
will block for up to five seconds to wait for the server to execute.

.IP \fBstop\fP
Stops the \fBprosody\fP server daemon. This operation will block for up to five
seconds to wait for the server to stop executing.

.IP \fBstatus\fP
Prints the current execution status of the \fBprosody\fP server daemon.

.SS Ejabberd Compatibility
\fBejabberd\fP is another XMPP server which provides a comparable control tool,
\fBejabberdctl\fP, to control its server's operations. \fBprosodyctl\fP
implements some commands which are compatible with \fBejabberdctl\fP. For
details of how these commands work you should see
.BR ejabberdctl (8).

.IP "\fBregister\fP \fIuser server password\fP"
.IP "\fBunregister\fP \fIuser server\fP"

.SH OPTIONS
.IP \fI--help\fP
Display help text for the specified command.

.SH FILES
.IP \fI/etc/prosody/prosody.cfg.lua\fP
The main \fBprosody\fP configuration file. \fBprosodyctl\fP reads this to
determine the process ID file of the \fBprosody\fP server daemon and to
determine if a host has been configured.

.SH ONLINE
More information may be found online at: \fIhttp://prosody.im/\fP

.SH AUTHORS
Dwayne Bent <dbb.1@liqd.org>
