#include "chatviewbase.h"

ChatViewBase::ChatViewBase()
		: dialog_(0)
{

}

void ChatViewBase::setDialog(QWidget* dialog)
{
	dialog_ = dialog;
}

QString ChatViewBase::formatTimeStamp(const QDateTime &time)
{
	// TODO: provide an option for user to customize
	// time stamp format
	return QString().sprintf("%02d:%02d:%02d", time.time().hour(), time.time().minute(), time.time().second());;
}

void ChatViewBase::updateLastMsgTime(QDateTime t)
{
	bool doInsert = t.date() != lastMsgTime_.date();
	lastMsgTime_ = t;
	if (doInsert) {
		appendLastMsgTime(t.date());
	}
}
