#include <QtGui>
#include <QtCore>

#include "psiplugin.h"
#include "stanzafilter.h"
#include "accountinfoaccessor.h"
#include "accountinfoaccessinghost.h"
#include "applicationinfoaccessor.h"
#include "applicationinfoaccessinghost.h"


#define cVer "0.0.2"

class ConferenceLogger: public QObject, public PsiPlugin, public StanzaFilter, public AccountInfoAccessor, public ApplicationInfoAccessor
{
	Q_OBJECT
        Q_INTERFACES(PsiPlugin StanzaFilter AccountInfoAccessor ApplicationInfoAccessor)

public:
        ConferenceLogger();
	virtual QString name() const;
	virtual QString shortName() const;
	virtual QString version() const;
        virtual QWidget* options();
	virtual bool enable();
        virtual bool disable();
        virtual void applyOptions();
        virtual void restoreOptions();
        virtual bool incomingStanza(int account, const QDomElement& xml);
        virtual void setAccountInfoAccessingHost(AccountInfoAccessingHost* host);
        virtual void setApplicationInfoAccessingHost(ApplicationInfoAccessingHost* host);

private:
        bool enabled;
        AccountInfoAccessingHost *AccInfoHost;
        ApplicationInfoAccessingHost *AppInfoHost;
        QString HistoryDir;
        void Logger(QString room, QString from, QString MyJid, QString Text, QString Stamp);
    };

Q_EXPORT_PLUGIN(ConferenceLogger);

ConferenceLogger::ConferenceLogger() {
        enabled = false;        
        AppInfoHost = 0;
        AccInfoHost = 0;
        HistoryDir = "";
    }

QString ConferenceLogger::name() const {
        return "Conference Logger Plugin";
    }

QString ConferenceLogger::shortName() const {
        return "logger";
}

QString ConferenceLogger::version() const {
        return cVer;
}

bool ConferenceLogger::enable() {
    enabled = true;
    HistoryDir = AppInfoHost->appHistoryDir();
    return enabled;
}

bool ConferenceLogger::disable() {
	enabled = false;        
	return true;
}

QWidget* ConferenceLogger::options() {
    if(!enabled) {
    return 0;
}
    QWidget *options = new QWidget();
    QVBoxLayout *layout = new QVBoxLayout(options);
    QLabel *label = new QLabel(tr("You can find your logs here:"));
    QLineEdit *path = new QLineEdit;
    path->setText(HistoryDir);
    path->setEnabled(false);
    layout->addWidget(label);
    layout->addWidget(path);
    layout->addStretch();
    return options;
}

bool ConferenceLogger::incomingStanza(int account, const QDomElement& stanza) {
     if (enabled) {
         if(stanza.tagName() == "message") {
             if(stanza.attribute("type") == "groupchat") {
                 QString from = stanza.attribute("from");
                 QStringList List = from.split("/");
                 QString room = List.takeFirst();
                 from = "";
                 if(!List.isEmpty()) {
                     from = List.takeFirst();
                 }
                 QString Stamp = "";
                 Stamp = stanza.firstChildElement("x").attribute("stamp");
                 QDomElement body = stanza.firstChildElement("body");
                 if(!body.isNull()) {
                     QString Text = body.text();
                     QString MyJid = AccInfoHost->getJid(account);
                     MyJid = MyJid.replace("@", "_at_");
                     Logger(room, from, MyJid, Text, Stamp);
                 }
             }
         }
     }
     return false;
 }

void ConferenceLogger::setAccountInfoAccessingHost(AccountInfoAccessingHost* host) {
     AccInfoHost = host;
 }

void ConferenceLogger::setApplicationInfoAccessingHost(ApplicationInfoAccessingHost* host) {
     AppInfoHost = host;
 }

void ConferenceLogger::Logger(QString room, QString from, QString MyJid, QString Text, QString Stamp) {
    room = room.replace("@", "_at_");
    room = "_in_" + room;
    if(Stamp == "") {
        Stamp = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss");
    }
    else {
        Stamp.insert(4, "-");
        Stamp.insert(7, "-");
        Stamp.replace("T", " ");
    }
    QFile file(HistoryDir + QDir::separator() + MyJid + room);
    if(file.open(QIODevice::ReadWrite)) {
        QTextStream out(&file);
        out.seek(file.size());
        out << Stamp << "  " << from << ": " << Text << endl;
    }
}

void ConferenceLogger::applyOptions() {
}

void ConferenceLogger::restoreOptions() {
}
#include "conferenceloggerplugin.moc"
