#include <QtGui>
#include <QtCore>

#include "psiplugin.h"
#include "optionaccessor.h"
#include "optionaccessinghost.h"
#include "stanzafilter.h"
#include "stanzasender.h"
#include "stanzasendinghost.h"
#include "accountinfoaccessor.h"
#include "accountinfoaccessinghost.h"
#include "applicationinfoaccessor.h"
#include "applicationinfoaccessinghost.h"


#define cVer "0.0.8"
#define constQuestion "qstn"
#define constAnswer "answr"
#define constUnblocked "UnblockedList"
#define constDisable "dsbl"
#define constCounter "cntr"

class StopSpam: public QObject, public PsiPlugin, public OptionAccessor, public StanzaSender,  public StanzaFilter, public AccountInfoAccessor, public ApplicationInfoAccessor
{
	Q_OBJECT
        Q_INTERFACES(PsiPlugin OptionAccessor StanzaSender StanzaFilter AccountInfoAccessor ApplicationInfoAccessor)

public:
        StopSpam();
	virtual QString name() const;
	virtual QString shortName() const;
	virtual QString version() const;
        virtual QWidget* options();
	virtual bool enable();
        virtual bool disable();
        virtual void applyOptions();
        virtual void restoreOptions();
        virtual void setOptionAccessingHost(OptionAccessingHost* host);
	virtual void optionChanged(const QString& option);
        virtual void setStanzaSendingHost(StanzaSendingHost *host);
        virtual bool incomingStanza(int account, const QDomElement& xml);
        virtual void setAccountInfoAccessingHost(AccountInfoAccessingHost* host);
        virtual void setApplicationInfoAccessingHost(ApplicationInfoAccessingHost* host);

private:
	bool enabled;
	OptionAccessingHost* psiOptions;        
        StanzaSendingHost* StanzaHost;
        AccountInfoAccessingHost *AccInfoHost;
        ApplicationInfoAccessingHost *AppInfoHost;
        QTextEdit *questionWidget;
        QLineEdit *answerWidget;
        QTextEdit *disableWidget;
        QString Question;
        QString Answer;
        QString Unblocked;
        QString Disable;
        int Counter;
        QLineEdit *countWid;
        void updateCounter(QDomElement stanza);
        struct Blocked {
            int Acc;
            QString Jid;
            int count;
        };
        QVector<Blocked> BlockedJids;
        bool FindAcc(int account, QString Jid, int &i);

 private slots:
        void resetCounter();
    };

Q_EXPORT_PLUGIN(StopSpam);

StopSpam::StopSpam() {
        enabled = false;        
        Question = "2+3=?";
        Answer = "5";
        questionWidget = 0;
        disableWidget = 0;
        answerWidget = 0;
        psiOptions = 0;        
        StanzaHost = 0;
        AccInfoHost = 0;
        AppInfoHost = 0;
        Unblocked = "";
        Disable = "";
        Counter = 0;
        countWid = 0;
    }

QString StopSpam::name() const {
        return "Stop Spam Plugin";
    }

QString StopSpam::shortName() const {
        return "stopspam";
}

QString StopSpam::version() const {
        return cVer;
}

bool StopSpam::enable() {
    if (psiOptions) {
        enabled = true;
        QVariant vQuestion(Question);
        vQuestion = psiOptions->getPluginOption(constQuestion);
        if (!vQuestion.isNull()) {
            Question = vQuestion.toString();
        }
        QVariant vAnswer(Answer);
        vAnswer = psiOptions->getPluginOption(constAnswer);
        if (!vAnswer.isNull()) {
            Answer = vAnswer.toString();
        }
        QVariant vUnblocked(Unblocked);
        vUnblocked = psiOptions->getPluginOption(constUnblocked);
        if (!vUnblocked.isNull()) {
            Unblocked = vUnblocked.toString();
        }
        QVariant vDisable(Disable);
        vDisable = psiOptions->getPluginOption(constDisable);
        if (!vDisable.isNull()) {
            Disable = vDisable.toString();
        }
    /*    QVariant vCounter(Counter);
        vCounter = psiOptions->getPluginOption(constCounter);
        if (!vCounter.isNull()) {
            Counter = vCounter.toInt();
        } */
    }
    return enabled;
}

bool StopSpam::disable() {
	enabled = false;        
	return true;
}

void StopSpam::applyOptions() {
    if (answerWidget == 0 || questionWidget == 0 || countWid == 0) {
                return;
        }   
    QVariant vQuestion(questionWidget->toPlainText());
    psiOptions->setPluginOption(constQuestion, vQuestion);
    Question = vQuestion.toString();
    QVariant vAnswer(answerWidget->text());
    psiOptions->setPluginOption(constAnswer, vAnswer);
    Answer = vAnswer.toString();
    QVariant vDisable(disableWidget->toPlainText());
    psiOptions->setPluginOption(constDisable, vDisable);
    Disable = vDisable.toString();
 /*   QString count = countWid->text();
    QVariant vCounter(count.toInt());
    psiOptions->setPluginOption(constDisable, vDisable);
    Counter = vCounter.toInt(); */
}

void StopSpam::restoreOptions() {
    if (answerWidget == 0 || questionWidget == 0 || countWid == 0) {
                return;
        }
     QVariant vQuestion(Question);
        vQuestion = psiOptions->getPluginOption(constQuestion);
        if (!vQuestion.isNull()) {
            questionWidget->setText(vQuestion.toString());
        }
        else {
            questionWidget->setText(Question);
        }
        QVariant vAnswer(Answer);
        vAnswer = psiOptions->getPluginOption(constAnswer);
        if (!vAnswer.isNull()) {
            answerWidget->setText(vAnswer.toString());
        }
        else {
            answerWidget->setText(Answer);
        }
        QVariant vDisable(Disable);
        vDisable = psiOptions->getPluginOption(constDisable);
        if (!vDisable.isNull()) {
            disableWidget->setText(vDisable.toString());
        }
        else {
            disableWidget->setText(Disable);
        }
      /*  QVariant vCounter(Counter);
        vCounter = psiOptions->getPluginOption(constCounter);
        if (!vCounter.isNull()) {
            countWid->setText(vCounter.toString());
        }
        else {
            countWid->setText("0");
        } */
}

QWidget* StopSpam::options() {
        if (!enabled) {
                return 0;
        }
        QWidget *optionsWid = new QWidget();
        QVBoxLayout *layout = new QVBoxLayout(optionsWid);
        countWid = new QLineEdit();
        QVariant vCounter(Counter);
        vCounter = psiOptions->getPluginOption(constCounter);
        if (!vCounter.isNull()) {
            countWid->setText(vCounter.toString());
        }
        else {
            countWid->setText("0");
        }
        countWid->setDisabled(true);
        countWid->setMaximumWidth(60);
        QPushButton *resetButton = new QPushButton(tr("Reset"));
        connect(resetButton, SIGNAL(released()), SLOT(resetCounter()));
        QHBoxLayout *count = new QHBoxLayout;
        count->addWidget(new QLabel(tr("Number of blocked stanzas:")));
        count->addWidget(countWid);
        count->addWidget(resetButton);
        count->addStretch();
        answerWidget = new QLineEdit();
        answerWidget->setText(Answer);
        questionWidget = new QTextEdit();
        questionWidget->setText(Question);
        disableWidget = new QTextEdit();
        disableWidget->setText(Disable);
        layout->addLayout(count);
        layout->addWidget(new QLabel(tr("Question:")));
        layout->addWidget(questionWidget);
        layout->addWidget(new QLabel(tr("Answer:")));
        layout->addWidget(answerWidget);
        QHBoxLayout *disLayout = new QHBoxLayout;
        disLayout->addWidget(new QLabel(tr("Disable if Jid contains:")));
        disLayout->addWidget(disableWidget);
        layout->addLayout(disLayout);
        return optionsWid;
    }

void StopSpam::setOptionAccessingHost(OptionAccessingHost* host) {
	psiOptions = host;
}

void StopSpam::optionChanged(const QString& option) {
	Q_UNUSED(option);
}

void StopSpam::setStanzaSendingHost(StanzaSendingHost *host) {
    StanzaHost = host;
}

 bool StopSpam::incomingStanza(int account, const QDomElement& stanza) {
     if (enabled) {
         if(stanza.tagName() == "iq") {
             QDomElement query = stanza.firstChildElement("query");
             if(!query.isNull()) {
                 if(query.attribute("xmlns") == "jabber:iq:roster") {
                     QStringList Roster = AccInfoHost->getRoster(account);
                     QStringList UnblockedList = Unblocked.split("\n");
                     while(!Roster.isEmpty()) {
                         QString jid = Roster.takeFirst();
                         UnblockedList.removeOne(jid);
                     }
                     Unblocked = "";
                     while(!UnblockedList.isEmpty()) {
                         QString jid = UnblockedList.takeFirst();
                         if(jid != "") {
                             Unblocked += jid + "\n";
                         }
                     }
                     QVariant vUnblocked(Unblocked);
                     psiOptions->setPluginOption(constUnblocked, vUnblocked);
                 }
             }
         }
             QString from = stanza.attribute("from");
             QString to = stanza.attribute("to");
             QStringList f = from.split("/");
             QStringList t = to.split("/");
             QString valF = f.takeFirst();
             QString valT = t.takeFirst();
             if(valF == valT) { return false;
             }
             if(!from.contains("@") || from.contains("conference")) { return false;
             }
             QStringList Roster = AccInfoHost->getRoster(account);
             while(!Roster.isEmpty()) {
                 QString jid = Roster.takeFirst();
                 if(valF.toLower() == jid.toLower()) { return false;
                 }
             }
             QStringList UnblockedJids = Unblocked.split("\n");
             while(!UnblockedJids.isEmpty()) {
                 QString jid = UnblockedJids.takeFirst();
                 if(valF.toLower() == jid.toLower()) { return false;
                 }
             }
             QStringList DisableFor = Disable.split(QRegExp("\\s+"), QString::SkipEmptyParts);
             while(!DisableFor.isEmpty()) {
                 if(from.contains(DisableFor.takeFirst(), Qt::CaseInsensitive)) { return false;
                 }
             }

             if (stanza.tagName() == "message") {
             QDomElement subj = stanza.firstChildElement("subject");
             if (subj.text() == "AutoReply" || subj.text() == "StopSpam" || subj.text() == "StopSpam Question") {
                 return false;
             }
             QString type = "";
             type = stanza.attribute("type");
             if(type == "error" && subj.text() == "StopSpam Question") { return true;
             }
             if(type == "groupchat" || type == "error") { return false;
             }             
             QDomElement Body = stanza.firstChildElement("body");
             if(!Body.isNull()) {
                 QString BodyText = Body.text();
                 if(BodyText == Answer) {
                     Unblocked += valF + "\n";
                     QVariant vUnblocked(Unblocked);
                     psiOptions->setPluginOption(constUnblocked, vUnblocked);
                     StanzaHost->sendMessage(account, from,  tr("Now you can chat!"), "StopSpam", "chat");
                     } else {
                         int i = BlockedJids.size();
                         if(FindAcc(account, valF, i)) {
                             Blocked &B = BlockedJids[i];
                             if(B.count < 1) {
                                 StanzaHost->sendMessage(account, from,  Question, "StopSpam Question", "chat");
                                 updateCounter(stanza);
                                 B.count++;
                                 return true;
                             }
                             else {
                                 updateCounter(stanza);
                                 return true;
                             }
                         }
                         else {
                             Blocked B = {account, valF, 0};
                             BlockedJids << B;
                             StanzaHost->sendMessage(account, from,  Question, "StopSpam Question", "chat");
                             updateCounter(stanza);
                             return true;
                         }
                    }
                 }
             updateCounter(stanza);
             return true;
         }

          if (stanza.tagName() == "presence") {
              QString type = stanza.attribute("type");
              if(type == "subscribe") {
                  StanzaHost->sendMessage(account, from,  Question, "StopSpam Question", "chat");
                  StanzaHost->sendStanza(account, "<presence type=\"unsubscribed\" to=\"" + valF + "\" />");
                  updateCounter(stanza);
                  return true;
              } else {
                  return false;
              }
          }

          return false;
      }
     return false;
 }

 void StopSpam::setAccountInfoAccessingHost(AccountInfoAccessingHost* host) {
     AccInfoHost = host;
 }

 void StopSpam::updateCounter(QDomElement stanza) {
     QVariant vCounter(Counter);
     vCounter = psiOptions->getPluginOption(constCounter);
     if (!vCounter.isNull()) {
         Counter = vCounter.toInt();
     }
     Counter++;
     vCounter = Counter;
     psiOptions->setPluginOption(constCounter, vCounter);
     QString path = AppInfoHost->appHomeDir();
     QFile file(path + QDir::separator() + "Blockedstanzas.log");
     if(file.open(QIODevice::ReadWrite)) {
         QTextStream out(&file);
         out.seek(file.size());
         out << stanza << endl << endl;
     }
 }

 bool StopSpam::FindAcc(int account, QString Jid, int &i) {
     for(; i > 0;) {
         Blocked Block =  BlockedJids[--i];
         if(Block.Acc == account && Block.Jid == Jid) {
             return true;
         }
     }
     return false;
 }

 void StopSpam::resetCounter() {
     Counter = 0;
     QVariant vCounter(Counter);
     psiOptions->setPluginOption(constCounter, vCounter);
     countWid->setText("0");
     psiOptions->setPluginOption(constCounter, vCounter);
     QString path = AppInfoHost->appHomeDir();
     QFile file(path + QDir::separator() + "Blockedstanzas.log");
     file.remove(path + QDir::separator() + "Blockedstanzas.log");
 }

 void StopSpam::setApplicationInfoAccessingHost(ApplicationInfoAccessingHost* host) {
     AppInfoHost = host;
 }

#include "stopspamplugin.moc"
