#ifndef MODEL_H
#define MODEL_H

#include <QAbstractTableModel>
#include <QStringList>
#include <QVariantList>
#include <QSet>

class Model : public QAbstractTableModel
{
    Q_OBJECT

public:
        Model(QStringList Jids_, QVariantList selected_, QObject *parent = 0);
        ~Model() {};
        virtual Qt::ItemFlags flags ( const QModelIndex & index ) const;
        virtual QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
        virtual QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
        virtual int rowCount ( const QModelIndex & parent = QModelIndex() ) const;
        virtual int columnCount ( const QModelIndex & parent = QModelIndex() ) const;
        virtual bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
        QString jid(const QModelIndex & index) const;
        void reset();
        void apply();
        void addRow();
        void deleteRow();
        int indexByJid(QString jid);
        QVariantList enableFor();
        QStringList getJids();


private:
        QStringList headers, Jids, tmpJids_;
        QSet<QString> selected;
};


#endif // MODEL_H
