#ifndef STORAGENOTESPLUGIN_H
#define STORAGENOTESPLUGIN_H

#include "psiplugin.h"
#include "iconfactoryaccessor.h"
#include "iconfactoryaccessinghost.h"
#include "stanzasender.h"
#include "stanzasendinghost.h"
#include "accountinfoaccessinghost.h"
#include "accountinfoaccessor.h"
#include "stanzafilter.h"
#include "popupaccessor.h"
#include "popupaccessinghost.h"
#include "menuaccessor.h"
#include "plugininfoprovider.h"

class Notes;

class StorageNotesPlugin : public QObject, public PsiPlugin, public StanzaSender, public IconFactoryAccessor, public PluginInfoProvider,
                           public AccountInfoAccessor, public StanzaFilter, public PopupAccessor, public MenuAccessor
{
        Q_OBJECT
	Q_INTERFACES(PsiPlugin StanzaSender IconFactoryAccessor AccountInfoAccessor StanzaFilter PopupAccessor MenuAccessor PluginInfoProvider)
public:
        StorageNotesPlugin();
        virtual QString name() const;
        virtual QString shortName() const;
        virtual QString version() const;
        virtual QWidget* options();
        virtual bool enable();
        virtual bool disable();

        virtual void applyOptions() {};
        virtual void restoreOptions() {};
        virtual void setIconFactoryAccessingHost(IconFactoryAccessingHost* host);
        virtual void setStanzaSendingHost(StanzaSendingHost *host);
        virtual void setAccountInfoAccessingHost(AccountInfoAccessingHost* host);
        virtual bool incomingStanza(int account, const QDomElement& xml);
        virtual void setPopupAccessingHost(PopupAccessingHost* host);
        virtual QList < QVariantHash >* getAccountMenuParam();
        virtual QList < QVariantHash >* getContactMenuParam();
	virtual QString pluginInfo();


signals:
        void incomingNotes(QList<QDomElement> notes);
        void error();

private:
        StanzaSendingHost* stanzaSender;
        IconFactoryAccessingHost* iconHost;
        AccountInfoAccessingHost* accInfo;
        PopupAccessingHost* popup;
        bool enabled;
        //QMap<QString,int> accIndex;
        void deleteNotes();
        Notes * note;
        friend class Notes;

private slots:
        void start();

};

#endif // STORAGENOTESPLUGIN_H


