#ifndef VIEWERS_H
#define VIEWERS_H

#include <QTableView>
#include <QKeyEvent>
#include <QItemDelegate>
#include "iconfactoryaccessinghost.h"

class ClearingViewer : public QTableView
{
    Q_OBJECT

    public:
        ClearingViewer(QWidget *parent = 0) : QTableView(parent) {};
       // virtual ~ClearingViewer() {};
        void init(IconFactoryAccessingHost *iconHost);

    private:
        IconFactoryAccessingHost *iconHost_;

   protected:
        void keyPressEvent(QKeyEvent *e);
        void contextMenuEvent( QContextMenuEvent * e );

   private slots:
        void itemClicked(QModelIndex index);

};



class AvatarDelegate : public QItemDelegate
{
    Q_OBJECT

public:
    AvatarDelegate(QObject *parent) : QItemDelegate(parent) {};
    virtual QSize sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const;
    virtual void paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const;

};


#endif // VIEWERS_H
