#ifndef PIXMAPWIDGET_H
#define PIXMAPWIDGET_H

#include <QPixmap>
#include <QPen>
#include <QTextEdit>
#include <QDialog>
#include "toolbar.h"

class PixmapWidget : public QWidget
{
	Q_OBJECT
public:
	PixmapWidget(QWidget *parent);
	void setToolBar(ToolBar *bar);
	void setPixmap(QPixmap pix);
	QPixmap getPixmap() { return mainPixmap; };	

private slots:	
	void checkedButtonChanged(ToolBar::ButtonType type);
	void paintToPixmap(QString text = "");
	void newWidth(int w);
	void buttonClicked(ToolBar::ButtonType);
	void cut();
	void copy();

protected:
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	void paintEvent(QPaintEvent *);

signals:
	void adjusted();

private:
	ToolBar *bar_;
	QColor color_;
	QList<QPixmap> undoList_;
	QPixmap mainPixmap;
	ToolBar::ButtonType type_;
	QPoint p1;
	QPoint p2;
	QPen pen;
	QPen draftPen;
	QFont font_;
	QRect selectionRect;

	void saveUndoPixmap();
	void selectColor();
	void undo();	
	void rotate();
};

class GetTextDlg : public QDialog
{
	Q_OBJECT
public:
	GetTextDlg(QWidget *parent);

signals:
	void text(QString);

private slots:
	void okPressed();

private:
	QTextEdit *te;
};


#endif // PIXMAPWIDGET_H
