#include "server.h"

Server::Server(QListWidget *parent)
	: QListWidgetItem(parent)	
	, displayName_("server")
	, url_("")
	, userName_("")
	, password_("")
	, proxyHost_("")
	, proxyUserName_("")
	, proxyUserPass_("")
	, proxyPort_(0)
	, servPostdata_("")
	, servFileinput_("")
	, servRegexp_("")
{
}

void Server::setDisplayName(QString n)
{
	displayName_ = n;
}

void Server::setProxy(QString host, QString port, QString user, QString pass)
{
	proxyHost_ = host;
	proxyPort_ = port.toInt();
	proxyUserName_ = user;
	proxyUserPass_ = pass;
}

void Server::setServerData(QString post, QString fInput, QString reg/*, QString fFilter*/)
{
	servPostdata_ = post;
	servFileinput_ = fInput;
	servRegexp_ = reg;
	//servFilefilter_ = fFilter;
}

void Server::setServer(QString url, QString user, QString pass)
{
	url_ = url;
	userName_ = user;
	password_ = pass;
}

QString Server::settingsToString()
{
	QString settings = displayName_ + "&split&" + url_ + "&split&" + userName_ + "&split&" + password_ + "&split&";
	settings += proxyHost_ + "&split&" + QString::number(proxyPort_) + "&split&" + proxyUserName_ + "&split&" + proxyUserPass_ + "&split&";
	settings += servPostdata_ + "&split&" + servFileinput_ + "&split&" + servRegexp_/* + "&split&" + servFilefilter_*/;
	return settings;
}

void Server::setFromString(QString settings)
{
	QStringList l = settings.split("&split&");
	if(!l.isEmpty())
		displayName_ = l.takeFirst();
	if(!l.isEmpty())
		url_ = l.takeFirst();
	if(!l.isEmpty())
		userName_ = l.takeFirst();
	if(!l.isEmpty())
		password_ = l.takeFirst();
	if(!l.isEmpty())
		proxyHost_ = l.takeFirst();
	if(!l.isEmpty())
		proxyPort_ = l.takeFirst().toInt();
	if(!l.isEmpty())
		proxyUserName_ = l.takeFirst();
	if(!l.isEmpty())
		proxyUserPass_ = l.takeFirst();
	if(!l.isEmpty())
		servPostdata_ = l.takeFirst();
	if(!l.isEmpty())
		servFileinput_ = l.takeFirst();
	if(!l.isEmpty())
		servRegexp_ = l.takeFirst();
	/*if(!l.isEmpty())
		servFilefilter_ = l.takeFirst();*/
}
