/*
 * msgmle.h - subclass of PsiTextView to handle various hotkeys
 * Copyright (C) 2001-2003  Justin Karneges, Michail Pishchagin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef MSGMLE_H
#define MSGMLE_H

#include"psitextview.h"

class QTimer;

class ChatView : public PsiTextView
{
	Q_OBJECT
public:
	ChatView(QWidget *parent, const char *name = 0);
	~ChatView();

protected:
	// override the tab/esc behavior
	bool focusNextPrevChild(bool next);
	void keyPressEvent(QKeyEvent *);
	void resizeEvent(QResizeEvent *);

protected slots:
	void autoCopy(bool copyAvailable);
};

class ChatEdit : public PsiTextView
{
public:
	ChatEdit(QWidget *parent, const char *name = 0);
	~ChatEdit();

protected:
	// override the tab/esc behavior
	bool focusNextPrevChild(bool next);
	void keyPressEvent(QKeyEvent *);
};


class LineEdit : public ChatEdit
{
	Q_OBJECT
public:
	LineEdit(QWidget *parent, const char *name = 0);
	~LineEdit();

	QSize minimumSizeHint() const;
	QSize sizeHint() const;
	bool eventFilter(QObject *watched, QEvent *e);

public slots:
	void recalculateSize();
	void setUpdatesEnabled( bool enable );

private slots:
	void checkMoved();

protected:
	void resizeEvent( QResizeEvent * );
	bool allowResize() const;
	bool movedWindow() const;

private:
	QTimer *moveTimer;
	mutable QSize lastSize;
	mutable QRect initialWindowGeometry; // used to return window to its original location
	mutable QPoint moveTo; // used to differentiate user move message from the ones generated by LineEdit
};


#endif
