/*
 * passphrasedlg.cpp - class to handle entering of OpenPGP passphrase
 * Copyright (C) 2003  Justin Karneges
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include"passphrasedlg.h"

#include<qlineedit.h>
#include<qradiobutton.h>
#include<qpushbutton.h>
#include"iconwidget.h"

PassphraseDlg::PassphraseDlg(QWidget *parent, const char *name)
:PassphraseUI(parent, name, true, WDestructiveClose)
{
	connect(pb_ok, SIGNAL(clicked()), SLOT(doOK()));
	connect(pb_cancel, SIGNAL(clicked()), SLOT(reject()));
	resize(minimumSize());
}

PassphraseDlg::~PassphraseDlg()
{
}

QString PassphraseDlg::passphrase() const
{
	return le_pass->text();
}

void PassphraseDlg::reject()
{
	rejectPassphrase();
	QDialog::reject();
}

void PassphraseDlg::doOK()
{
	le_pass->setEnabled(false);
	pb_ok->setEnabled(false);

	submitPassphrase(le_pass->text());
}

void PassphraseDlg::unblock()
{
	le_pass->setText("");
	le_pass->setEnabled(true);
	pb_ok->setEnabled(true);
	le_pass->setFocus();
}
