/*
 * gnupg.h - OpenPGP interface to GnuPG
 * Copyright (C) 2003  Justin Karneges
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef GNUPG_H
#define GNUPG_H

#include"openpgp.h"

class GnuPG : public OpenPGP::Engine
{
	Q_OBJECT
public:
	GnuPG(QObject *parent=0);
	~GnuPG();

	void setTryAgent(bool);

	bool checkAvailability();
	QString id() const;
	QString name() const;

	void init();
	OpenPGP::KeyList secretKeys() const;
	OpenPGP::KeyList publicKeys() const;

protected:
	void encrypt(OpenPGP::Request *, const QByteArray &in, const QStringList &keys);
	void decrypt(OpenPGP::Request *, const QString &in);
	void sign(OpenPGP::Request *, const QByteArray &in, const QString &keyID);
	void verify(OpenPGP::Request *, const QByteArray &in, const QString &sig);
	void submitPassphrase(OpenPGP::Request *, const QString &);

private slots:
	void gpg_finished(bool);
	void gpg_needPassphrase();

	void req_destroyed();
	void doNext();
	void fileChanged();

public:
	class Item;
private:
	class Private;
	Private *d;

	void tryNext();

	Item *find(OpenPGP::Request *) const;
	void hook(Item *);
	OpenPGP::Request *unhook(Item *);
	OpenPGP::Request *unhookFirst();

	void handleDirtyRings();
	void doInitFinished(bool, const QString &);
};
 
#endif
