/*
 * mainwin.cpp - the main window.  holds contactlist and buttons.
 * Copyright (C) 2001-2003  Justin Karneges, Michail Pishchagin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include"mainwin.h"

#include<qmessagebox.h>
#include<qiconset.h>
#include<qtooltip.h>
#include<qstyle.h>
#include<qapplication.h>
#include<qptrlist.h>
#include<qtimer.h>
#include<qobjectlist.h>
#include<qpainter.h>
#include<qsignalmapper.h>
#include<qstatusbar.h>
#include<qmenubar.h>
#include"im.h"
#include"common.h"
#include"showtextdlg.h"
#include"psicon.h"
#include"psiaccount.h"
#include"psitoolbar.h"
#include"ui_about.h"
#include"ui_tip.h"
#include"fancylabel.h"
#include"psitoolbar.h"
#include"psipopup.h"

#include"mainwin_p.h"

using namespace XMPP;

// deletes submenus in a popupmenu
void qpopupmenuclear(QPopupMenu *p)
{
	while(p->count()) {
		QMenuItem *item = p->findItem(p->idAt(0));
		QPopupMenu *popup = item->popup();
		p->removeItemAt(0);

		if(popup)
			delete popup;
	}
}

//*******************************************************
//  MainWin
//*******************************************************

//#ifdef Q_WS_X11
//#define TOOLW_FLAGS WStyle_Customize
//#else
#define TOOLW_FLAGS 0
//#endif

MainWin::MainWin(bool _onTop, bool _asTool, PsiCon *_psi, const char *name)
:QMainWindow(0, name, 0 | (_onTop ? WStyle_StaysOnTop: 0) | (_asTool ? WStyle_Tool | TOOLW_FLAGS : 0))
{
	setIcon(is->status(STATUS_OFFLINE));

	psi = _psi;
	onTop = _onTop;
	asTool = _asTool;

	// sbState:
	//   -1 : connect
	// >= 0 : STATUS_*
	sbState = STATUS_OFFLINE;
	lastStatus = -2;

	nextAmount = 0;
	nextAnim = 0;
	tray = 0;
	trayMenu = 0;
	statusTip = "";
	infoString = "";
	nickname = "";

	QWidget *center = new QWidget (this, "Central widget");
	setCentralWidget ( center );

	vb_main = new QVBoxLayout(center, 2);
	cvlist = new ContactView(center);

	// needs finetuning...
	QActionGroup *viewGroups = new QActionGroup ( this );
	viewGroups->setMenuText (tr("View Groups"));
	viewGroups->setWhatsThis (tr("Toggle visibility of special roster groups"));
	viewGroups->setUsesDropDown (true);
	viewGroups->setExclusive (false);

	showOffline = new IconAction (tr("Show Offline Contacts"), "status/offline", tr("Show Offline Contacts"), 0, viewGroups, 0, true);
	showOffline->setWhatsThis (tr("Toggles visibility of offline contacts in roster"));
	showOffline->setOn (true);
	connect (showOffline, SIGNAL(toggled(bool)), cvlist, SLOT(setShowOffline(bool)));
	connect (cvlist, SIGNAL(showOffline(bool)), showOffline, SLOT(setOn(bool)));

	showAway = new IconAction (tr("Show Away/XA/DnD"), "status/away", tr("Show Away/XA/DnD"), 0, viewGroups, 0, true);
	showAway->setWhatsThis (tr("Toggles visibility of away/xa/dnd contacts in roster"));
	showAway->setOn (true);
	connect (showAway, SIGNAL(toggled(bool)), cvlist, SLOT(setShowAway(bool)));
	connect (cvlist, SIGNAL(showAway(bool)), showAway, SLOT(setOn(bool)));

	showHidden = new IconAction (tr("Show Hidden"), "psi/eye", tr("Show Hidden"), 0, viewGroups, 0, true);
	showHidden->setWhatsThis (tr("Toggles visibility of hidden contacts in roster"));
	showHidden->setOn (true);
	connect (showHidden, SIGNAL(toggled(bool)), cvlist, SLOT(setShowHidden(bool)));
	connect (cvlist, SIGNAL(showHidden(bool)), showHidden, SLOT(setOn(bool)));

	showAgents = new IconAction (tr("Show Agents/Transports"), tr("Show Agents/Transports"), 0, viewGroups, 0, true);
	showAgents->setWhatsThis (tr("Toggles visibility of agents/transports in roster"));
	showAgents->setIcon(is->transportStatusPtr("transport", STATUS_ONLINE));
	showAgents->setOn (true);
	connect (showAgents, SIGNAL(toggled(bool)), cvlist, SLOT(setShowAgents(bool)));
	connect (cvlist, SIGNAL(showAgents(bool)), showAgents, SLOT(setOn(bool)));

	vb_main->addWidget(cvlist, 1);

	QHBoxLayout *hb1 = new QHBoxLayout(vb_main);

	eventNotifier = new EventNotifierAction(this, "EventNotifierAction");
	eventNotifier->setWhatsThis (tr("Special item that displays number of pending events"));
	connect(eventNotifier, SIGNAL(clicked(int)), SLOT(statusClicked(int)));
	connect(eventNotifier, SIGNAL(activated()), SLOT(doRecvNextEvent()));
	eventNotifier->hide();

	lb_ssl = new IconLabel(center);
	lb_ssl->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setUsingSSL(FALSE);
	hb1->addWidget(lb_ssl);
	lb_ssl->hide();

	add_act = new MAction(IconsetFactory::icon("psi/addContact"), tr("&Add a contact"), 0, psi, this);
	connect(add_act, SIGNAL(activated(PsiAccount *, int)), SLOT(activatedAccOption(PsiAccount *, int)));

	man_act = new MAction(IconsetFactory::icon("status/online"), tr("&Manage services"), 1, psi, this);
	man_act->setIcon(is->transportStatusPtr("transport", STATUS_ONLINE));
	connect(man_act, SIGNAL(activated(PsiAccount *, int)), SLOT(activatedAccOption(PsiAccount *, int)));

	lw_act = new MAction(IconsetFactory::icon("psi/xml"), tr("&XML Console"), 2, psi, this);
	connect(lw_act, SIGNAL(activated(PsiAccount *, int)), SLOT(activatedAccOption(PsiAccount *, int)));

	actDisco = new MAction(IconsetFactory::icon("status/online"), tr("Service &Discovery"), 3, psi, this);
	actDisco->setIcon(is->transportStatusPtr("transport", STATUS_ONLINE));
	connect(actDisco, SIGNAL(activated(PsiAccount *, int)), SLOT(activatedAccOption(PsiAccount *, int)));

	actReadme = new IconAction (tr("ReadMe"), tr("&ReadMe"), 0, this);
	actReadme->setWhatsThis (tr("Show Read Me file"));
	connect (actReadme, SIGNAL(activated()), SLOT(actReadmeActivated()));

	actOnlineHelp = new IconAction (tr("Psi Handbook (Online)"), tr("Psi &Handbook (Online)"), 0, this);
	actOnlineHelp->setWhatsThis (tr("Psi Handbook (Online)"));
	connect (actOnlineHelp, SIGNAL(activated()), SLOT(actOnlineHelpActivated()));

	actBugReport = new IconAction (tr("Report a Bug"), tr("Report a &Bug"), 0, this);
	actBugReport->setWhatsThis (tr("Report a Bug"));
	connect (actBugReport, SIGNAL(activated()), SLOT(actBugReportActivated()));

	actAbout = new IconAction (tr("About"), "psi/psi16", tr("&About"), 0, this);
	connect (actAbout, SIGNAL(activated()), SLOT(actAboutActivated()));

	actAboutQt = new IconAction (tr("About Qt"), tr("About &Qt"), 0, this);
	connect (actAboutQt, SIGNAL(activated()), SLOT(actAboutQtActivated()));

	actNewMessage = new IconAction (tr("New blank message"), "psi/sendMessage", tr("New &blank message"), 0, this);
	connect (actNewMessage, SIGNAL(activated()), SIGNAL(blankMessage()));

	actJoinGroupchat = new IconAction (tr("Join Groupchat"), "psi/groupChat", tr("Join &Groupchat"), 0, this);
	connect (actJoinGroupchat, SIGNAL(activated()), SIGNAL(doGroupChat()));

	actAccountSetup = new IconAction (tr("Account Setup"), "psi/account", tr("Acc&ount Setup"), 0, this);
	connect (actAccountSetup, SIGNAL(activated()), SIGNAL(doManageAccounts()));

	actOptions = new IconAction (tr("Options"), "psi/options", tr("&Options"), 0, this);
	connect (actOptions, SIGNAL(activated()), SIGNAL(doOptions()));

	actToolbars = new IconAction(tr("Configure Toolbars"), "psi/toolbars", tr("Configure Tool&bars"), 0, this);
	connect (actToolbars, SIGNAL(activated()), SIGNAL(doToolbars()));

	actChangeProfile = new IconAction (tr("Change Profile"), "psi/profile", tr("&Change profile"), 0, this);
	connect (actChangeProfile, SIGNAL(activated()), SIGNAL(changeProfile()));

	actPlaySounds = new IconAction (tr("Play sounds"), "psi/playSounds", tr("Play &sounds"), 0, this, 0, true);
	actPlaySounds->setWhatsThis (tr("Toggles whether sound should be played or not"));
	actPlaySounds->setOn (useSound);
	connect (actPlaySounds, SIGNAL(toggled(bool)), SLOT(actPlaySoundsActivated()));

	actQuit = new IconAction (tr("Quit"), "psi/quit", tr("&Quit"), 0, this);
	actQuit->setWhatsThis (tr("Quits Psi"));
	connect (actQuit, SIGNAL(activated()), SLOT(try2tryCloseProgram()));

	actTip = new IconAction (tr("Tip of the Day"), "psi/tip", tr("&Tip of the Day"), 0, this);
	actTip->setWhatsThis (tr("See many useful tips"));
	connect (actTip, SIGNAL(activated()), SLOT(actTipActivated()));

	actFileTrans = new IconAction (tr("Transfer Manager"), "psi/filemanager", tr("Trans&fer Manager"), 0, this);
	actFileTrans->setWhatsThis (tr("Opens the Transfer Manager dialog"));
	connect (actFileTrans, SIGNAL(activated()), SIGNAL(doFileTransDlg()));

	// status actions
	statusGroup = new QActionGroup ( this );
	statusGroup->setExclusive(false);

	QSignalMapper *statusMapper = new QSignalMapper(this, "statusMapper");
	connect(statusMapper, SIGNAL(mapped(int)), SLOT(activatedStatusAction(int)));

	QString setStatusStr = tr("Changes your global status to '%1'");

	bool statusExl = true;
	statusOnline = new IconAction (status2txt(STATUS_ONLINE), "status/online", status2txt(STATUS_ONLINE), 0, statusGroup, QString::number(STATUS_ONLINE), statusExl);
	statusOnline->setWhatsThis (setStatusStr.arg(tr("Online")));
	connect (statusOnline, SIGNAL(activated()), statusMapper, SLOT(map()));
	statusMapper->setMapping(statusOnline, STATUS_ONLINE);

	statusChat = new IconAction (status2txt(STATUS_CHAT), "status/chat", status2txt(STATUS_CHAT), 0, statusGroup, QString::number(STATUS_CHAT), true);
	statusChat->setWhatsThis (setStatusStr.arg(tr("Free for Chat")));
	connect (statusChat, SIGNAL(activated()), statusMapper, SLOT(map()));
	statusMapper->setMapping(statusChat, STATUS_CHAT);

	statusGroup->addSeparator();

	statusAway = new IconAction (status2txt(STATUS_AWAY), "status/away", status2txt(STATUS_AWAY), 0, statusGroup, QString::number(STATUS_AWAY), statusExl);
	statusAway->setWhatsThis (setStatusStr.arg(tr("Away")));
	connect (statusAway, SIGNAL(activated()), statusMapper, SLOT(map()));
	statusMapper->setMapping(statusAway, STATUS_AWAY);

	statusXa = new IconAction (status2txt(STATUS_XA), "status/xa", status2txt(STATUS_XA), 0, statusGroup, QString::number(STATUS_XA), statusExl);
	statusXa->setWhatsThis (setStatusStr.arg(tr("XA")));
	connect (statusXa, SIGNAL(activated()), statusMapper, SLOT(map()));
	statusMapper->setMapping(statusXa, STATUS_XA);

	statusDnd = new IconAction (status2txt(STATUS_DND), "status/dnd", status2txt(STATUS_DND), 0, statusGroup, QString::number(STATUS_DND), statusExl);
	statusDnd->setWhatsThis (setStatusStr.arg(tr("DND")));
	connect (statusDnd, SIGNAL(activated()), statusMapper, SLOT(map()));
	statusMapper->setMapping(statusDnd, STATUS_DND);

	statusGroup->addSeparator();

	statusInvisible = new IconAction (status2txt(STATUS_INVISIBLE), "status/invisible", status2txt(STATUS_INVISIBLE), 0, statusGroup, QString::number(STATUS_INVISIBLE), statusExl);
	statusInvisible->setWhatsThis (setStatusStr.arg(tr("Invisible")));
	connect (statusInvisible, SIGNAL(activated()), statusMapper, SLOT(map()));
	statusMapper->setMapping(statusInvisible, STATUS_INVISIBLE);

	statusGroup->addSeparator();

	statusOffline = new IconAction (status2txt(STATUS_OFFLINE), "status/offline", status2txt(STATUS_OFFLINE), 0, statusGroup, QString::number(STATUS_OFFLINE), statusExl);
	statusOffline->setWhatsThis (setStatusStr.arg(tr("Offline")));
	connect (statusOffline, SIGNAL(activated()), statusMapper, SLOT(map()));
	statusMapper->setMapping(statusOffline, STATUS_OFFLINE);


	statusMenu = new QPopupMenu(this);
	optionsMenu = new QPopupMenu(this);
	buildStatusMenu();
	buildOptionsMenu();
	connect(statusMenu, SIGNAL(aboutToShow()), SLOT(buildStatusMenu()));
	connect(optionsMenu, SIGNAL(aboutToShow()), SLOT(buildOptionsMenu()));
	connect(optionsMenu, SIGNAL(activated(int)), SLOT(activatedOptionsMenu(int)));

	optionsButton = new PopupAction (tr("&Psi"), optionsMenu, this, "optionsButton");
	optionsButton->setWhatsThis (tr("The main Psi button, that provides access to many actions"));
	optionsButton->setSizePolicy ( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum ) );
	optionsButton->setIcon ( IconsetFactory::iconPtr("psi/psiMain"), false );

	statusButton = new PopupAction (tr("&Status"), statusMenu, this, "statusButton");
	statusButton->setWhatsThis (tr("Provides a convenient way to change and to get information about current status"));
	statusButton->setSizePolicy ( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding ) );
	decorateButton(STATUS_OFFLINE);

#ifdef Q_WS_MAC
	//vb_main->addSpacing(16);
	statusBar()->show();
#endif

	X11WM_CLASS("main");

	connect(psi, SIGNAL(accountCountChanged()), SLOT(numAccountsChanged()));
	numAccountsChanged();

	updateCaption();

	// create actionlist
	QAction *separatorAction = new QAction(tr("<Separator>"), tr("<Separator>"), 0, this, "qt_separator_action");
	separatorAction->setWhatsThis (tr("Separator"));

	QAction *spacerAction = new SpacerAction(this);
	spacerAction->setWhatsThis (tr("Spacer provides spacing to separate actions"));

	struct {
		const char *name;
		QAction *action;
	} actionlist[] = {
		{ "view_groups",  viewGroups  },
		{ "show_offline", showOffline },
		{ "show_away",    showAway    },
		{ "show_hidden",  showHidden  },
		{ "show_agents",  showAgents  },

		{ "---", 0 },

		{ "button_options", optionsButton },
		{ "button_status",  statusButton  },

		{ "---", 0 },

		{ "menu_disco",           actDisco         },
		{ "menu_add_contact",     add_act          },
		{ "menu_new_message",     actNewMessage    },
		//{ "menu_manage_services", man_act          },
		{ "menu_join_groupchat",  actJoinGroupchat },
		{ "menu_account_setup",   actAccountSetup  },
		{ "menu_options",         actOptions       },
		{ "menu_file_transfer",   actFileTrans     },
		{ "menu_toolbars",        actToolbars      },
		{ "menu_xml_console",     lw_act           },
		{ "menu_change_profile",  actChangeProfile },
		{ "menu_play_sounds",     actPlaySounds    },
		{ "menu_quit",            actQuit          },

		{ "---", 0 },

		{ "status_chat",      statusChat      },
		{ "status_online",    statusOnline    },
		{ "status_away",      statusAway      },
		{ "status_xa",        statusXa        },
		{ "status_dnd",       statusDnd       },
		{ "status_invisible", statusInvisible },
		{ "status_offline",   statusOffline   },

		{ "---", 0 },

		{ "separator", separatorAction },
		{ "spacer", spacerAction },
		{ "event_notifier", eventNotifier },

		{ "", 0 }
	};

	int i;
	QString aName;
	for ( i = 0; !(aName = QString(actionlist[i].name)).isEmpty(); i++ ) {
		actionList << aName;

		if ( aName != "---" )
			actions[aName] = actionlist[i].action;
	}

	buildToolbars ();

	// show tip of the day
	if ( option.showTips )
		actTipActivated();

	// create a menubar on Mac
#ifdef Q_WS_MAC
	gm = new QMenuBar(0);
	QPopupMenu *mainMenu = new QPopupMenu(this);
	gm->insertItem("Menu", mainMenu);
	mainMenu->insertItem("Preferences", this, SIGNAL(doOptions()));
	mainMenu->insertItem("Quit", this, SLOT(try2tryCloseProgram()));
	gm->show();
#endif
	connect(qApp, SIGNAL(dockActivated()), SLOT(dockActivated()));
}

MainWin::~MainWin()
{
	PsiPopup::deleteAll();

#ifdef Q_WS_MAC
	delete gm;
#endif
	if(tray) {
		delete tray;
		tray = 0;
		delete trayMenu;
		trayMenu = 0;
	}
	//saveToolbarsPositions();
	// need to find some workaround to case, when you're logging off. in that case
	// toobars are all disabled, and when you start psi again you need to enable
	// your toolbars
}

PsiCon *MainWin::psiCon() const
{
	return psi;
}

void MainWin::setWindowOpts(bool _onTop, bool _asTool)
{
	if(_onTop == onTop && _asTool == asTool)
		return;

	onTop = _onTop;
	asTool = _asTool;

	WFlags flags = 0;
	if(onTop)
		flags |= WStyle_StaysOnTop;
	if(asTool)
		flags |= WStyle_Tool | TOOLW_FLAGS;

	QPoint p = pos();
	reparent(parentWidget(), flags, p, FALSE);
	move(p);
	show();
}

void MainWin::setUseDock(bool use)
{
	if(use == false || (tray && option.isWMDock != tray->isWMDock())) {
		if(tray) {
			delete tray;
			tray = 0;
			delete trayMenu;
			trayMenu = 0;
		}

		if (use == false)
			return;
	}

	if(tray)
		return;

	trayMenu = new QPopupMenu;
	connect(trayMenu, SIGNAL(aboutToShow()), SLOT(buildTrayMenu()));

	tray = new MTray(is->status(STATUS_OFFLINE), "Psi", trayMenu);
	tray->setToolTip(PROG_NAME);
	connect(tray, SIGNAL(clicked(const QPoint &, int)), SLOT(trayClicked(const QPoint &, int)));
	connect(tray, SIGNAL(doubleClicked(const QPoint &)), SLOT(trayDoubleClicked()));
	connect(tray, SIGNAL(closed()), SIGNAL(closeProgram()));
	//connect(this, SIGNAL(statusChanged(int)), SLOT(setTrayToolTip(int)));

	updateReadNext(nextAnim, nextAmount);

	tray->show();
}

void MainWin::setInfo(const QString &str)
{
	infoString = str;

	if(nextAmount == 0)
		eventNotifier->setText(infoString);
}

void MainWin::setUsingSSL(bool use)
{
	usingSSL = use;
	lb_ssl->setIcon(usingSSL ? IconsetFactory::iconPtr("psi/cryptoYes") : IconsetFactory::iconPtr("psi/cryptoNo"));
	QToolTip::add(lb_ssl, usingSSL ? tr("Connection is encrypted") : tr("Connection is not encrypted"));
}

void MainWin::buildStatusMenu()
{
	//statusMenu->clear();
	qpopupmenuclear(statusMenu);

	statusGroup->addTo(statusMenu);
}

void MainWin::activatedStatusAction(int id)
{
	QObjectList *l = statusGroup->queryList( "QAction" );
	QObjectListIt it( *l );
	QObject *obj;
	for ( ; (obj = it.current()); ++it) {
		QAction *action = (QAction *)obj;
		action->setOn ( action->name() == QString::number(id) );
	}
	delete l;

	statusChanged(id);
}

void MainWin::buildToolbars()
{
	while ( option.toolbars.count() < toolbars.count() && toolbars.count() ) {
		PsiToolBar *tb = toolbars.last();
		toolbars.removeLast();
		delete tb;
	}

	uint i;
	for (i = 0; i < option.toolbars.count(); i++) {
		PsiToolBar *tb = 0;
		if ( i < toolbars.count() )
			tb = toolbars.at(i);

		if ( tb && !option.toolbars[i].dirty )
			continue;

		if ( tb )
			delete tb;

		tb = new PsiToolBar (option.toolbars[i].name, this, this);
		moveDockWindow ( tb, option.toolbars[i].dock, option.toolbars[i].nl, option.toolbars[i].index, option.toolbars[i].extraOffset );

		if ( option.toolbars[i].stretchable ) {
			tb->setHorizontallyStretchable (true);
			tb->setVerticallyStretchable (true);
		}

		tb->setMovingEnabled ( !option.toolbars[i].locked );

		uint j;
		QStringList keys = option.toolbars[i].keys;
		for (j = 0; j < keys.size(); j++)
			if ( actions[keys[j]] )
				actions[keys[j]]->addTo ( tb );

		if ( option.toolbars[i].on )
			tb->show();
		else
			tb->hide();

		option.toolbars[i].dirty = false;

		if ( i < toolbars.count() )
			toolbars.remove(i);
		toolbars.insert(i, tb);
	}
}

void MainWin::saveToolbarsPositions()
{
	for (uint i = 0; i < toolbars.count(); i++) {
		getLocation ( toolbars.at(i), option.toolbars[i].dock, option.toolbars[i].index, option.toolbars[i].nl, option.toolbars[i].extraOffset );
		option.toolbars[i].on = toolbars.at(i)->isVisible();
	}
}

/*void MainWin::menuAboutToShow()
{
	// TODO: don't show context menu for toolbars for now
}*/

bool MainWin::showDockMenu(const QPoint &)
{
	return false;
}

void MainWin::buildOptionsMenu()
{
	optionsMenu->clear();

	// help menu
	QPopupMenu *helpMenu = new QPopupMenu(optionsMenu);

	actReadme->addTo (helpMenu);
	actTip->addTo (helpMenu);
	helpMenu->insertSeparator();
	actOnlineHelp->addTo (helpMenu);
	actBugReport->addTo (helpMenu);
	helpMenu->insertSeparator();
	actAbout->addTo (helpMenu);
	actAboutQt->addTo (helpMenu);

	// options menu
	if(!option.lockdown.roster)
		add_act->addTo(optionsMenu);
	actNewMessage->addTo (optionsMenu);
	if(!option.lockdown.services)
		actDisco->addTo(optionsMenu);
	actJoinGroupchat->addTo (optionsMenu);
	if(!option.lockdown.accounts)
		actAccountSetup->addTo (optionsMenu);
	if(!option.lockdown.options)
		actOptions->addTo (optionsMenu);
	actFileTrans->addTo (optionsMenu); // TODO: probably we want to lock down filetransfer, right?
	lw_act->addTo(optionsMenu);
	if(!option.lockdown.profiles)
		actChangeProfile->addTo (optionsMenu);
	actPlaySounds->addTo (optionsMenu);
	optionsMenu->insertSeparator();
	optionsMenu->insertItem(IconsetFactory::icon("psi/help"), tr("&Help"), helpMenu);
	actQuit->addTo (optionsMenu);
}

void MainWin::testme()
{
	optionsMenu->setItemEnabled(10, false);
}

void MainWin::activatedOptionsMenu(int id)
{
	QString dstr; dstr.sprintf("mainwin: id=%d\n", id);
	//pdb(DEBUG_MAINWIN, dstr);

	/*if(id == 4)
		doFileSharing();
	else if(id == 6)
		accountInfo();
	else if(id == 14) {
		// hints
	}*/
}

void MainWin::actReadmeActivated ()
{
#ifdef Q_WS_WIN
	ShowTextDlg *w = new ShowTextDlg(g.pathBase + "/readme.txt");
#else
	ShowTextDlg *w = new ShowTextDlg(g.pathBase + "/README");
#endif
	w->setCaption(CAP(tr("ReadMe")));
	w->show();
}

void MainWin::actOnlineHelpActivated ()
{
	openURL("http://psi.affinix.com/psi_docs/");
}

void MainWin::actBugReportActivated ()
{
	openURL("http://psi.affinix.com/forums/index.php?act=SF&f=2");
}

void MainWin::actAboutActivated ()
{
	AboutDlg *about = new AboutDlg (this, "AboutDlg", false, WDestructiveClose);
	about->show();
}

void MainWin::actTipActivated ()
{
	TipUI *tip = new TipUI (this, "TipDlg", false, WDestructiveClose);
	tip->show();
}

void MainWin::actAboutQtActivated ()
{
	QMessageBox::aboutQt(this);
}

void MainWin::actPlaySoundsActivated ()
{
	useSound = !useSound;
}

void MainWin::activatedAccOption(PsiAccount *pa, int x)
{
	if(x == 0)
		pa->openAddUserDlg();
	else if(x == 1)
		pa->doManageServices();
	else if(x == 2)
		pa->showXmlConsole();
	else if(x == 3)
		pa->doDisco();
}

void MainWin::buildTrayMenu()
{
	if(!trayMenu)
		return;
	trayMenu->clear();

	if(nextAmount > 0) {
		trayMenu->insertItem(tr("Receive next event"), this, SLOT(doRecvNextEvent()));
		trayMenu->insertSeparator();
	}

	if(isHidden())
		trayMenu->insertItem(tr("Un&hide"), this, SLOT(trayShow()));
	else
		trayMenu->insertItem(tr("&Hide"), this, SLOT(trayHide()));
	optionsButton->addTo(trayMenu);
	statusButton->addTo(trayMenu);
	trayMenu->insertSeparator();
	actQuit->addTo(trayMenu);
}

void MainWin::setTrayToolTip(int status)
{
	if (!tray)
		return;
	tray->setToolTip(QString("Psi - " + status2txt(status)));
}

void MainWin::decorateButton(int status)
{
	// update the 'change status' buttons
	QObjectList *l = statusGroup->queryList( "QAction" );
	QObjectListIt it( *l );
	QObject *obj;
	for ( ; (obj = it.current()); ++it) {
		QAction *action = (QAction *)obj;
		action->setOn ( action->name() == QString::number(status) );
	}
	delete l;

	if(lastStatus == status)
		return;
	lastStatus = status;

	QIconSet icon;
	icon.setPixmap(is->status(status), QIconSet::Small);

	if(status == -1) {
		statusButton->setText(tr("Connecting"));
		if (option.alertStyle != 0)
			statusButton->setAlert(IconsetFactory::iconPtr("psi/connect"));
		else
			statusButton->setIcon(is->statusPtr(STATUS_OFFLINE));

		setIcon(is->status(STATUS_OFFLINE));
	}
	else {
		statusButton->setText(status2txt(status));
		statusButton->setIcon(is->statusPtr(status));

		setIcon(is->status(status));
	}

	updateTray();
}

bool MainWin::askQuit()
{
	return TRUE;
}

void MainWin::try2tryCloseProgram()
{
	QTimer::singleShot(0, this, SLOT(tryCloseProgram()));
}

void MainWin::tryCloseProgram()
{
	if(askQuit())
		closeProgram();
}

void MainWin::closeEvent(QCloseEvent *e)
{
#ifdef Q_WS_MAC
	trayHide();
	e->accept();
#else
	if(tray) {
		trayHide();
		e->accept();
		return;
	}

	if(!askQuit())
		return;

        closeProgram();
	e->accept();
#endif
}

void MainWin::keyPressEvent(QKeyEvent *e)
{
#ifdef Q_WS_MAC
	bool allowed = true;
#else
	bool allowed = tray ? true: false;
#endif

	bool closekey = false;
	if(e->key() == Key_Escape)
		closekey = true;
#ifdef Q_WS_MAC
	else if(e->key() == Key_W && e->state() & ControlButton)
		closekey = true;
#endif

	if(allowed && closekey) {
		close();
		e->accept();
		return;
	}

	QWidget::keyPressEvent(e);
}

void MainWin::updateCaption()
{
	QString str = "";

	if(nextAmount > 0)
		str += "* ";

	if(nickname.isEmpty())
		str += PROG_NAME;
	else
		str += nickname;

	if(str == caption())
		return;

	setCaption(str);
}

void MainWin::optionsUpdate()
{
	int status = lastStatus;
	lastStatus = -2;
	decorateButton(status);

	updateTray();
}

void MainWin::setTrayToolTip(const Status &status)
{
	if (!tray)
		return;
	QString s = "Psi";

 	QString show = status.show();
	if(!show.isEmpty()) {
		show[0] = show[0].upper();
		s += " - "+show;
	}

	QString text = status.status();
	if(!text.isEmpty())
		s += ": "+text;

	tray->setToolTip(s);
}

void MainWin::trayClicked(const QPoint &, int button)
{
	if(option.dockDCstyle)
		return;

	if(button == MidButton) {
		doRecvNextEvent();
		return;
	}

	if(!isHidden())
		trayHide();
	else
		trayShow();
}

void MainWin::trayDoubleClicked()
{
	if(!option.dockDCstyle)
		return;

	if(nextAmount > 0) {
		doRecvNextEvent();
		return;
	}


	if(!isHidden())
		trayHide();
	else
		trayShow();
}

void MainWin::trayShow()
{
	bringToFront(this);
}

void MainWin::trayHide()
{
	emit geomChanged(x(), y(), width(), height());
	hide();
}

void MainWin::updateReadNext(Icon *anim, int amount)
{
#ifdef Q_WS_MAC
	if(amount > 0)
		bounceDockTile();
	else
		stopDockTileBounce();
#endif

	nextAnim = anim;
	if(anim == 0)
		nextAmount = 0;
	else
		nextAmount = amount;

	if(nextAmount <= 0) {
		eventNotifier->hide();
		eventNotifier->setText("");
	}
	else {
		eventNotifier->setText(QString("<b>") + numEventsString(nextAmount) + "</b>");
		eventNotifier->show();
		// make sure it shows
		//qApp->processEvents();
	}

	updateTray();
	updateCaption();
}

QString MainWin::numEventsString(int x) const
{
	QString s;
	if(x <= 0)
		s = "";
	else if(x == 1)
		s = tr("1 event received");
	else
		s = tr("%1 events received").arg(x);

	return s;
}

void MainWin::updateTray()
{
	if(!tray)
		return;

	if ( nextAmount > 0 )
		tray->setAlert(nextAnim);
	else if ( lastStatus == -1 )
		tray->setAlert(IconsetFactory::iconPtr("psi/connect"));
	else
		tray->setIcon(is->statusPtr(lastStatus));
}

void MainWin::doRecvNextEvent()
{
	recvNextEvent();
}

void MainWin::statusClicked(int x)
{
	if(x == MidButton)
		recvNextEvent();
}

void MainWin::numAccountsChanged()
{
	bool enabled = psi->accountList(TRUE).isEmpty() ? false : true;
	statusButton->setEnabled (enabled);
	//actNewMessage->setEnabled (enabled);
	//actJoinGroupchat->setEnabled (enabled);
}

void MainWin::dockActivated()
{
	if(isHidden())
		show();
}

#if defined(Q_WS_WIN)
#include<windows.h>
void MainWin::showNoFocus()
{
	clearWState( WState_ForceHide );

	if ( testWState(WState_Visible) ) {
		SetWindowPos(winId(),HWND_TOPMOST,0,0,0,0, SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE);
		if(!onTop)
			SetWindowPos(winId(),HWND_NOTOPMOST,0,0,0,0, SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE);
		return; // nothing to do
	}

	if ( isTopLevel() && !testWState( WState_Resized ) )  {
		// do this before sending the posted resize events. Otherwise
		// the layout would catch the resize event and may expand the
		// minimum size.
		QSize s = sizeHint();
		QSizePolicy::ExpandData exp;
#ifndef QT_NO_LAYOUT
		if ( layout() ) {
			if ( layout()->hasHeightForWidth() )
				s.setHeight( layout()->totalHeightForWidth( s.width() ) );
			exp =  layout()->expanding();
		} else
#endif
		{
			if ( sizePolicy().hasHeightForWidth() )
				s.setHeight( heightForWidth( s.width() ) );
			exp = sizePolicy().expanding();
		}
		if ( exp & QSizePolicy::Horizontally )
			s.setWidth( QMAX( s.width(), 200 ) );
		if ( exp & QSizePolicy::Vertically )
			s.setHeight( QMAX( s.height(), 150 ) );
		QRect screen = QApplication::desktop()->screenGeometry( QApplication::desktop()->screenNumber( pos() ) );
		s.setWidth( QMIN( s.width(), screen.width()*2/3 ) );
		s.setHeight( QMIN( s.height(), screen.height()*2/3 ) );
		if ( !s.isEmpty() )
			resize( s );
	}

	QApplication::sendPostedEvents( this, QEvent::Move );
	QApplication::sendPostedEvents( this, QEvent::Resize );

	setWState( WState_Visible );

	if ( testWFlags(WStyle_Tool) || isPopup() ) {
		raise();
	} else if ( testWFlags(WType_TopLevel) ) {
		while ( QApplication::activePopupWidget() )
		QApplication::activePopupWidget()->close();
	}

	if ( !testWState(WState_Polished) )
		polish();

	if ( children() ) {
		QObjectListIt it(*children());
		register QObject *object;
		QWidget *widget;
		while ( it ) {				// show all widget children
			object = it.current();		//   (except popups and other toplevels)
			++it;
			if ( object->isWidgetType() ) {
				widget = (QWidget*)object;
				if ( !widget->isHidden() && !widget->isTopLevel() )
				widget->show();
			}
		}
	}

#if defined(QT_ACCESSIBILITY_SUPPORT)
	QAccessible::updateAccessibility( this, 0, QAccessible::ObjectShow );
#endif

	SetWindowPos(winId(),HWND_TOP,0,0,0,0, SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
	UpdateWindow(winId());
}

#else

void MainWin::showNoFocus()
{
	bringToFront(this);
}

#endif
