/*
 * @BEGIN LICENSE
 *
 * Psi4: an open-source quantum chemistry software package
 *
 * Copyright (c) 2007-2018 The Psi4 Developers.
 *
 * The copyrights for code used from other parties are included in
 * the corresponding files.
 *
 * This file is part of Psi4.
 *
 * Psi4 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 3.
 *
 * Psi4 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along
 * with Psi4; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * @END LICENSE
 */

#ifndef dispersion_defines_h
#define dispersion_defines_h

// All values in atomic units
// For C6, this means hartree * bohr^6 (if original values in J nm^6 mol^-1, mult by 17.34525495)
// For C8, this means hartree * bohr^8 (if original values in J nm^8 mol^-1, mult by 6194.102092)

// Atom Order: Gh, H, He, ...
// For -DAS2010, last 6 values for C6, C8, and Beta are for hydrogen pairs
// ***Depends on closest covelently-bonded atom to hydrogen 


namespace psi { 
const double RvdW_D1_[] = 
{
    2.30546570658000,
    2.09759584779000,
    2.12102845005360,
    1.72909927993500,
    2.95099610442240,
    3.11237870388300,
    3.04245884229000,
    2.92907528295000,
    2.81569172361000,
    2.70230816427000,
    2.60782186482000,
    2.39768433484320,
    2.85877747615920,
    3.43514390280420,
    3.59652650226480,
    3.57347184519900,
    3.52736253106740,
    3.43514390280420,
    3.34292527454100,
    3.11237870388300,
    3.08932404681720,
    3.27376130334360,
    3.27376130334360,
    3.27376130334360,
    3.27376130334360,
    3.27376130334360,
    3.27376130334360,
    3.27376130334360,
    3.27376130334360,
    3.27376130334360,
    3.27376130334360,
    3.45819855987000,
    3.61958115933060,
    3.68874513052800,
    3.71179978759380,
    3.66569047346220,
    3.61958115933060,
    3.41208924573840,
    3.36597993160680,
    3.43514390280420,
    3.43514390280420,
    3.43514390280420,
    3.43514390280420,
    3.43514390280420,
    3.43514390280420,
    3.43514390280420,
    3.43514390280420,
    3.43514390280420,
    3.43514390280420,
    3.50430787400160,
    3.78096375879120,
    3.94234635825180,
    3.96540101531760,
    3.96540101531760,
    3.94234635825180,
};
const double C6_D1_[] = 
{
    0.0000000000000000E+00,
    2.7752404318197200E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    2.8619666953140900E+01,
    1.9253230495749300E+01,
    1.2141676889211300E+01,
    9.8867940383577600E+00,
    7.8053637144929700E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00
};
const double RvdW_D2_[] = 
{
    2.07869858790000,
    1.89161571498900,
    1.91240270086800,
    1.55902394092500,
    2.66073419251200,
    2.80624309366500,
    2.74388213602800,
    2.63994720663300,
    2.53601227723800,
    2.43207734784300,
    2.34892940432700,
    2.16184653141600,
    2.57758624899600,
    3.09726089597100,
    3.24276979712400,
    3.22198281124500,
    3.18040883948700,
    3.09726089597100,
    3.01411295245500,
    2.80624309366500,
    2.78545610778600,
    2.95175199481800,
    2.95175199481800,
    2.95175199481800,
    2.95175199481800,
    2.95175199481800,
    2.95175199481800,
    2.95175199481800,
    2.95175199481800,
    2.95175199481800,
    2.95175199481800,
    3.11804788185000,
    3.26355678300300,
    3.32591774064000,
    3.34670472651900,
    3.30513075476100,
    3.26355678300300,
    3.07647391009200,
    3.03489993833400,
    3.09726089597100,
    3.09726089597100,
    3.09726089597100,
    3.09726089597100,
    3.09726089597100,
    3.09726089597100,
    3.09726089597100,
    3.09726089597100,
    3.09726089597100,
    3.09726089597100,
    3.15962185360800,
    3.40906568415600,
    3.55457458530900,
    3.57536157118800,
    3.57536157118800,
    3.55457458530900
};
const double C6_D2_[] =
{
    0.0000000000000000E+00,
    2.4283353778422600E+00,
    1.3876202159098600E+00,
    2.7925856845186000E+01,
    2.7925856845186000E+01,
    5.4290640947473300E+01,
    3.0354192223028200E+01,
    2.1334660819614100E+01,
    1.2141676889211300E+01,
    1.3008939524155000E+01,
    1.0927509200290200E+01,
    9.9041392910566400E+01,
    9.9041392910566400E+01,
    1.8715527662084300E+02,
    1.6009668241060000E+02,
    1.3598678115916600E+02,
    9.6613057532724100E+01,
    8.7940431183287500E+01,
    7.9961614941805800E+01,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    1.8732872914783100E+02,
    2.9469584335385700E+02,
    2.9660382115073300E+02,
    2.8394178668055500E+02,
    2.1924399411375800E+02,
    2.1629530115495000E+02,
    2.0831648491346800E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    4.2790738408120400E+02,
    6.4732483072195000E+02,
    6.7143473197338400E+02,
    6.6675151374468900E+02,
    5.5053832066223800E+02,
    5.4637546001450800E+02,
    5.2018412843920900E+02
};
const double R_cov_[] = {
    1.8897259890000000,
    0.6047123164800000,
    0.8692739549400000,
    2.2676711868000000,
    1.7763424296600000,
    1.4550890115300000,
    1.4172944917500000,
    1.3417054521900000,
    1.1905273730700000,
    1.2094246329600000,
    1.2661164126300000,
    2.6456163846000000,
    2.3621574862500000,
    2.1353903675700000,
    1.9653150285600000,
    2.0786985879000000,
    1.9275205087800000,
    1.8708287291100000,
    1.8141369494400000,
    3.3259177406400000,
    2.9101780230600000,
    2.5133355653700000,
    2.3054657065800000,
    2.2865684466900000,
    2.0786985879000000,
    2.0220068082300000,
    1.9653150285600000,
    1.8897259890000000,
    1.8708287291100000,
    1.9086232488900000,
    2.0598013280100000,
    2.1164931076800000,
    2.0598013280100000,
    2.1731848873500000,
    2.0786985879000000,
    2.1542876274600000,
    2.2109794071300000,
    3.5715821192100000,
    3.1558424016300000,
    2.7778972038300000,
    2.6267191247100000,
    2.4944383054800000,
    2.3432602263600000,
    2.1731848873500000,
    2.1353903675700000,
    2.1353903675700000,
    2.0409040681200000,
    2.1731848873500000,
    2.3243629664700000,
    2.4188492659200000,
    2.3810547461400000,
    2.3810547461400000,
    2.3243629664700000,
    2.4944383054800000,
    2.4755410455900000,
    3.9495273170100000,
    3.3259177406400000,
    3.0613561021800000,
    2.7778972038300000,
    2.9857670626200000,
    2.9668698027300000,
    2.9479725428400000,
    2.9290752829500000,
    2.8534862433900000,
    2.8723835032800000,
    2.8534862433900000,
    2.8345889835000000,
    2.8156917236100000,
    2.8156917236100000,
    2.7967944637200000,
    2.8912807631700000,
    2.7589999439400000,
    2.5889246049300000,
    2.4755410455900000,
    2.3243629664700000,
    2.2298766670200000,
    2.1920821472400000,
    2.0975958477900000,
    2.1164931076800000,
    2.1353903675700000,
    2.4944383054800000,
    2.4566437857000000,
    2.4566437857000000,
    2.5700273450400000,
    2.4755410455900000,
    2.6078218648200000,
    2.6834109043800000,
    3.7983492378900000,
    3.4204040400900000,
    3.1558424016300000,
    2.9857670626200000,
    2.8723835032800000,
    2.8912807631700000,
    2.9101780230600000,
    2.9290752829500000
};
const double C6_Das2009_[] =
{
    0.0000000000000000E+00,
    2.9937910040000000E+00,
    1.4431252120000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.9948777720000000E+01,
    1.7203023860000000E+01,
    1.1210238270000000E+01,
    7.1271652590000000E+00,
    5.4793660390000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.0152351170000000E+02,
    9.0724356020000000E+01,
    5.3338393500000000E+01,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00
};
const double C8_Das2009_[] =
{
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    2.2918177740000000E+01,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.5516225740000000E+03,
    1.5621525480000000E+03,
    1.3763294850000000E+03,
    3.6483261320000000E+02,
    1.6847957690000000E+02,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    2.4351492960000000E+04,
    6.9454466760000000E+03,
    3.8998066770000000E+03,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00
};
const double Beta_Das2009_[] =
{
    0.0000000000000000E+00,
    2.8580000000000000E+00,
    1.8336000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.1128000000000000E+00,
    1.7952000000000000E+00,
    1.7221000000000000E+00,
    1.2906000000000000E+00,
    1.8120000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.6678000000000000E+00,
    1.7074000000000000E+00,
    1.2277000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00
};
const double A_Das2009_[] =
{
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.3844896562000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.6056369167000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.6791323813000000E+00,
    1.8358084730000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.0516389670000000E+01,
    6.7744354630000000E+00,
    2.2513920030000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00
};
const double C6_Das2010_[] =
{
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.1343796700000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    2.6520894820000000E+01,
    1.8226393900000000E+01,
    1.4630722550000000E+01,
    9.0230016200000000E+00,
    4.0848075400000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.3906211250000000E+02,
    8.5711577340000000E+01,
    5.1196254510000000E+01,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.3962930200000000E+00,  // H-C
    3.2106066900000000E+00,  // H-N
    2.7787098400000000E+00,  // H-O
    1.6651444800000000E+00,  // H-F
    3.0180743600000000E+00,  // H-S
    4.0501170300000000E+00   // H-Cl
};
const double C8_Das2010_[] =
{
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    3.2828741090000000E+01,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.0214074350000000E+03,
    7.9532270860000000E+02,
    1.3007614390000000E+02,
    6.8630651180000000E+02,
    2.1865180390000000E+02,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.3038584900000000E+03,
    6.3532905180000000E+03,
    4.2008400390000000E+03,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    8.7956249710000000E+01,  // H-C
    1.6104665440000000E+01,  // H-N
    1.6724075650000000E+01,  // H-O
    0.0000000000000000E+00,  // H-F
    3.5430263966000000E+02,  // H-S
    1.8582306300000000E+00   // H-Cl
};
const double Beta_Das2010_[] =
{
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    2.3164000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.9509000000000000E+00,
    2.2992000000000000E+00,
    2.4256000000000000E+00,
    1.9457000000000000E+00,
    2.1363000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    2.7729000000000000E+00,
    1.5878000000000000E+00,
    1.8374000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    0.0000000000000000E+00,
    1.4632000000000000E+00,  // H-C
    1.7192000000000000E+00,  // H-N
    1.7726000000000000E+00,  // H-O
    2.1695000000000000E+00,  // H-F
    1.3654000000000000E+00,  // H-S
    2.0669000000000000E+00,  // H-Cl
};
double R_0_AB_[] = {
    1.8897259890000000,
    4.1239490257947000,
    3.5048747917983000,
    3.2781076731183000,
    5.4964570116054000,
    4.8626429148948000,
    6.6057261671484000,
    4.4503047040950000,
    4.7422673693955000,
    5.6317613924178000,
    5.8547490591198000,
    4.7509601089449000,
    4.5196576478913000,
    5.6648315972253000,
    5.5716681059676000,
    6.0773587806240000,
    4.6283168922588000,
    4.2569857354203000,
    6.0344620006737000,
    5.7096181031646000,
    5.5805498181159000,
    5.4996695457867000,
    4.4724144981663000,
    4.0304075893392000,
    5.4393872867376000,
    5.2269820855740000,
    5.2489029070464000,
    5.1141654440307000,
    4.9558064061525000,
    4.1135555328552000,
    3.8975598523125000,
    4.9879317479655000,
    5.0357418154872000,
    5.0043723640698000,
    4.8560288739333000,
    4.6952131922694000,
    4.6897329869013000,
    3.9015282768894000,
    3.7588539647199000,
    4.7405666160054000,
    5.0848746912012000,
    4.9573181869437000,
    4.6808512747530000,
    4.5136105247265000,
    4.4429347727379000,
    4.3456138843044000,
    3.7590429373188000,
    3.6379115014239000,
    4.5712471673910000,
    4.8136990117797000,
    4.7231811369066000,
    4.5525388800999000,
    4.3796289521064000,
    4.2653005297719000,
    4.1471926554594000,
    4.0391003288886000,
    5.6499027619122000,
    4.9883096931633000,
    6.8088717109659000,
    5.8995355650591000,
    7.1091491706180000,
    6.1387748752665000,
    5.5476685859073000,
    5.1198346219977000,
    4.8719025722409000,
    4.6938903840771000,
    7.0074819124098000,
    4.7486924377581000,
    5.1629203745469000,
    5.8679771410428000,
    6.2289148049418000,
    5.9207004961359000,
    6.0471231648000000,
    5.5909433110554000,
    5.8245134432958000,
    5.4012148217598000,
    5.1249368821680000,
    6.1548375461730000,
    6.5836163730771000,
    5.4359857799574000,
    5.1829514700303000,
    6.1937659015464000,
    6.1157202182007000,
    6.7895965058781000,
    6.2032145314914000,
    5.8413320045979000,
    5.5499362570941000,
    5.4858745460670000,
    5.2513595508321000,
    6.4101395272869000,
    6.4193991846330000,
    7.5789350514834000,
    5.4582845466276000,
    5.0276159937345000,
    7.0889291025357000,
    5.9739907690257000,
    6.3504241860345000,
    6.2975118583425000,
    5.8564498125099000,
    5.5363302299733000,
    5.4186003008586000,
    5.2101635242719000,
    7.2053362234581000,
    6.2863624750074000,
    7.0118282821845000,
    7.1652740324913000,
    5.3486804392656000,
    4.8259822307082000,
    6.4122182258748000,
    5.8946222774877000,
    6.0218008365474000,
    5.9044488526305000,
    5.7570502254885000,
    5.4286158486003000,
    5.2277379759696000,
    5.0882761979814000,
    6.5399637027312000,
    6.2330722021176000,
    6.6408750705438000,
    6.6930315078402000,
    6.6172534956813000,
    4.9491923651910000,
    4.6859535349233000,
    5.9207004961359000,
    5.7712231704060000,
    5.7921991288839000,
    5.6463122825331000,
    5.4904098884406000,
    5.4433557113145000,
    5.1646211279370000,
    4.9758375016359000,
    6.0652645342944000,
    6.7402746575652000,
    6.3653530213476000,
    6.3657309665454000,
    6.2701108315020000,
    6.2563158317823000,
    4.6783946309673000,
    4.5389328529791000,
    5.6293047486321000,
    5.9465897421852000,
    5.6253363240552000,
    5.4514815330672000,
    5.2821620844528000,
    5.1886206479973000,
    5.0797724310309000,
    4.8618870244992000,
    5.7776482387686000,
    6.2859845298096000,
    6.3422983642818000,
    6.1470896696181000,
    6.0312494664924000,
    5.9569832351247000,
    5.8668433054494000,
    4.4833749089025000,
    4.4009828557821000,
    5.4348519443640000,
    5.6321393376156000,
    5.4977798197977000,
    5.2987916731560000,
    5.1156772248219000,
    4.9862309945754000,
    4.8603752437080000,
    4.7505821637471000,
    5.5779042017313000,
    5.9726679608334000,
    6.0631858357065000,
    5.9889196043388000,
    5.8547490591198000,
    5.7356963218128000,
    5.6181553652970000,
    5.5081733127372000,
    6.0749021368383000,
    5.3507591378535000,
    7.3177749198036000,
    6.5424203465169000,
    7.3364832070947000,
    6.3797149388640000,
    5.8101515257794000,
    5.4456233825013000,
    5.2065730448928000,
    5.0276159937345000,
    7.5097710802860000,
    6.8392962993888000,
    6.9105389691741000,
    7.4806693000554000,
    6.8385404089932000,
    6.4093836368913000,
    6.1376410396731000,
    5.9401646738226000,
    8.0145168919479000,
    5.2150768118433000,
    5.7802938551532000,
    6.3256687755786000,
    6.8434536965646000,
    6.4917756900117000,
    6.5628293871981000,
    6.1391528204643000,
    6.2738902834800000,
    5.8418989223946000,
    5.5563613254567000,
    6.6087497287308000,
    7.1796359500077000,
    6.9490893793497000,
    7.3090821802542000,
    6.7667308214112000,
    7.2268790997327000,
    6.7701323281914000,
    6.4545480880284000,
    7.3255227963585000,
    7.7544905958615000,
    5.1704792785029000,
    5.6247694062585000,
    6.1368851492775000,
    6.6147968518956000,
    6.4600282933965000,
    6.4965000049842000,
    6.0629968631076000,
    6.1958446001343000,
    5.7833174167356000,
    5.5155432440943000,
    6.4320603487593000,
    6.9464437629651000,
    6.9137515033554000,
    7.2427527980403000,
    6.6843387682908000,
    7.1176529375685000,
    6.6726224671590000,
    6.3683765829300000,
    7.1408965672332000,
    7.5218653266156000,
    7.3516010150067000,
    5.0705127736848000,
    5.4915437240340000,
    6.1629633679257000,
    6.4929095256051000,
    6.3377630219082000,
    6.3986121987540000,
    5.9620854952950000,
    6.1038149444700000,
    5.6943113226537000,
    5.4303166019904000,
    6.4296037049736000,
    6.8298476694438000,
    6.7990451358231000,
    6.6697878781755000,
    6.5826715100826000,
    7.0184423231460000,
    6.5728449349398000,
    6.2682211055130000,
    7.0740002672226000,
    7.4876612862147000,
    7.2151627986009000,
    7.1133065677938000,
    4.9849081863831000,
    5.3845852330566000,
    6.0168875489760000,
    6.4675871973525000,
    6.1928210385519000,
    6.3118737758589000,
    5.8717565930208000,
    6.0253913159265000,
    5.6151318037146000,
    5.3515150282491000,
    6.2956221323535000,
    6.7990451358231000,
    6.6624179468184000,
    6.6102615095220000,
    6.4961220597864000,
    6.9379399960146000,
    6.4904528818194000,
    6.1837503538047000,
    6.9653410228551000,
    7.3670967681165000,
    7.1654630050902000,
    7.0622839660908000,
    7.0318593776679000,
    5.5236690658470000,
    4.9554284609547000,
    6.4554929510229000,
    5.4800163955011000,
    5.7744357045873000,
    6.2942993241612000,
    5.7740577593895000,
    5.3872308494412000,
    5.1750146208765000,
    5.0342300346960000,
    6.6637407550107000,
    5.7215233768953000,
    6.2342060377110000,
    7.1282354031069000,
    6.6172534956813000,
    6.1890415865739000,
    5.9276924822952000,
    5.7513810475215000,
    7.1569592381397000,
    6.2092616546562000,
    6.0735793286460000,
    5.9955336453003000,
    6.0807602874042000,
    6.5033030185446000,
    4.8169115459610000,
    5.2199900994147000,
    5.8564498125099000,
    6.2837168586228000,
    6.0161316585804000,
    6.1280034371292000,
    5.7181218701151000,
    5.9006694006525000,
    5.4862524912648000,
    5.2196121542169000,
    6.1397197382610000,
    6.6348279473790000,
    6.5061376075281000,
    6.3957776097705000,
    6.3445660354686000,
    6.8115173273505000,
    6.3604397337762000,
    6.0495798085857000,
    6.8238005462790000,
    7.2265011545349000,
    7.0089936932010000,
    6.8967439694544000,
    6.8659414358337000,
    5.8384974156144000,
    6.7013463021918000,
    4.7103310001814000,
    5.1279604437504000,
    5.8001359780377000,
    6.1792150114311000,
    5.9095511128008000,
    6.0269030967177000,
    5.6045493381762000,
    5.8528593331308000,
    5.4382534511442000,
    5.1699123607062000,
    6.0860515201734000,
    6.5320268535774000,
    6.4054152123144000,
    6.2846617216173000,
    6.2258912433594000,
    6.7449989725377000,
    6.2950552145568000,
    5.9847622071630000,
    6.7661639036145000,
    7.1263456771179000,
    6.9043028734104000,
    6.7892185606803000,
    6.7604947256475000,
    5.7468457051479000,
    6.5923091126265000,
    6.5046258267369000,
    4.6613870970663000,
    5.0472691440201000,
    5.7778372113675000,
    6.1145863826073000,
    5.8407650868012000,
    5.9596288515093000,
    5.5246139288415000,
    5.7956006356641000,
    5.3811837262764000,
    5.1124646906406000,
    6.0592174111296000,
    6.5231451414291000,
    6.3481565148477000,
    6.2211669283869000,
    6.1561603543653000,
    6.0775477532229000,
    6.2326942569198000,
    5.9222122769271000,
    6.7285583564334000,
    7.1019682118598000,
    6.8846497231248000,
    6.7714551363837000,
    6.7446210273399000,
    5.6996025554229000,
    6.5785141129068000,
    6.4891300736271000,
    6.4868624024403000,
    4.6326632620335000,
    4.9771603098282000,
    5.7657429650379000,
    6.0903978899481000,
    5.7882307043070000,
    5.9082283046085000,
    5.4630088616001000,
    5.7169880345217000,
    5.3260037273976000,
    5.0576626369596000,
    6.0410760416352000,
    6.4466112388746000,
    6.3290702823588000,
    6.1777032306399000,
    6.1075943964480000,
    6.0066830286354000,
    6.1756245320520000,
    5.8649535794604000,
    6.6996455488017000,
    7.0409300624151000,
    6.8200210943010000,
    6.7034250007797000,
    6.6758350013403000,
    5.6725794737802000,
    6.5031140459457000,
    6.4074939109023000,
    6.3481565148477000,
    6.3234011043918000,
    4.6133880569457000,
    4.9144214069934000,
    5.7712231704060000,
    6.0446665210143000,
    5.7617745404610000,
    5.8691109766362000,
    5.4127421502927000,
    5.6593513918572000,
    5.2738472901012000,
    5.0060731174599000,
    6.0376745348550000,
    6.4103284998858000,
    6.2958111049524000,
    6.1576721351565000,
    6.0728234382504000,
    5.9556604269324000,
    6.1159091907996000,
    5.8112853613728000,
    6.6835828778952000,
    7.0140959533713000,
    6.7918641770649000,
    6.6731893849557000,
    6.6450324677196000,
    5.6619970082418000,
    6.4675871973525000,
    6.3681876103311000,
    6.3060156252930000,
    6.2803153518426000,
    6.2376075444912000,
    4.5954356600502000,
    4.8620759970981000,
    5.7477905681424000,
    5.9789040565971000,
    5.7062165963844000,
    5.8284818678727000,
    5.3692784525457000,
    5.1846522234204000,
    5.2171555104312000,
    4.9644991457019000,
    6.0114073436079000,
    6.3477785696499000,
    6.2445995306505000,
    6.1130746018161000,
    6.0361627540638000,
    5.9131415921799000,
    6.0680991232779000,
    5.7700893348126000,
    6.6497567826921000,
    6.9558923929101000,
    6.7340385618015000,
    6.6142299340989000,
    6.5864509620606000,
    5.6421548853573000,
    6.4056041849133000,
    6.3046928171007000,
    6.2411980238703000,
    6.2153087778210000,
    6.1709002170795000,
    6.1055156978601000,
    5.3860970138478000,
    5.0897879787726000,
    6.1353733684863000,
    6.0321943294869000,
    6.7393297945707000,
    6.1493573408049000,
    5.7770813209719000,
    5.4892760528472000,
    5.4153877666773000,
    5.1850301686182000,
    6.3394637752983000,
    6.3324717891390000,
    7.5281014223793000,
    6.9676086940419000,
    6.5879627428518000,
    6.3096061046721000,
    6.1251688481457000,
    5.9919431659212000,
    6.8211549298944000,
    6.8559258880920000,
    6.9655299954540000,
    6.7213773976752000,
    6.5830494552804000,
    6.2111513806452000,
    6.4239345270066000,
    6.3260467207764000,
    6.2682211055130000,
    6.2266471337550000,
    6.2122852162386000,
    6.1616405597334000,
    7.4793464918631000,
    5.5229131754514000,
    5.0716466092782000,
    7.1558254025463000,
    5.9964785082948000,
    6.4008798699408000,
    6.3576051447927000,
    5.9086062498063000,
    5.5824395441049000,
    5.3866639316445000,
    5.2498477700409000,
    7.2707207426775000,
    6.2995905569304000,
    7.0598273223051000,
    7.2312254695074000,
    6.7525578764937000,
    6.4173204860451000,
    6.1935769289475000,
    6.0310604938935000,
    7.5358492989342000,
    7.3351603989024000,
    6.7671087666090000,
    6.6828269874996000,
    6.6253793174340000,
    7.1992891002933000,
    6.4108954176825000,
    6.3018582281172000,
    6.2396862430791000,
    6.1975453535244000,
    6.1722230252718000,
    6.1348064506896000,
    7.0176864327504000,
    7.2979327969191000,
    5.5066615319460000,
    4.9644991457019000,
    6.5707662363519000,
    6.0044153574486000,
    6.1529478201840000,
    6.0414539868330000,
    5.8972678938723000,
    5.5569282432534000,
    5.3520819460458000,
    5.2101635242719000,
    6.7000234939995000,
    6.3332276795346000,
    6.7722110267793000,
    6.8364617104053000,
    6.7682426022024000,
    6.4065490479078000,
    6.1612626145356000,
    5.9813607003828000,
    6.9989781454593000,
    6.8564928058887000,
    6.7761794513562000,
    6.6764019191370000,
    6.5921201400276000,
    6.7631403420321000,
    6.4428317868966000,
    6.3254798029797000,
    6.2583945303702000,
    6.2126631614364000,
    6.1807267922223000,
    6.1455778888269000,
    6.7217553428730000,
    6.8967439694544000,
    6.9211214347125000,
    5.1589519499700000,
    4.8887211335430000,
    6.1361292588819000,
    5.9501802215643000,
    5.9841952893663000,
    5.8418989223946000,
    5.6893980350823000,
    5.6336511184068000,
    5.3479245488700000,
    5.1559283883876000,
    6.2850396668151000,
    6.2704887766998000,
    6.5586719900223000,
    6.5664198665772000,
    6.4777917176931000,
    6.4594613755998000,
    6.1504911763983000,
    5.9248578933117000,
    6.6359617829724000,
    7.4515675198248000,
    7.3374280700892000,
    7.2382174556667000,
    7.1582820463320000,
    6.3797149388640000,
    7.0331821858602000,
    6.3131965840512000,
    6.2472451470351000,
    6.1790260388322000,
    6.1314049439094000,
    6.0903978899481000,
    6.5048147993358000,
    6.6183873312747000,
    6.6157417148901000,
    6.6646856180052000,
    4.9182008589714000,
    4.7914002451095000,
    5.8825280311581000,
    6.2102065176507000,
    5.8636307712681000,
    5.6895870076812000,
    5.5231021480503000,
    5.4223797528366000,
    5.3118307824801000,
    5.0888431157781000,
    6.0391863156462000,
    6.5516800038630000,
    6.4284698693802000,
    6.3882187058145000,
    6.2772917902602000,
    6.2011358329035000,
    6.1125076840194000,
    5.8570167303066000,
    6.4131630888693000,
    7.0422528706074000,
    6.9347274618333000,
    6.8340050666196000,
    6.7519909586970000,
    6.1457668614258000,
    6.6236785640439000,
    6.5547035654454000,
    6.4921536352095000,
    6.4409420609076000,
    6.3774472676772000,
    6.3298261727544000,
    6.3668648021388000,
    6.4348949377428000,
    6.4080608286990000,
    6.3965335001661000,
    6.3611956241718000,
    4.7407555886043000,
    4.6891660691046000,
    5.7143424181371000,
    5.9171100167568000,
    5.7702783074115000,
    5.5665658457973000,
    5.3849631782544000,
    5.2496587974420000,
    5.2587294821892000,
    5.0138209940148000,
    5.8700558396307000,
    6.2631188453427000,
    6.3398417204961000,
    6.2587724755680000,
    6.1266806289369000,
    6.0068720012343000,
    5.8914097433064000,
    5.7850181701257000,
    6.2515915168098000,
    6.7567152736695000,
    6.6559928784558000,
    6.5531917846542000,
    6.4687210329459000,
    5.9874078235476000,
    6.3358732959192000,
    6.2667093247218000,
    6.2034035040903000,
    6.1467117244203000,
    6.1053267252612000,
    6.0526033701681000,
    6.2687880233097000,
    6.3009133651227000,
    6.2534812427988000,
    6.1973563809255000,
    6.1325387795028000,
    6.0652645342944000,
    6.2158756956177000,
    5.4785046147099000,
    7.6322253243732000,
    6.8219108202900000,
    7.4432527254732000,
    6.5148303470775000,
    5.9696443992510000,
    5.6336511184068000,
    5.4019707121554000,
    5.2313284553487000,
    7.8287568272292000,
    7.1641401968979000,
    7.2234775929525000,
    7.6292017627908000,
    7.0031355426351000,
    6.6017577425715000,
    6.3360622685181000,
    6.1400976834588000,
    8.3813127064128000,
    7.7149953226914000,
    7.5084482720937000,
    7.4179303972206000,
    7.3030350570894000,
    7.4294577257535000,
    7.1501562245793000,
    7.0798584177885000,
    7.0318593776679000,
    6.9942538304868000,
    6.9717660912177000,
    6.9307590372564000,
    7.1310699920904000,
    7.6836258712740000,
    7.1669747858814000,
    6.8328712310262000,
    6.6172534956813000,
    6.4564378140174000,
    8.7259987268064000,
    5.4397652319354000,
    5.9824945359762000,
    6.7695654103947000,
    7.1221882799421000,
    6.7580380818618000,
    6.7631403420321000,
    6.3404086382928000,
    6.4258242529956000,
    5.9945887823058000,
    5.7092401579668000,
    7.0375285556349000,
    7.4840708068356000,
    7.2754450576500000,
    7.5294242305716000,
    6.9986002002615000,
    7.4003559455229000,
    6.9449319821739000,
    6.6282139064175000,
    7.7764114173339000,
    8.1025781230353000,
    7.8572916896631000,
    7.7945527868283000,
    7.6755000495213000,
    6.5902304140386000,
    7.5301801209672000,
    7.4228436847920000,
    7.3848601924131000,
    7.3228771799739000,
    7.2950982079356000,
    7.2333041680953000,
    7.1813367033978000,
    7.5553134766209000,
    7.0947872531016000,
    7.6290127901919000,
    7.2234775929525000,
    6.9386958864102000,
    8.1432072317988000,
    8.4591694171596000,
    5.4796384503033000,
    5.8492688537517000,
    6.5240900044236000,
    6.8232336284823000,
    6.8147298615318000,
    6.7620065064387000,
    6.3235900769907000,
    6.3976673357595000,
    5.9991241246794000,
    5.7411765271809000,
    6.8066040397791000,
    7.1692424570682000,
    7.3126726596333000,
    7.5175189568409000,
    6.9687425296353000,
    7.3200425909904000,
    6.8882402025039000,
    6.5932539756210000,
    7.5320698469562000,
    7.7817026501031000,
    7.6401621735270000,
    7.4763229302807000,
    7.4043243700998000,
    6.4254463077978000,
    7.2395402638590000,
    7.1272905401124000,
    7.0945982805027000,
    7.0303475968767000,
    7.0020017070417000,
    6.9432312287838000,
    7.2410520446502000,
    7.1112278692059000,
    7.0660634180688000,
    7.5384949153188000,
    7.1492113615848000,
    6.8797364355534000,
    7.8803463467289000,
    8.1288453142824000,
    7.9738877831844000,
    5.3923331096115000,
    5.7007363910163000,
    6.4209109654242000,
    6.6826380149007000,
    6.6883071928677000,
    6.6709217137689000,
    6.2285368597440000,
    6.3026141185128000,
    5.9123857017843000,
    5.6629418712363000,
    6.9275465030751000,
    7.0371506104371000,
    7.1941868401230000,
    7.0231666381185000,
    6.8725554767952000,
    7.2115723192218000,
    6.7812817115265000,
    6.4885631558304000,
    7.5265896415881000,
    7.6588704608181000,
    7.4802913548576000,
    7.3746556720725000,
    7.2956651257323000,
    6.3632743227597000,
    7.1163301293762000,
    6.9986002002615000,
    6.9666638310474000,
    6.8982557502456000,
    6.8670752714271000,
    6.8075489027736000,
    7.1257787593212000,
    7.0454654047887000,
    6.9723330090144000,
    7.4294577257535000,
    7.0392293090250000,
    6.7688095199991000,
    7.8342370325973000,
    7.9897614814920000,
    7.7724429927570000,
    7.6717205975433000,
    5.8401981690045000,
    5.2908548240022000,
    6.8876732847072000,
    5.8088287175871000,
    6.2353398733044000,
    6.6635517824118000,
    6.1527588475851000,
    5.7670657732302000,
    5.5546605720666000,
    5.4155767392762000,
    7.0891180751346000,
    6.1028700814755000,
    6.7355503425927000,
    7.1446760192112000,
    6.9789470499759000,
    6.5616955516047000,
    6.3035589815073000,
    6.1281924097281000,
    7.6118162836920000,
    6.7253458222521000,
    6.5452549355004000,
    6.6129071259066000,
    6.4834608956601000,
    6.8364617104053000,
    6.2258912433594000,
    6.1181768619864000,
    6.0565717947450000,
    6.0182103571683000,
    5.9932659741135000,
    5.9713451526411000,
    6.7189207538895000,
    7.2019347166779000,
    7.1229441703377000,
    6.7497232875102000,
    6.5191767168522000,
    6.3611956241718000,
    7.8627718950312000,
    7.0707877330413000,
    6.9043028734104000,
    6.8321153406306000,
    7.2935864271444000,
    5.7260587192689000,
    5.1612196211568000,
    6.7691874651969000,
    5.7585620062797000,
    6.0730124108493000,
    6.5533807572531000,
    6.0423988498275000,
    5.6633198164341000,
    5.4512925604683000,
    5.3120197550790000,
    6.9789470499759000,
    6.0614850823164000,
    6.6032695233627000,
    6.7946987660484000,
    6.8746341753831000,
    6.4609731563910000,
    6.1998130247112000,
    6.0206670009540000,
    7.5305580661650000,
    6.6338830843845000,
    6.4874293202370000,
    6.3867069250233000,
    6.4543591154295000,
    6.8092496561637000,
    6.1863959701893000,
    6.0745241916405000,
    6.0106514532123000,
    5.9707782348444000,
    5.9452669339929000,
    5.9218343317293000,
    6.5785141129068000,
    6.8504456827239000,
    7.0207099943328000,
    6.6520244538789000,
    6.4186432942374000,
    6.2563158317823000,
    7.7720650475592000,
    6.9728999268111000,
    6.8185093135098000,
    6.7281804112356000,
    7.1495893067826000,
    7.0945982805027000,
    5.5159211892921000,
    5.0601192807453000,
    6.5998680165825000,
    5.6026596121872000,
    5.8989686472624000,
    6.2247574077660000,
    5.8534262509275000,
    5.6232576254673000,
    5.3843962604577000,
    5.2228246883982000,
    6.8190762313065000,
    5.8985907020646000,
    6.4262021981934000,
    6.5749236335277000,
    6.6418199335383000,
    6.3884076784134000,
    6.1143974100084000,
    5.9214563865315000,
    7.3971434113416000,
    6.4596503481987000,
    6.3058266526941000,
    6.1988681617167000,
    6.1754355594531000,
    6.5896634962419000,
    5.9930770015146000,
    5.9566052899269000,
    5.8772367983889000,
    5.8284818678727000,
    5.7957896082630000,
    5.7710341978071000,
    6.4042813767210000,
    6.6302926050054000,
    6.7831714375155000,
    6.5730339075387000,
    6.3275585015676000,
    6.1527588475851000,
    7.6386503927358000,
    6.7967774646363000,
    6.6353948651757000,
    6.5339165795664000,
    6.9152632841466000,
    6.8621619838557000,
    6.7444320547410000,
    5.4004589313642000,
    4.9764044194326000,
    6.5522469216597000,
    5.5265036548305000,
    5.8075059093948000,
    6.1293262453215000,
    5.7330507054282000,
    5.5675107087918000,
    5.3182558508427000,
    5.1476135940360000,
    6.7712661637848000,
    5.8182773475321000,
    6.3526918572213000,
    6.4715556219294000,
    6.5204995250445000,
    6.3198106250127000,
    6.0403201512396000,
    5.8417099497957000,
    7.3550025217869000,
    6.3708332267157000,
    6.2120962436397000,
    6.1002244650909000,
    6.0783036436185000,
    6.4980117857754000,
    5.8891420721196000,
    5.8997245376580000,
    5.8129861147629000,
    5.7598848144720000,
    5.7249248836755000,
    5.6984687198295000,
    6.3296372001555000,
    6.5276804838027000,
    6.6631738372140000,
    6.5031140459457000,
    6.2521584346065000,
    6.0724454930526000,
    7.5910292978130000,
    6.7017242473896000,
    6.5359952781543000,
    6.4262021981934000,
    6.8081158205703000,
    6.7519909586970000,
    6.6036474685605000,
    6.5427982917147000,
    5.3365861929360000,
    4.9057286674440000,
    6.5450659629015000,
    5.4862524912648000,
    5.7506251571259000,
    6.0688550136735000,
    5.6487689263188000,
    5.5081733127372000,
    5.2536272220189000,
    5.0782606502397000,
    6.7606836982464000,
    5.7765144031752000,
    6.3179208990237000,
    6.4154307600561000,
    6.4500127456548000,
    6.2580165851724000,
    5.9745576868224000,
    5.7727349511972000,
    7.3432862206551000,
    6.3719670623091000,
    6.2204110379913000,
    6.1123187114205000,
    6.0989016568986000,
    6.4573826770119000,
    5.9135195373777000,
    5.7763254305763000,
    5.7759474853785000,
    5.7209564590986000,
    5.6856185831043000,
    5.6576506384671000,
    6.2914647351777000,
    6.4721225397261000,
    6.5955216468078000,
    6.4422648690999000,
    6.1877187783816000,
    6.0047933026464000,
    7.5736438187142000,
    6.6847167134886000,
    6.5265466482093000,
    6.4167535682484000,
    6.7552034928783000,
    6.6952991790270000,
    6.5237120592258000,
    6.4553039784240000,
    6.4203440476275000,
    5.2919886595956000,
    4.8416669564169000,
    6.5416644561213000,
    5.5093071483306000,
    5.7075394045767000,
    6.0235015899375000,
    5.5837623522972000,
    5.2984137279582000,
    5.1914552369808000,
    5.0134430488170000,
    6.7531247942904000,
    5.7795379647576000,
    6.2935434337656000,
    6.3774472676772000,
    6.4006908973419000,
    6.0524143975692000,
    5.9140864551744000,
    5.7096181031646000,
    7.3313809469244000,
    6.2997795295293000,
    6.1400976834588000,
    6.0250133707287000,
    6.0097065902178000,
    6.4345169925450000,
    5.8120412517684000,
    5.7595068692742000,
    5.7300271438458000,
    5.7302161164447000,
    5.6999805006207000,
    5.6727684463791000,
    6.2634967905405000,
    6.4345169925450000,
    6.5490343874784000,
    6.2400641882769000,
    6.1289483001237000,
    5.9437551532017000,
    7.5572032026099000,
    6.6172534956813000,
    6.4517134990449000,
    6.3343615151280000,
    6.7242119866587000,
    6.6614730838239000,
    6.4709887041327000,
    6.3969114453639000,
    6.3611956241718000,
    6.3353063781225000,
    5.2621309889694000,
    4.7855420945436000,
    6.5482784970828000,
    5.4346629717651000,
    5.6788155695439000,
    5.9889196043388000,
    5.5317948875997000,
    5.2184783186235000,
    5.1332516765196000,
    4.9533497623668000,
    6.7546365750816000,
    5.7211454316975000,
    6.2831499408261000,
    6.3545815832103000,
    6.3657309665454000,
    5.9845732345641000,
    5.7795379647576000,
    5.6531152960935000,
    7.3270345771497000,
    6.2548040509911000,
    6.0907758351459000,
    5.9715341252400000,
    5.9564163173280000,
    6.4294147323747000,
    5.7496802941314000,
    5.6878862542911000,
    5.6540601590880000,
    5.6330842006101000,
    5.6313834472200000,
    5.6022816669894000,
    6.2489459004252000,
    6.4118402806770000,
    6.5169090456654000,
    6.1760024772498000,
    5.9959115904981000,
    5.8898979625152000,
    7.5498332712528000,
    6.5754905513244000,
    6.4063600753089000,
    6.2842837764195000,
    6.7141964389170000,
    6.6486229470987000,
    6.4433987046933000,
    6.3651640487487000,
    6.3290702823588000,
    6.3041258993040000,
    6.2942993241612000,
    4.8044393544336000,
    5.0268601033389000,
    6.1520029571895000,
    6.1996240521123000,
    5.9307160438776000,
    5.9974233712893000,
    5.5552274898633000,
    5.3723020141281000,
    5.3842072878588000,
    5.1447790050525000,
    6.4014467877375000,
    6.5970334275990000,
    6.5233341140280000,
    6.3509911038312000,
    6.2428987772604000,
    6.1123187114205000,
    6.2359067911011000,
    5.9501802215643000,
    7.0692759522501000,
    7.2550360169688000,
    7.0199541039372000,
    6.8859725313171000,
    6.8374065733998000,
    6.0004469328717000,
    6.6537252072690000,
    6.5458218532971000,
    6.4751461013085000,
    6.4392413075175000,
    6.3925650755892000,
    6.3256687755786000,
    6.4384854171219000,
    6.3785811032706000,
    6.3581720625894000,
    6.2942993241612000,
    6.4993345939677000,
    6.2347729555077000,
    7.3260897141552000,
    7.5383059427199000,
    7.2395402638590000,
    7.0832599245687000,
    6.3148973374413000,
    6.2396862430791000,
    6.0943663145250000,
    6.0153757681848000,
    5.9673767280642000,
    5.9647311116796000,
    5.9004804280536000,
    6.5422313739180000,
    5.6206120090827000,
    5.3021931799362000,
    6.5819156196870000,
    6.3256687755786000,
    6.9660969132507000,
    6.3526918572213000,
    5.9730459060312000,
    5.6822170763241000,
    5.6011478313960000,
    5.3719240689303000,
    6.7812817115265000,
    6.6554259606591000,
    7.8072139509546000,
    7.2036354700680000,
    6.8058481493835000,
    6.5199326072478000,
    6.3302041179522000,
    6.1939548741453000,
    7.3009563585015000,
    7.2248004011448000,
    7.2727994412654000,
    7.0326152680635000,
    6.8950432160643000,
    6.5618845242036000,
    6.7325267810103000,
    6.6304815776043000,
    6.5681206199673000,
    6.5227671962313000,
    6.5050037719347000,
    6.4513355538471000,
    7.7531677876692000,
    7.2542801265732000,
    6.9437981465805000,
    6.7202435620818000,
    6.5773802773134000,
    6.4764689095008000,
    7.5932969689998000,
    7.5572032026099000,
    7.5602267641923000,
    7.4232216299898000,
    7.0369616378382000,
    6.8971219146522000,
    6.7283693838345000,
    6.6539141798679000,
    6.6157417148901000,
    6.5873958250551000,
    6.5734118527365000,
    6.7313929454169000,
    8.0545790829147000,
    5.8156317311475000,
    5.3432002338975000,
    7.5931079964009000,
    6.3088502142765000,
    6.6856615764831000,
    6.6208439750604000,
    6.1584280255521000,
    5.8211119365156000,
    5.6869413912966000,
    5.4807722858967000,
    7.7231211444441000,
    6.6306705502032000,
    7.3897734799845000,
    7.5273455319837000,
    7.0252453367064000,
    6.6750791109447000,
    6.4443435676878000,
    6.2789925436503000,
    8.0695079182278000,
    7.7267116238232000,
    7.0978108146840000,
    7.1218103347443000,
    6.9317039002509000,
    6.8795474629545000,
    6.7215663702741000,
    6.6121512355110000,
    6.5496013052751000,
    6.5068934979237000,
    6.4874293202370000,
    6.4424538416988000,
    7.3447980014463000,
    7.5948087497910000,
    7.1735888268429000,
    6.8808702711468000,
    6.6905748640545000,
    6.5537587024509000,
    8.2274890109082000,
    7.9625494272504000,
    7.4419299172809000,
    7.3533017683968000,
    7.4986216969509000,
    7.1637622517001000,
    6.9492783519486000,
    6.8525243813118000,
    6.8028245878011000,
    6.7695654103947000,
    6.7514240409003000,
    6.6932204804391000,
    7.6052022427305000,
    7.9130386063386000,
    5.8379304978177000,
    5.2755480434913000,
    7.0414969802118000,
    6.3339835699302000,
    6.4706107589349000,
    6.6958660968237000,
    6.1931989837497000,
    5.8373635800210000,
    5.6266591322475000,
    5.4820950940890000,
    7.1900294429472000,
    6.6824490423018000,
    7.1329597180794000,
    7.1641401968979000,
    7.0885511573379000,
    6.7075823979555000,
    6.4532252798361000,
    6.2695439137053000,
    7.5832814212581000,
    7.2508786197930000,
    7.1316369098871000,
    7.0156077341625000,
    7.0207099943328000,
    7.1244559511289000,
    6.7676756844057000,
    6.6493788374943000,
    6.5828604826815000,
    6.5375070589455000,
    6.5080273335171000,
    6.4707997315338000,
    7.0819371163764000,
    7.2261232093371000,
    7.2463432774194000,
    6.9214993799103000,
    6.7045588363731000,
    6.5458218532971000,
    7.7527898424714000,
    7.5084482720937000,
    7.4251113559788000,
    7.3070034816663000,
    7.4668743003357000,
    7.3621834805451000,
    7.1238890333322000,
    7.0088047206021000,
    6.9475775985585000,
    6.9065705445972000,
    6.8803033533501000,
    6.6892520558622000,
    7.3243889607651000,
    7.5218653266156000,
    7.5872498458350000,
    5.4974018745999000,
    5.2228246883982000,
    6.6265131530274000,
    6.3073384334853000,
    6.3269915837709000,
    6.1667428199037000,
    6.0112183710090000,
    5.9390308382292000,
    5.6449894743408000,
    5.4494028344793000,
    6.7895965058781000,
    6.6486229470987000,
    6.9407745849981000,
    6.9156412293444000,
    6.8185093135098000,
    6.7892185606803000,
    6.4673982247536000,
    6.2355288459033000,
    7.2168635519910000,
    7.9113378529485000,
    7.7694194311746000,
    7.6609491594060000,
    6.8644296550425000,
    6.7457548629333000,
    6.7200545894829000,
    6.6629848646151000,
    6.5953326742089000,
    6.5293812371928000,
    6.4845947312535000,
    6.4422648690999000,
    6.8857835587182000,
    6.9691204748331000,
    6.9602387626848000,
    7.0001119810527000,
    6.7192986990873000,
    6.5131295936874000,
    7.4082927946767000,
    8.1105149721891000,
    7.9738877831844000,
    7.8502997035038000,
    7.1002674584697000,
    6.9993560906571000,
    6.9061925993994000,
    6.8315484228339000,
    6.6694099329777000,
    6.5855060990661000,
    6.5293812371928000,
    6.6503237004888000,
    7.1191647183597000,
    7.2487999212051000,
    7.2801693726225000,
    7.3512230698089000,
    5.2545720850134000,
    5.1417554434701000,
    6.3895415140068000,
    6.6061041123462000,
    6.2196551475957000,
    6.0259582337232000,
    5.8562608399110000,
    5.7436331709666000,
    5.6293047486321000,
    5.4012148217598000,
    6.5603727434124000,
    6.9698763652287000,
    6.8228556832845000,
    6.7470776711256000,
    6.6251903448351000,
    6.5420424013191000,
    6.4511465812482000,
    6.1873408331838000,
    7.0071039672120000,
    7.5160071760497000,
    7.3718210830890000,
    7.2582485511501000,
    7.1703762926616000,
    6.5129406210885000,
    7.0363947200415000,
    6.9557034203112000,
    6.8886181477017000,
    6.8347609570152000,
    6.7735338349716000,
    6.7228891784664000,
    6.7599278078508000,
    6.7952656838451000,
    6.7591719174552000,
    6.7421643835542000,
    6.7058816445654000,
    6.4681541151492000,
    7.2011788262823000,
    7.7225542266474000,
    7.5908403252141000,
    7.4598823141764000,
    6.8706657508062000,
    6.7652190406200000,
    6.6631738372140000,
    6.5834274004782000,
    6.5197436346489000,
    6.4636187727756000,
    6.3405976108917000,
    6.8950432160643000,
    6.9868838991297000,
    7.0671972536622000,
    7.0685200618545000,
    7.0787245821951000,
    7.0637957468820000,
    5.0735363352672000,
    5.0531272945860000,
    6.2219228187825000,
    6.3090391868754000,
    6.1365072040797000,
    5.9118187839876000,
    5.7260587192689000,
    5.5805498181159000,
    5.5939668726378000,
    5.3426333161008000,
    6.3929430207870000,
    6.6816931519062000,
    6.7410305479608000,
    6.6233006188461000,
    6.4787365806876000,
    6.3534477476169000,
    6.2362847362989000,
    6.1323498069039000,
    6.8425088335701000,
    7.2374615652711000,
    7.0945982805027000,
    6.9768683513880000,
    6.8854056135204000,
    6.3491013778422000,
    6.7465107533289000,
    6.6643076728074000,
    6.5958995920056000,
    6.5365621959510000,
    6.4938543885996000,
    6.4396192527153000,
    6.6682760973843000,
    6.6669532891920000,
    6.6081828109341000,
    6.5479005518850000,
    6.4825160326656000,
    6.4180763764407000,
    7.0352608844481000,
    7.4458983418578000,
    7.3232551251717000,
    7.1875727991615000,
    6.7083382883511000,
    6.5976003453957000,
    6.4853506216491000,
    6.4010688425397000,
    6.3343615151280000,
    6.2755910368701000,
    6.2262691885572000,
    6.6238675366428000,
    6.8908858188885000,
    6.9345384892344000,
    6.9120507499653000,
    6.8763349287732000,
    6.8298476694438000,
    6.7820376019221000,
    6.4190212394352000,
    5.6922326240658000,
    7.9823915501349000,
    7.1596048545243000,
    7.5681636133461000,
    6.6866064394776000,
    6.1790260388322000,
    5.8738352916087000,
    5.6534932412913000,
    5.4909768062373000,
    8.1900724363260000,
    7.5400066961100000,
    8.8038554375532000,
    7.8004109373942000,
    7.2045803330625000,
    6.8387293815921000,
    6.5858840442639000,
    6.3984232261551000,
    8.7930839994159000,
    8.1511440809526000,
    7.9856040843162000,
    7.8062690879601000,
    7.6896729944388000,
    7.7372940893616000,
    7.5305580661650000,
    7.4485439582424000,
    7.3910962881768000,
    7.3459318370397000,
    7.3200425909904000,
    7.2703427974797000,
    8.6978418095703000,
    7.8495438131082000,
    7.3687975215066000,
    7.0711656782391000,
    6.8702878056084000,
    6.7175979456972000,
    9.1373920746117000,
    8.5818126338457000,
    8.2941963383199000,
    8.2044343538424000,
    8.1717420942327000,
    8.0791455207717000,
    7.9468647015417000,
    7.8971649080310000,
    7.8773227851465000,
    7.8584255252565000,
    7.8491658679104000,
    7.6683190907631000,
    7.9330697018220000,
    8.4213748973796000,
    7.9731318927888000,
    7.6586814882192000,
    7.4623389579621000,
    7.3022791666938000,
    9.5557774085763000,
    5.7882307043070000,
    6.2873073380019000,
    7.6405401187248000,
    7.5675966955494000,
    7.8527563472895000,
    7.0724884864314000,
    6.6386073993570000,
    6.6469221937086000,
    6.2141749422276000,
    5.9295822082842000,
    7.9168180583166000,
    7.9975093580469000,
    7.8848816891025000,
    7.9052907297837000,
    7.3565143025781000,
    7.6617050498016000,
    7.2032575248702000,
    6.8812482163446000,
    8.7632263287897000,
    8.7433842059052000,
    8.4565238007750000,
    8.3401166798526000,
    8.2123712029962000,
    7.2909408107598000,
    8.0470201789587000,
    7.9175739487122000,
    7.8540791554818000,
    7.7839703212899000,
    7.7609156642241000,
    7.6796574466971000,
    7.7964425128173000,
    7.9319358662286000,
    7.4704647797148000,
    7.8979207984266000,
    7.4946532723740000,
    7.2055251960570000,
    9.1009203630240000,
    9.1220852941008000,
    8.7482974934766000,
    8.6625039335760000,
    7.7044128571530000,
    7.5755335447032000,
    7.3893955347867000,
    7.2822480712104000,
    7.2421858802436000,
    7.1800138952055000,
    7.1480775259914000,
    7.9924070978766000,
    8.1976313402820000,
    8.3813127064128000,
    7.9241879896737000,
    8.4243984589620000,
    8.0415399735906000,
    7.7614825820208000,
    9.5344235049006000,
    9.7914262394046000,
    5.7886086495048000,
    6.1722230252718000,
    6.8846497231248000,
    7.1975883469032000,
    7.1639512242990000,
    7.0639847194809000,
    6.6316154131977000,
    6.6433317143295000,
    6.2449774758483000,
    5.9868409057509000,
    7.1565812929419000,
    7.5445420384836000,
    7.6792795014993000,
    7.8200640876798000,
    7.2926415641499000,
    7.5898954622196000,
    7.1579041011342000,
    6.8627289016524000,
    7.8879052506849000,
    8.1571912041174000,
    8.0114933303655000,
    7.9049127845859000,
    7.7680966229823000,
    6.7759904787573000,
    7.6099265577030000,
    7.4976768339564000,
    7.4574256703907000,
    7.3982772469350000,
    7.3738997816769000,
    7.3147513582212000,
    7.6042573797360000,
    7.8520004568939000,
    7.3903403977812000,
    7.8115603207293000,
    7.4245444381821000,
    7.1569592381397000,
    8.2516775035674000,
    8.5188847584120000,
    8.3586359945448000,
    8.1551125055295000,
    7.2680751262929000,
    7.1822815663923000,
    6.9902854059099000,
    6.8874843121083000,
    6.8612171208612000,
    6.7952656838451000,
    6.7555814380761000,
    7.6267451190051000,
    8.1492543549636000,
    8.2276779835071000,
    7.7709312119658000,
    8.2717085990508000,
    7.8962200450365000,
    7.6318473791754000,
    8.8824680386956000,
    9.1848241969356000,
    8.7420613977129000,
    5.5661879005995000,
    6.1359402862830000,
    6.8234226010812000,
    7.2796024548258000,
    6.9211214347125000,
    6.9160191745422000,
    6.5027361007479000,
    6.5497902778740000,
    6.1255467933435000,
    5.8475681003616000,
    7.0891180751346000,
    7.6339260777633000,
    7.4135840274459000,
    7.6649175839829000,
    7.1545025943540000,
    7.5296132031705000,
    7.0777797192006000,
    6.7655969858178000,
    7.8170405260974000,
    8.2356148326609000,
    8.0031785360139000,
    7.9389278523879000,
    7.8238435396578000,
    6.6860395216809000,
    7.6823030630817000,
    7.5764784076977000,
    7.5367941619287000,
    7.4776457384730000,
    7.4510006020281000,
    7.3910962881768000,
    7.3185308101992000,
    7.6877832684498000,
    7.2472881404139000,
    7.7580810752406000,
    7.3563253299792000,
    7.0760789658105000,
    8.2042453812435000,
    8.5976863321533000,
    8.2832359275837000,
    8.1488764097658000,
    7.1905963607439000,
    7.1021571844587000,
    6.9205545169158000,
    6.8234226010812000,
    6.7975333550319000,
    6.7327157536092000,
    6.6911417818512000,
    7.7063025831420000,
    7.6962870354003000,
    8.0948302464804000,
    7.6634058031917000,
    8.2480870241883000,
    7.8654175114158000,
    7.5925410786042000,
    8.6553229748178000,
    9.2832789209625000,
    8.6664723581529000,
    8.7307230417789000,
    5.5263146822316000,
    6.0926655611349000,
    6.7742897253672000,
    7.2363277296777000,
    6.8776577369655000,
    6.8786025999600000,
    6.4636187727756000,
    6.5193656894511000,
    6.0949332323217000,
    5.8163876215431000,
    7.0405521172173000,
    7.5910292978130000,
    7.3704982748967000,
    7.6292017627908000,
    7.1153852663817000,
    7.4969209435608000,
    7.0454654047887000,
    6.7330936988070000,
    7.7652620339988000,
    8.1913952445183000,
    7.9589589478713000,
    7.8977318258277000,
    7.7817026501031000,
    6.6403081527471000,
    7.6394062831314000,
    7.5337706003463000,
    7.4948422449729000,
    7.4351269037205000,
    7.4077258768800000,
    7.3478215630287000,
    7.2750671124522000,
    7.6526343650544000,
    7.2083597850405000,
    7.7253888156309000,
    7.3238220429684000,
    7.0431977336019000,
    8.1500102453592000,
    8.5494983194338000,
    8.2350479148642000,
    8.1012553148430000,
    7.1424083480244000,
    7.0520794457502000,
    6.8717995863996000,
    6.7754235609606000,
    6.7512350683014000,
    6.6854726038842000,
    6.6433317143295000,
    7.6584925156203000,
    7.6492328582742000,
    8.0559018911070000,
    7.6197531328458000,
    8.2106704496061000,
    7.8274340190369000,
    7.5541796410275000,
    8.5980642773511000,
    9.2265871412925000,
    8.6173394824389000,
    8.6832909194550000,
    8.6364257149278000,
    5.4888981076494000,
    6.0554379591516000,
    6.7313929454169000,
    7.1956986209142000,
    6.8379734911965000,
    6.8445875321580000,
    6.4286588419791000,
    6.4929095256051000,
    6.0679101506790000,
    5.7891755673015000,
    6.9989781454593000,
    7.5509671068462000,
    7.3306250565288000,
    7.5955646401866000,
    7.0789135547940000,
    7.4676301907313000,
    7.0161746519592000,
    6.7036139733786000,
    7.7236880622408000,
    8.1518999713482000,
    7.9190857295034000,
    7.8599373060477000,
    7.7427742947297000,
    6.5987341809891000,
    7.5997220373624000,
    7.4940863545773000,
    7.4557249170006000,
    7.3952536853526000,
    7.3672857407154000,
    7.3073814268641000,
    7.2355718392821000,
    7.6199421054447000,
    7.1722660186506000,
    7.6959090902025000,
    7.2939643723422000,
    7.0133400629757000,
    8.1061686024144000,
    8.5077353750769000,
    8.1872378473425000,
    8.0587364800905000,
    7.0998895132719000,
    7.0076708850087000,
    6.8287138338504000,
    6.7327157536092000,
    6.7098500691423000,
    6.6433317143295000,
    6.6006239069781000,
    7.6150288178733000,
    7.6031235441426000,
    8.0203750425138000,
    7.5800688870768000,
    8.1776002447986000,
    7.7932299786360000,
    7.5197866280277000,
    8.5523329084173000,
    9.1780211833752000,
    8.5704742779117000,
    8.6422838654937000,
    8.5954186609665000,
    8.5549785248019000,
    5.4571507110342000,
    6.0263361789210000,
    6.6918976722468000,
    7.1635732791012000,
    6.7981002728286000,
    6.8177534231142000,
    6.4006908973419000,
    6.4709887041327000,
    6.0456113840088000,
    5.7661209102357000,
    6.9600497900859000,
    7.5180858746376000,
    7.2903738929631000,
    7.5681636133461000,
    7.0494338293656000,
    7.4440086158688000,
    6.9923641044978000,
    6.6796144533183000,
    7.6830589534773000,
    8.1173179857495000,
    7.8811022371245000,
    7.8280009368336000,
    7.7100820351200000,
    6.5605617160113000,
    7.5670297777527000,
    7.4615830675665000,
    7.4239775203854000,
    7.3633173161385000,
    7.3349714263035000,
    7.2754450576500000,
    7.1947537579197000,
    7.5929190238020000,
    7.1424083480244000,
    7.6719095701422000,
    7.2697758796830000,
    6.9887736251187000,
    8.0649725758542000,
    8.4716416086870000,
    8.1507661357548000,
    8.0207529877116000,
    7.0619060208930000,
    6.9685535570364000,
    6.7907303414715000,
    6.6949212338292000,
    6.6733783575546000,
    6.6061041123462000,
    6.5630183597970000,
    7.5810137500713000,
    7.5670297777527000,
    7.9910842896843000,
    7.5473766274671000,
    8.1511440809526000,
    7.7660179243944000,
    7.4920076559894000,
    8.5098140736648000,
    9.1379589924084000,
    8.5332466759284000,
    8.6065680443016000,
    8.5598918123733000,
    8.5194516762087000,
    8.4841138002144000,
    5.4252143418201000,
    5.9974233712893000,
    6.6516465086811000,
    7.1306920468926000,
    6.7655969858178000,
    6.7905413688726000,
    6.3729119253036000,
    6.4492568552592000,
    6.0238795351353000,
    5.7440111161644000,
    6.9209324621136000,
    7.4848266972312000,
    7.2559808799633000,
    7.5386838879177000,
    7.0193871861405000,
    7.4201980684074000,
    6.9687425296353000,
    6.6559928784558000,
    7.6435636803072000,
    8.0825470275519000,
    7.8467092241247000,
    7.7945527868283000,
    7.6772008029114000,
    6.5252238400170000,
    7.5335816277474000,
    7.4285128627590000,
    7.3916632059735000,
    7.3306250565288000,
    7.3020901940949000,
    7.2425638254414000,
    7.1605497175188000,
    7.5636282709725000,
    7.1121727322004000,
    7.6479100500819000,
    7.2457763596227000,
    6.9643961598606000,
    8.0245324396896000,
    8.4347919519015000,
    8.1142944241671000,
    7.9844702487228000,
    7.0239225285141000,
    6.9305700646575000,
    6.7536917120871000,
    6.6584495222415000,
    6.6378515089614000,
    6.5701993185552000,
    6.5265466482093000,
    7.5460538192748000,
    7.5313139565606000,
    7.9600927834647000,
    7.5144953952585000,
    8.1243099719088000,
    7.7386168975539000,
    7.4644176565500000,
    8.4680511293079000,
    9.0961960480515000,
    8.4960190739451000,
    8.5700963327139000,
    8.5236090733845000,
    8.4831689372199000,
    8.4480200338245000,
    8.4121152400335000,
    5.3985692053752000,
    5.9730459060312000,
    6.6234895914450000,
    7.1049917734422000,
    6.7397077397685000,
    6.7657859584167000,
    6.3496682956389000,
    6.4309265131659000,
    6.0053602204431000,
    5.7251138562744000,
    6.8935314352731000,
    7.4589374511819000,
    7.2304695791118000,
    7.5160071760497000,
    6.9948207482835000,
    7.4005449181218000,
    6.9487114341519000,
    6.6357728103735000,
    7.6167295712634000,
    8.0566577815026000,
    7.8206310054765000,
    7.7697973763724000,
    7.6513115568621000,
    6.4942323337974000,
    7.5082592994948000,
    7.4031905345064000,
    7.3667188229187000,
    7.3054917008751000,
    7.2767678658423000,
    7.2170525245899000,
    7.1350384166673000,
    7.5413295043023000,
    7.0876062943434000,
    7.6278789545985000,
    7.2253673189415000,
    6.9437981465805000,
    7.9961865498546000,
    8.4073909250610000,
    8.0865154521288000,
    7.9566912766845000,
    6.9925530770967000,
    6.8993895858390000,
    6.7232671236642000,
    6.6282139064175000,
    6.6085607561319000,
    6.5401526753301000,
    6.4963110323853000,
    7.5188417650332000,
    7.5044798475168000,
    7.9362822360033000,
    7.4878502588136000,
    8.1025781230353000,
    7.7159401856859000,
    7.4413629994842000,
    8.4385714038795000,
    9.0657714596286000,
    8.4684290745057000,
    8.5432622236701000,
    8.4969639369396000,
    8.4565238007750000,
    8.4215638699785000,
    8.3856590761875000,
    8.3590139397426000,
    5.0640877053222000,
    5.6977128294339000,
    6.1578611077554000,
    6.6692209603788000,
    6.6879292476699000,
    6.5955216468078000,
    6.2147418600243000,
    6.2969449405458000,
    5.9012363184492000,
    5.6480130359232000,
    6.4273360337868000,
    7.0193871861405000,
    7.1488334163870000,
    6.9286803386685000,
    6.7837383553122000,
    7.1955096483153000,
    6.7671087666090000,
    6.4751461013085000,
    7.1291802661014000,
    7.6169185438623000,
    7.5141174500607000,
    7.3491443712210000,
    7.2733663590621000,
    6.1805378196234000,
    7.1044248556455000,
    6.9889625977176000,
    6.9489004067508000,
    6.8838938327292000,
    6.8489339019327000,
    6.7937539030539000,
    7.0859055409533000,
    6.9494673245475000,
    6.8717995863996000,
    7.4082927946767000,
    7.0216548573273000,
    6.7550145202794000,
    7.4632838209566000,
    7.9512110713164000,
    7.8542681280807000,
    7.6549020362412000,
    6.6762129465381000,
    6.5724669897420000,
    6.3742347334959000,
    6.2599063111614000,
    6.2069939834694000,
    6.1276254919314000,
    6.0726344656515000,
    7.0847717053599000,
    7.3710651926934000,
    7.2436976610348000,
    7.1864389635681000,
    7.8302686080204000,
    7.4468432048523000,
    7.1805808130022000,
    7.8731653879707000,
    8.5621594835601000,
    8.2167175727709000,
    8.1090031913979000,
    8.0636497676619000,
    8.0152727823435000,
    7.9803128515470000,
    7.9457308659483000,
    7.9194636747012000,
    7.7937968964327000,
    4.7600307936921000,
    5.6130531051267000,
    6.2480010374307000,
    6.8474221211415000,
    6.5227671962313000,
    6.4229896640121000,
    6.0673432328823000,
    6.1291372727226000,
    5.6869413912966000,
    5.4008368765620000,
    6.4728784301217000,
    7.2106274562273000,
    7.0407410898162000,
    6.8279579434548000,
    6.6701658233733000,
    7.0989446502774000,
    6.6319933583955000,
    6.3056376800952000,
    7.1601717723210000,
    7.8041903893722000,
    7.5948087497910000,
    7.4782126562697000,
    7.4147178630393000,
    6.1750576142553000,
    7.2716656056720000,
    7.2106274562273000,
    7.1159521841784000,
    7.0518904731513000,
    7.0157967067614000,
    6.9568372559046000,
    6.9528688313277000,
    6.8442095869602000,
    6.7629513694332000,
    7.3251448511607000,
    6.9111058869708000,
    6.6181983586758000,
    7.5092041624893000,
    8.1740097654195000,
    7.9043458667892000,
    7.7777342255262000,
    6.6287808242142000,
    6.5375070589455000,
    6.3494793230400000,
    6.2527253524032000,
    6.1557824091675000,
    6.0781146710196000,
    6.0199111105584000,
    7.2796024548258000,
    7.3066255364685000,
    7.1951317031175000,
    7.1378730056508000,
    7.8217648410699000,
    7.4258672463744000,
    7.1378730056508000,
    7.9621714820526000,
    8.9399157087612000,
    8.2745431880343000,
    8.2947632561166000,
    8.2484649693861000,
    8.2091586688149000,
    8.1743877106173000,
    8.1396167524197000,
    8.1146723693649000,
    7.7954976498228000,
    8.0175404535303000,
    5.7600737870709000,
    5.5905653658576000,
    6.9766793787891000,
    6.8011238344110000,
    7.3474436178309000,
    6.4645636357701000,
    5.9726679608334000,
    6.0354068636682000,
    5.6644536520275000,
    5.4133090680894000,
    7.2070369768482000,
    7.1686755392715000,
    7.0072929398109000,
    7.3992221099295000,
    6.7860060264990000,
    6.5777582225112000,
    6.5924980852254000,
    6.3111178854633000,
    7.8113713481304000,
    7.7709312119658000,
    7.5377390249232000,
    7.4725434783027000,
    7.3542466313913000,
    6.7829824649166000,
    7.2057141686559000,
    7.1119837596015000,
    7.0711656782391000,
    7.0054032138219000,
    6.9693094474320000,
    6.9114838321686000,
    6.9061925993994000,
    7.4407960816875000,
    6.9124286951631000,
    6.7784471225430000,
    6.8712326686029000,
    6.6214108928571000,
    8.1539786699361000,
    8.1216643555242000,
    7.8085367591469000,
    7.8041903893722000,
    7.2119502644196000,
    7.1204875265520000,
    7.0210879395306000,
    6.9651520502562000,
    6.9369951330201000,
    6.9288693112674000,
    6.9007123940313000,
    7.2138399904086000,
    7.2958540983312000,
    7.8999994970145000,
    7.3892065621878000,
    7.2554139621666000,
    7.3638842339352000,
    7.1191647183597000,
    8.5555454425986000,
    8.8216188618498000,
    8.1908283267216000,
    8.2465752433971000,
    8.1983872306776000,
    8.1564353137218000,
    8.1205305199308000,
    8.0840588083431000,
    8.0570357267004000,
    7.6067140235217000,
    7.7796239515152000,
    7.8501107309049000,
    5.3169330426504000,
    5.8488909085539000,
    6.5450659629015000,
    6.9683645844375000,
    6.6115843177143000,
    6.6486229470987000,
    6.2241904899693000,
    6.3456998710620000,
    5.9195666605425000,
    5.6374305703848000,
    6.8177534231142000,
    7.3240110155673000,
    7.1083932802224000,
    7.4118832740558000,
    6.8729334219930000,
    7.3032240296883000,
    6.8513905457184000,
    6.5375070589455000,
    7.5350934085386000,
    7.9251328526682000,
    7.6872163506531000,
    7.6401621735270000,
    7.5175189568409000,
    6.4035254863254000,
    7.3714431378912000,
    7.2684530714907000,
    7.2353828666832000,
    7.1715101282550000,
    7.1412745124310000,
    7.0811812259808000,
    7.0140959533713000,
    7.4400401912919000,
    6.9679866392397000,
    7.5298021757694000,
    7.1259677319201000,
    6.8426978061690000,
    7.9013223052068000,
    8.2675512018750000,
    7.9451639481516000,
    7.8121272385260000,
    6.8897519832951000,
    6.7895965058781000,
    6.6208439750604000,
    6.5341055521653000,
    6.5248458948192000,
    6.4526583620394000,
    6.4069269931056000,
    7.3725769734846000,
    7.3757895076659000,
    7.8315914162127000,
    7.3625614257429000,
    7.9925960704755000,
    7.6018007359503000,
    7.3251448511607000,
    8.3310459951054000,
    8.9000424903933000,
    8.3268885979296000,
    8.4070129798632000,
    8.3607146931327000,
    8.3202745569681000,
    8.2849366809738000,
    8.2495988049795000,
    8.2229536685346000,
    7.7784901159218000,
    7.9755885365745000,
    7.9279674416517000,
    8.0868933973266000,
    5.2972798923648000,
    5.8213009091145000,
    6.5231451414291000,
    6.9352943796300000,
    6.5813487018903000,
    6.6234895914450000,
    6.1981122713211000,
    6.3271805563698000,
    5.9021811814437000,
    5.6213678994783000,
    6.7975333550319000,
    7.2916967011554000,
    7.0791025273929000,
    7.3888286169900000,
    6.8460993129492000,
    7.2820590986115000,
    6.8307925324383000,
    6.5176649360610000,
    7.5143064226596000,
    7.8939523738497000,
    7.6554689540379000,
    7.6099265577030000,
    7.4859605328246000,
    6.3785811032706000,
    7.3389398508804000,
    7.2359497844799000,
    7.2038244426669000,
    7.1393847864420000,
    7.1089601980191000,
    7.0486779389700000,
    6.9853721183385000,
    7.4177414246217000,
    6.9417194479926000,
    7.5084482720937000,
    7.1048028008433000,
    6.8217218476911000,
    7.8769448399487000,
    8.2339140792708000,
    7.9107709351518000,
    7.7767893625317000,
    6.8619730112568000,
    6.7599278078508000,
    6.5915532222309000,
    6.5061376075281000,
    6.4997125391655000,
    6.4267691159901000,
    6.3808487744574000,
    7.3372390974903000,
    7.3449869740452000,
    7.8075918961524000,
    7.3334596455123000,
    7.9678406600196000,
    7.5762894350988000,
    7.2994445777103000,
    8.3027001052704000,
    8.8573346830419000,
    8.2924955849298000,
    8.3745096928524000,
    8.3285893513197000,
    8.2879602425562000,
    8.2528113391608000,
    8.2174734631665000,
    8.1908283267216000,
    7.7448529933176000,
    7.9436521673604000,
    7.8973538806299000,
    8.0543901103158000,
    8.0218868233050000,
    5.2849966734363000,
    5.7993800876421000,
    6.5091611691105000,
    6.9128066403609000,
    6.5605617160113000,
    6.6047813041539000,
    6.1782701484366000,
    6.3111178854633000,
    5.8859295379383000,
    5.6051162559729000,
    6.7837383553122000,
    7.2693979344852000,
    7.0596383497062000,
    7.3725769734846000,
    6.8273910256581000,
    7.2646736195127000,
    6.8132180807406000,
    6.4999015117644000,
    7.4989996421487000,
    7.8718425797784000,
    7.6333591599666000,
    7.5887616266262000,
    7.4640397113522000,
    6.3640302131553000,
    7.3166410842102000,
    7.2119502644196000,
    7.1819036211945000,
    7.1170860197718000,
    7.0864724587500000,
    7.0261901997009000,
    6.9660969132507000,
    7.4020566989130000,
    6.9233891058993000,
    7.4910627929949000,
    7.0870393765467000,
    6.8037694507956000,
    7.8593703882510000,
    8.2104814770072000,
    7.8875273054871000,
    7.7533567602681000,
    6.8453434225536000,
    6.7419754109553000,
    6.5734118527365000,
    6.4844057586546000,
    6.4842167860557000,
    6.4105174724847000,
    6.3645971309520000,
    7.3128616322322000,
    7.3241999881662000,
    7.7911512800481000,
    7.3139954678256000,
    7.9487544275307000,
    7.5564473122143000,
    7.2790355370291000,
    8.2830469549848000,
    8.8303116013992000,
    8.2692519552651000,
    8.3516440083855000,
    8.3057236668528000,
    8.2650945580893000,
    8.2299456546939000,
    8.1946077786996000,
    8.1679626422547000,
    7.7216093636529000,
    7.9200305924979000,
    7.8756220317564000,
    8.0315244258489000,
    7.9990211388381000,
    7.9761554543712000,
    5.2717685915133000,
    5.7893645399004000,
    6.4900749366216000,
    6.8937204078720000,
    6.5433652095114000,
    6.5936319208188000,
    6.1654200117114000,
    6.3011023377216000,
    5.8747801546032000,
    5.5930220096433000,
    6.7659749310156000,
    7.2487999212051000,
    7.0394182816239000,
    7.3585930011660000,
    6.8118952725483000,
    7.2518234827875000,
    6.8011238344110000,
    6.4872403476381000,
    7.4827479986433000,
    7.8502997035038000,
    7.6114383384942000,
    7.5679746407472000,
    7.4436306706710000,
    6.3439991176719000,
    7.2958540983312000,
    7.1915412237384000,
    7.1618725257111000,
    7.0978108146840000,
    7.0675751988600000,
    7.0072929398109000,
    6.9462547903662000,
    7.3878837539955000,
    6.9073264349928000,
    7.4780236836708000,
    7.0743782124204000,
    6.7903523962737000,
    7.8438746351412000,
    8.1895055185293000,
    7.8657954566136000,
    7.7320028565924000,
    6.8268241078614000,
    6.7240230140598000,
    6.5543256202476000,
    6.4651305535668000,
    6.4641856905723000,
    6.3927540481881000,
    6.3468337066554000,
    7.2950982079356000,
    7.3053027282762000,
    7.7773562803284000,
    7.2981217695180000,
    7.9357153182066000,
    7.5432192302913000,
    7.2652405373094000,
    8.2675512018750000,
    8.8093356429213000,
    8.2475201063916000,
    8.3304790773087000,
    8.2845587357760000,
    8.2439296270125000,
    8.2087807236171000,
    8.1736318202217000,
    8.1469866837768000,
    7.6996885421805000,
    7.9003774422123000,
    7.8571027170642000,
    8.0105484673710000,
    7.9780451803602000,
    7.9551794958933000,
    7.9342035374154000,
    5.3658769457655000,
    5.6844847475109000,
    6.2684100781119000,
    6.5909863044342000,
    6.6820710971040000,
    6.6414419883405000,
    6.2000019973101000,
    6.2941103515623000,
    5.9072834416140000,
    5.6578396110660000,
    6.5650970583849000,
    6.9305700646575000,
    7.1492113615848000,
    6.9517349957343000,
    6.8324932858284000,
    7.1887066347549000,
    6.7676756844057000,
    6.4819491148689000,
    7.2716656056720000,
    7.5303690935661000,
    7.4292687531546000,
    7.2574926607545000,
    7.1864389635681000,
    6.2289148049418000,
    7.0116393095856000,
    6.9003344488335000,
    6.8744452027842000,
    6.8067930123780000,
    6.7744786979661000,
    6.7179758908950000,
    7.0853386231566000,
    6.9717660912177000,
    6.9288693112674000,
    7.4020566989130000,
    7.0203320491350000,
    6.7576601366640000,
    7.6095486125052000,
    7.8605042238444000,
    7.7680966229823000,
    7.5579590930055000,
    6.7225112332686000,
    6.6335051391867000,
    6.4558708962207000,
    6.3598728159795000,
    6.3640302131553000,
    6.2820161052327000,
    6.2313714487275000,
    7.0054032138219000,
    7.3788130692483000,
    7.2780906740346000,
    7.2607051949358000,
    7.1851161553758000,
    7.4309695065447000,
    7.1681086214748000,
    8.0016667552227000,
    8.4249653767587000,
    8.1475536015735000,
    8.0232096314973000,
    7.9771003173657000,
    7.9264556608605000,
    7.8907398396684000,
    7.8554019636741000,
    7.8280009368336000,
    7.6760669673180000,
    7.6522564198566000,
    7.5500222438517000,
    7.6900509396366000,
    7.6564138170324000,
    7.6337371051644000,
    7.6118162836920000,
    7.5834703938570000,
    5.4815281762923000,
    5.6075728997586000,
    7.2138399904086000,
    6.7758015061584000,
    6.8948542434654000,
    6.6781026725271000,
    6.2043483670848000,
    6.2651975439306000,
    5.8853626201416000,
    5.6438556387474000,
    7.4867164232202000,
    7.2622169757270000,
    7.5551245040220000,
    7.2062810864526000,
    6.9262236948828000,
    7.1781241692165000,
    6.7569042462684000,
    6.4641856905723000,
    8.3263216801329000,
    8.0912397671013000,
    7.8380164845753000,
    7.6753110769224000,
    7.5549355314231000,
    6.8959880790588000,
    7.3383729330837000,
    7.1860610183703000,
    7.1167080745740000,
    7.0265681448987000,
    6.9832934197506000,
    6.9022241748225000,
    7.4963540257641000,
    7.2510675923919000,
    7.0534022539425000,
    7.4001669729240000,
    7.0214658847284000,
    6.7489673971146000,
    8.6995425629604000,
    8.4319573629180000,
    8.1432072317988000,
    7.9599038108658000,
    7.2712876604742000,
    7.1000784858708000,
    6.9158302019433000,
    6.7971554098341000,
    6.7227002058675000,
    6.6869843846754000,
    6.6429537691317000,
    7.1465657452002000,
    7.8111823755315000,
    7.5878167636317000,
    7.4033795071053000,
    7.2949092353367000,
    7.4389063556985000,
    7.1631953339034000,
    9.0585905008704000,
    8.9591909138490000,
    8.5908833185929000,
    8.6288668109718000,
    8.5680176341260000,
    8.5149163338351000,
    8.4720195538848000,
    8.4289338013356000,
    8.3958635965281000,
    8.0022336730194000,
    8.3533447617756000,
    8.1483094919691000,
    8.2108594222050000,
    8.1622934642877000,
    8.1324357936615000,
    8.1131605885737000,
    7.8578586074598000,
    8.0218868233050000,
    5.3968684519851000,
    5.4896539980450000,
    7.2423748528425000,
    6.6975668502138000,
    6.6285918516153000,
    6.5960885646045000,
    6.1219563139644000,
    6.1831834360080000,
    5.8063720738014000,
    5.5684555717863000,
    7.4916297107916000,
    7.1904073881450000,
    7.3663408777209000,
    7.1359832796618000,
    6.8438316417624000,
    7.0923306093159000,
    6.6701658233733000,
    6.3763134320838000,
    8.2796454482046000,
    8.0914287397002000,
    7.7527898424714000,
    7.6144619000766000,
    7.4908738203960000,
    6.8423198609712000,
    7.2686420440896000,
    7.1144404033872000,
    7.0450874595909000,
    6.9523019135310000,
    6.9054367090038000,
    6.8251233544713000,
    7.3037909474850000,
    7.1828484841890000,
    6.9719550638166000,
    7.3156962212157000,
    6.9351054070311000,
    6.6601502756316000,
    8.5323018129339000,
    8.4124931852313000,
    8.0385164120082000,
    7.8391503201687000,
    7.3020901940949000,
    7.0380954734316000,
    6.8489339019327000,
    6.7253458222521000,
    6.6465442485108000,
    6.6089387013297000,
    6.5601837708135000,
    7.0562368429260000,
    7.6186192972524000,
    7.5509671068462000,
    7.3107829336443000,
    7.2026906070735000,
    7.3438531384518000,
    7.0636067742831000,
    8.8989086547999000,
    8.9111918737284000,
    8.5413724976811000,
    8.6061900991038000,
    8.5472306482470000,
    8.4960190739451000,
    8.4565238007750000,
    8.4147608564181000,
    8.3830134598029000,
    7.8941413464486000,
    8.2720865442486000,
    8.1188297665407000,
    8.2025446278534000,
    8.1558683959251000,
    8.1269555882934000,
    8.1088142187990000,
    7.7493883356912000,
    7.8552129910752000,
    7.7440971029220000,
    5.3120197550790000,
    5.3894985206280000,
    7.0826930067720000,
    6.6338830843845000,
    6.4904528818194000,
    6.3232121317929000,
    6.0416429594319000,
    6.1087282320414000,
    5.7313499520381000,
    5.4934334500230000,
    7.3364832070947000,
    7.1673527310792000,
    7.2308475243096000,
    6.9931199948934000,
    6.7646521228233000,
    7.0186312957449000,
    6.5940098660166000,
    6.2977008309414000,
    8.1348924374472000,
    7.9778562077613000,
    7.7074364187354000,
    7.5400066961100000,
    7.4373945749073000,
    6.8655634906359000,
    7.2438866336337000,
    7.0518904731513000,
    6.9838603375473000,
    6.8899409558940000,
    6.8402411623833000,
    6.7612506160431000,
    7.1637622517001000,
    7.0405521172173000,
    6.8929645174764000,
    6.7518019860981000,
    6.8604612304656000,
    6.5826715100826000,
    8.3843362679952000,
    8.2998655162869000,
    7.9759664817723000,
    7.7730099105537000,
    7.1936199223263000,
    7.0715436234369000,
    6.8294697242460000,
    6.7068265075599000,
    6.6285918516153000,
    6.5926870578243000,
    6.5427982917147000,
    6.9836713649484000,
    7.4772677932752000,
    7.3653960147264000,
    7.2263121819360000,
    7.1212434169476000,
    7.2661854003039000,
    6.9823485567561000,
    8.7528328358502000,
    8.7983752321851000,
    8.4155167468137000,
    8.4954521561484000,
    8.4359257874949000,
    8.3839583227974000,
    8.3440851044295000,
    8.3027001052704000,
    8.2701968182596000,
    7.8049462797678000,
    8.2010328470622000,
    7.9903283992887000,
    8.0872713425244000,
    8.0402171653983000,
    8.0107374399699000,
    7.9927850430744000,
    7.6909958026311000,
    7.7635612806087000,
    7.6191862150491000,
    7.5315029291595000,
    5.2300056471564000,
    5.3059726319142000,
    6.9400186946025000,
    6.5770023321156000,
    6.3825495278475000,
    6.1247909029479000,
    5.9679436458609000,
    6.0439106306187000,
    5.6640757068297000,
    5.4244584514245000,
    7.1941868401230000,
    7.0660634180688000,
    7.1182198553652000,
    6.8527133539107000,
    6.6900079462578000,
    6.9555144477123000,
    6.5280584290005000,
    6.2289148049418000,
    7.9903283992887000,
    7.8797794289322000,
    7.6042573797360000,
    7.4343710133249000,
    7.3153182760179000,
    6.7064485623621000,
    7.1427862932222000,
    6.9919861593000000,
    6.9266016400806000,
    6.8321153406306000,
    6.7807147937298000,
    6.7032360281808000,
    7.0465992403821000,
    6.8993895858390000,
    6.8177534231142000,
    6.6811262341095000,
    6.7960215742407000,
    6.5157752100720000,
    8.2367486682543000,
    8.1995210662710000,
    7.8678741552015000,
    7.6601932690104000,
    7.0284578708877000,
    6.9029800652181000,
    6.7107949321368000,
    6.5832384278793000,
    6.5006574021600000,
    6.4611621289899000,
    6.4044703493199000,
    6.9205545169158000,
    7.3574591655726000,
    7.2253673189415000,
    7.1475106081947000,
    7.0471661581788000,
    7.2009898536834000,
    6.9143184211521000,
    8.6048672909115000,
    8.6951961931857000,
    8.3074244202429000,
    8.3947297609347000,
    8.3353923648801000,
    8.2836138727815000,
    8.2439296270125000,
    8.2027336004523000,
    8.1706082586393000,
    7.7219873088507000,
    8.0946412738815000,
    7.8754330591575000,
    7.9882497007008000,
    7.9415734687725000,
    7.9120937433441000,
    7.8941413464486000,
    7.5827145034614000,
    7.6458313514940000,
    7.5239440252035000,
    7.4341820407260000,
    7.3614275901495000,
    5.0856305815968000,
    5.2163996200356000,
    6.8100055465593000,
    6.4617290467866000,
    6.2538591879966000,
    5.9923211111190000,
    5.8320723472518000,
    6.0072499464321000,
    5.6196671460882000,
    5.3719240689303000,
    7.0634178016842000,
    6.9432312287838000,
    6.9783801321792000,
    6.7107949321368000,
    6.5410975383246000,
    6.4415089787043000,
    6.4630518549789000,
    6.1618295323323000,
    7.8474651145203000,
    7.7435301851253000,
    7.4687640263247000,
    7.2996335503092000,
    7.1813367033978000,
    6.5684985651651000,
    7.0112613643878000,
    6.8910747914874000,
    6.8230446558834000,
    6.7236450688620000,
    6.6673312343898000,
    6.5909863044342000,
    6.9063815719983000,
    6.7582270544607000,
    6.6686540425821000,
    6.6302926050054000,
    6.7261017126477000,
    6.4437766498911000,
    8.0857595617332000,
    8.0547680555136000,
    7.7238770348397000,
    7.5154402582530000,
    6.8799254081523000,
    6.7544476024827000,
    6.6476780841042000,
    6.5673647295717000,
    6.4120292532759000,
    6.3672427473366000,
    6.3001574747271000,
    6.8033915055978000,
    7.2119502644196000,
    7.0823150615742000,
    6.9972773920692000,
    6.9829154745528000,
    7.1184088279641000,
    6.8289028064493000,
    8.4466972256322000,
    8.5959855787632000,
    8.1575691493152000,
    8.2478980515894000,
    8.1896944911282000,
    8.1384829168263000,
    8.0993655888540000,
    8.0587364800905000,
    8.0271780560742000,
    7.5715651201263000,
    8.0028005908161000,
    7.7399397057462000,
    7.8504886761027000,
    7.8049462797678000,
    7.7745216913449000,
    7.7569472396472000,
    7.4474101226490000,
    7.4823700534455000,
    7.3587819737649000,
    7.2688310166885000,
    7.1977773195021000,
    7.0845827327610000,
    5.2713906463155000,
    4.8847527089661000,
    6.8944762982676000,
    5.6997915280218000,
    5.9086062498063000,
    6.0707447396625000,
    5.6773037887527000,
    5.5882976946708000,
    5.3284603711833000,
    5.1515820186129000,
    7.1244559511289000,
    6.1314049439094000,
    6.6592054126371000,
    6.5565932914344000,
    6.4743902109129000,
    6.3320938439412000,
    6.0410760416352000,
    5.8294267308672000,
    7.8416069639544000,
    6.9160191745422000,
    6.6350169199779000,
    6.4626739097811000,
    6.3889745962101000,
    6.6862284942798000,
    6.1552154913708000,
    6.0660204246900000,
    6.0314384390913000,
    5.9562273447291000,
    5.8955671404822000,
    5.8590954288945000,
    6.6274580160219000,
    6.6302926050054000,
    6.6278359612197000,
    6.5212554154401000,
    6.2587724755680000,
    6.0626189179098000,
    8.0523114117279000,
    7.2030685522713000,
    6.9897184881132000,
    6.7361172603894000,
    6.9778132143825000,
    6.8587604770755000,
    6.6864174668787000,
    6.5970334275990000,
    6.5431762369125000,
    6.4690989781437000,
    6.4263911707923000,
    6.1092951498381000,
    6.9396407494047000,
    6.9626954064705000,
    6.9685535570364000,
    6.8402411623833000,
    6.5760574691211000,
    6.3753685690893000,
    8.3792340078249000,
    7.6581145704225000,
    7.3720100556879000,
    7.3595378641605000,
    7.3009563585015000,
    7.2505006745952000,
    7.2098715658317000,
    7.1688645118704000,
    7.1352273892662000,
    6.6034584959616000,
    6.5900414414397000,
    7.3774902610560000,
    7.0127731451790000,
    6.9772462965858000,
    6.9540026669211000,
    6.9398297220036000,
    6.7315819180158000,
    6.8183203409109000,
    6.6945432886314000,
    6.5993010987858000,
    6.5191767168522000,
    6.4220448010176000,
    6.5112398676984000,
    5.2009038669258000,
    4.8233366143236000,
    6.7542586298838000,
    5.5762034483412000,
    5.8110963887739000,
    5.6990356376262000,
    5.6019037217916000,
    5.3551055076282000,
    5.2706347559199000,
    5.0895990061737000,
    6.9780021869814000,
    6.0119742614046000,
    6.5248458948192000,
    6.4602172659954000,
    6.3940768563804000,
    6.0873743283657000,
    5.9764474128114000,
    5.7649870746423000,
    7.6624609401972000,
    6.6730004123568000,
    6.4711776767316000,
    6.3133855566501000,
    6.2001909699090000,
    6.5728449349398000,
    6.0291707679045000,
    5.9515030297566000,
    5.8999135102569000,
    5.8823390585592000,
    5.8303715938617000,
    5.7417434449776000,
    6.4942323337974000,
    6.5312709631818000,
    6.5456328806982000,
    6.2759689820679000,
    6.1911202851618000,
    5.9961005630970000,
    7.8673072374048000,
    6.9589159544925000,
    6.7693764377958000,
    6.5894745236430000,
    6.8644296550425000,
    6.7538806846860000,
    6.5635852775937000,
    6.4717445945283000,
    6.4192102120341000,
    6.3804708292596000,
    6.3353063781225000,
    6.0440996032176000,
    6.8009348618121000,
    6.8595163674711000,
    6.8848386957237000,
    6.6021356877693000,
    6.5038699363413000,
    6.3050707622985000,
    8.1832694227656000,
    7.4156627260338000,
    7.1418414302277000,
    7.1097160884147000,
    7.0537801991403000,
    7.0054032138219000,
    6.9655299954540000,
    6.9258457496850000,
    6.8929645174764000,
    6.3965335001661000,
    6.3370071315126000,
    7.2217768395624000,
    6.7784471225430000,
    6.7453769177355000,
    6.7244009592576000,
    6.7100390417412000,
    6.5868289072584000,
    6.7128736307247000,
    6.6015687699726000,
    6.5127516484896000,
    6.4354618555395000,
    6.3402196656939000,
    6.4039034315232000,
    6.3353063781225000,
    5.1404326352778000,
    4.7588969580987000,
    6.6040254137583000,
    5.4293717389959000,
    5.7065945415822000,
    5.9445110435973000,
    5.5323618053964000,
    5.2583515369914000,
    5.2107304420686000,
    5.0278049663334000,
    6.8200210943010000,
    5.7789710469609000,
    6.3772582950783000,
    6.3640302131553000,
    6.3211334332050000,
    5.9811717277839000,
    5.9070944690151000,
    5.6969569390383000,
    7.4640397113522000,
    6.3980452809573000,
    6.2204110379913000,
    6.0762249450306000,
    5.9722900156356000,
    6.4579495948086000,
    5.8080728271915000,
    5.7338065958238000,
    5.6873193364944000,
    5.6948782404504000,
    5.6417769401595000,
    5.6087067353520000,
    6.3502352134356000,
    6.4320603487593000,
    6.4709887041327000,
    6.1667428199037000,
    6.0112183710090000,
    5.9244799481139000,
    7.6641616935873000,
    6.6835828778952000,
    6.5244679496214000,
    6.3681876103311000,
    6.7476445889223000,
    6.6488119196976000,
    6.4411310335065000,
    6.3485344600455000,
    6.2990236391337000,
    6.2631188453427000,
    6.2438436402549000,
    5.8759139901966000,
    6.6505126730877000,
    6.7548255476805000,
    6.8077378753725000,
    6.4889411010282000,
    6.3207554880072000,
    6.2270250789528000,
    7.9667068244262000,
    7.1435421836178000,
    6.8844607505259000,
    6.8273910256581000,
    6.7752345883617000,
    6.7293142468290000,
    6.6907638366534000,
    6.6525913716756000,
    6.6208439750604000,
    6.1754355594531000,
    6.0777367258218000,
    7.0048362960252000,
    6.5163421278687000,
    6.4861065120447000,
    6.4668313069569000,
    6.4511465812482000,
    6.3593058981828000,
    6.5339165795664000,
    6.4350839103417000,
    6.3528808298202000,
    6.2784256258536000,
    6.1814826826179000,
    6.2977008309414000,
    6.2266471337550000,
    6.1537037105796000,
    4.7838413411535000,
    4.9329407216856000,
    6.1858290523926000,
    6.1036259718711000,
    5.8751580998010000,
    5.6582175562638000,
    5.5102520113251000,
    5.3524598912436000,
    5.3573731788150000,
    5.1430782516624000,
    6.4239345270066000,
    6.5148303470775000,
    6.4919646626106000,
    6.3188657620182000,
    6.1996240521123000,
    6.0790595340141000,
    6.1750576142553000,
    5.9140864551744000,
    7.0851496505577000,
    7.1951317031175000,
    6.9628843790694000,
    6.8226667106856000,
    6.7230781510653000,
    6.0569497399428000,
    6.5768133595167000,
    6.4696658959404000,
    6.3957776097705000,
    6.3570382269960000,
    6.3050707622985000,
    6.2379854896890000,
    6.4133520614682000,
    6.3540146654136000,
    6.3192437072160000,
    6.2610401467548000,
    6.4316824035615000,
    6.1896085043706000,
    7.3134285500289000,
    7.4687640263247000,
    7.1843602649802000,
    7.0201430765361000,
    6.3632743227597000,
    6.2737013108811000,
    6.1383969300687000,
    6.0601622741241000,
    6.0080058368277000,
    5.9635972760862000,
    5.9327947424655000,
    6.4433987046933000,
    6.6915197270490000,
    6.6571267140492000,
    6.6359617829724000,
    6.5991121261869000,
    6.5726559623409000,
    6.5554594558410000,
    7.6382724475380000,
    7.8913067574651000,
    7.5736438187142000,
    7.6439416255050000,
    7.5946197771921000,
    7.5498332712528000,
    7.5154402582530000,
    7.4801023822587000,
    7.4519454650226000,
    7.0329932132613000,
    7.2240445107492000,
    7.1480775259914000,
    7.3019012214960000,
    7.2652405373094000,
    7.2402961542546000,
    7.2234775929525000,
    6.9574041737013000,
    7.0048362960252000,
    6.9078933527895000,
    6.8330602036251000,
    6.7710771911859000,
    6.6626069194173000,
    6.0722565204537000,
    5.9883526865421000,
    5.8951891952844000,
    6.3492903504411000,
    5.6412100223628000,
    5.2687450299309000,
    6.6677091795876000,
    6.3292592549577000,
    6.9840493101462000,
    6.3574161721938000,
    5.9654870020752000,
    5.6795714599395000,
    5.5856520782862000,
    5.3654990005677000,
    6.8572486962843000,
    6.6675202069887000,
    7.8444415529379000,
    7.2299026613151000,
    6.8154857519274000,
    6.5246569222203000,
    6.3268026111720000,
    6.1818606278157000,
    7.3769233432593000,
    7.2491778664029000,
    7.2903738929631000,
    7.0507566375579000,
    6.9116728047675000,
    6.6473001389064000,
    6.7449989725377000,
    6.6437096595273000,
    6.5788920581046000,
    6.5307040453851000,
    6.5091611691105000,
    6.4553039784240000,
    7.7915292252459000,
    7.2835708794027000,
    6.9572152011024000,
    6.7278024660378000,
    6.5758684965222000,
    6.4643746631712000,
    7.6613271046038000,
    7.5851711472471000,
    7.5900844348185000,
    7.4477880678468000,
    7.1238890333322000,
    6.9759234883935000,
    6.8111393821527000,
    6.7347944521971000,
    6.6926535626424000,
    6.6607171934283000,
    6.6429537691317000,
    6.7376290411806000,
    8.0997435340518000,
    7.6414849817193000,
    7.3455538918419000,
    7.1320148550849000,
    6.9891515703165000,
    6.8810592437457000,
    8.0020447004205000,
    8.2511105857707000,
    8.1743877106173000,
    7.7231211444441000,
    7.6745551865268000,
    7.6276899819996000,
    7.5910292978130000,
    7.5547465588242000,
    7.5275345045826000,
    7.3958206031493000,
    7.3368611522925000,
    7.3241999881662000,
    7.3969544387427000,
    7.3653960147264000,
    7.3442310836496000,
    7.3260897141552000,
    7.4058361508910000,
    7.8637167580257000,
    7.6658624469774000,
    7.5180858746376000,
    7.3918521785724000,
    7.2425638254414000,
    7.0150408163658000,
    6.8744452027842000,
    6.7228891784664000,
    6.7004014391973000,
    8.1498212727603000,
    5.8883861817240000,
    5.3823175618698000,
    7.6985547065871000,
    6.3492903504411000,
    6.7459438355322000,
    6.6832049326974000,
    6.2085057642606000,
    5.8655204972571000,
    5.6602962548517000,
    5.5164881070888000,
    7.8295127176248000,
    6.6745121931480000,
    7.4602602593742000,
    7.6025566263459000,
    7.0881732121401000,
    6.7281804112356000,
    6.4893190462260000,
    6.3165980908314000,
    8.1878047651392000,
    7.2353828666832000,
    7.1473216355958000,
    7.1637622517001000,
    6.9744117076023000,
    6.9662858858496000,
    6.7638962324277000,
    6.6558039058569000,
    6.5919311674287000,
    6.5477115792861000,
    6.5222002784346000,
    6.4819491148689000,
    7.4183083424184000,
    7.6715316249444000,
    7.2389733460623000,
    6.9356723248278000,
    6.7370621233839000,
    6.5921201400276000,
    8.3491873645998000,
    8.0343590148324000,
    7.4997555325443000,
    7.4050802604954000,
    7.4615830675665000,
    7.2508786197930000,
    7.0401741720195000,
    6.9436091739816000,
    6.8929645174764000,
    6.8587604770755000,
    6.8394852719877000,
    6.7385739041751000,
    7.6841927890707000,
    7.9952416868601000,
    7.5934859415987000,
    7.3094601254520000,
    7.1189757457608000,
    6.9774352691847000,
    8.5491203742360000,
    8.4723974990826000,
    7.8555909362730000,
    8.1643721628756000,
    8.1244989445077000,
    8.0887831233156000,
    8.0591144252883000,
    8.0277449738709000,
    8.0037454538106000,
    7.2992556051114000,
    7.2656184825072000,
    7.9873048377063000,
    7.8988656614211000,
    7.8744881961630000,
    7.3204205361882000,
    7.3024681392927000,
    7.3313809469244000,
    7.6675632003675000,
    7.6258002560106000,
    7.4389063556985000,
    7.2964210161279000,
    7.1520459505683000,
    7.0653075276732000,
    6.9591049270914000,
    6.8504456827239000,
    6.7070154801588000,
    7.7269005964221000,
    8.0812242193596000,
    5.9367631670424000,
    5.3526488638425000,
    7.1308810194915000,
    6.3848171990343000,
    6.5444990451048000,
    6.7884626702847000,
    6.2765358998646000,
    5.9120077565865000,
    5.6969569390383000,
    5.5493693392974000,
    7.2805473178203000,
    6.7278024660378000,
    7.2057141686559000,
    7.2469101952161000,
    7.1800138952055000,
    6.7877067798891000,
    6.5269245934071000,
    6.3381409671060000,
    7.6824920356806000,
    7.2949092353367000,
    7.1756675254308000,
    7.0596383497062000,
    7.0660634180688000,
    7.2106274562273000,
    6.8134070533395000,
    6.6968109598182000,
    6.6308595228021000,
    6.5862619894617000,
    6.5569712366322000,
    6.5210664428412000,
    7.1586599915298000,
    7.3098380706498000,
    7.3391288234793000,
    7.0023796522395000,
    6.7784471225430000,
    6.6140409615000000,
    7.8561578540697000,
    7.5598488189945000,
    7.4772677932752000,
    7.3578371107704000,
    7.5570142300110000,
    7.4517564924237000,
    7.2134620452108000,
    7.0989446502774000,
    7.0384734186294000,
    6.9982222550637000,
    6.9730888994100000,
    6.7457548629333000,
    7.4045133426987000,
    7.6084147769118000,
    7.6834368986751000,
    7.3640732065341000,
    7.1448649918101000,
    6.9823485567561000,
    8.0814131919585000,
    7.9958086046568000,
    7.8236545670589000,
    7.7129166241035000,
    7.6685080633620000,
    7.6286348449941000,
    7.5955646401866000,
    7.5621164901813000,
    7.5350934085386000,
    7.2399182090568000,
    7.2036354700680000,
    7.4557249170006000,
    7.4096156028690000,
    7.3803248500395000,
    7.3606716997539000,
    7.3446090288474000,
    7.3111608788421000,
    7.4838818342367000,
    7.3905293703801000,
    7.3929860141658000,
    7.2249893737437000,
    7.0747561576182000,
    7.0743782124204000,
    6.9883956799209000,
    6.9078933527895000,
    6.6994565762028000,
    7.4317253969403000,
    7.6832479260762000,
    7.7809467597075000,
    5.6056831737696000,
    5.3307280423701000,
    6.7174089730983000,
    6.3865179524244000,
    6.4222337736165000,
    6.2670872699196000,
    6.1159091907996000,
    6.0388083704484000,
    5.7390978285930000,
    5.5393537915557000,
    6.8833269149325000,
    6.7208104798785000,
    7.0314814324701000,
    7.0123951999812000,
    6.9237670510971000,
    6.8944762982676000,
    6.5658529487805000,
    6.3290702823588000,
    7.3236330703695000,
    8.0232096314973000,
    7.1352273892662000,
    7.0224107477229000,
    6.9339715714377000,
    6.8323043132295000,
    6.7918641770649000,
    6.7355503425927000,
    6.6692209603788000,
    6.6045923315550000,
    6.5611286338080000,
    6.5201215798467000,
    6.9798919129704000,
    7.0660634180688000,
    7.0653075276732000,
    7.1057476638378000,
    6.8177534231142000,
    6.6064820575440000,
    7.5211094362200000,
    8.2237095589302000,
    8.0884051781178000,
    7.2905628655620000,
    7.1915412237384000,
    7.0915747189203000,
    6.9955766386791000,
    6.9192317087235000,
    6.7591719174552000,
    6.6764019191370000,
    6.6212219202582000,
    6.7347944521971000,
    7.2172414971888000,
    7.3478215630287000,
    7.3873168361988000,
    7.4602602593742000,
    7.1800138952055000,
    6.9723330090144000,
    7.7790570337185000,
    8.5476085934448000,
    8.3822575694073000,
    8.3575021589514000,
    8.3206525021659000,
    8.2883381877540000,
    8.2620709965069000,
    8.2354258600620000,
    8.2138829837874000,
    7.9436521673604000,
    7.9438411399593000,
    7.3447980014463000,
    8.1059796298155000,
    8.0816021645574000,
    8.0619490142718000,
    8.0498547679422000,
    7.2580595785512000,
    7.4018677263141000,
    7.3096490980509000,
    7.2282019079250000,
    7.1535577313595000,
    7.0866614313489000,
    6.9453099273717000,
    6.7083382883511000,
    6.5898524688408000,
    6.6898189736589000,
    7.2353828666832000,
    7.4109384110613000,
    7.4715986153082000,
    7.5691084763406000,
    5.3645541375732000,
    5.2704457833210000,
    6.4872403476381000,
    6.7261017126477000,
    6.3283143919632000,
    6.1389638478654000,
    5.9743687142235000,
    5.8581505659000000,
    5.7436331709666000,
    5.5113858469185000,
    6.6644966454063000,
    7.0825040341731000,
    6.9258457496850000,
    6.8527133539107000,
    6.7383849315762000,
    6.6563708236536000,
    6.5690654829618000,
    6.3007243925238000,
    7.1314479372882000,
    7.6218318314337000,
    7.4772677932752000,
    7.3652070421275000,
    7.2794134822269000,
    6.6006239069781000,
    7.1488334163870000,
    7.0692759522501000,
    7.0037024604318000,
    6.9515460231354000,
    6.8920196544819000,
    6.8423198609712000,
    6.8666973262293000,
    6.9010903392291000,
    6.8716106138007000,
    6.8555479428942000,
    6.8238005462790000,
    6.5809707566925000,
    7.3311919743255000,
    7.8325362792072000,
    7.6979877887904000,
    7.5674077229505000,
    6.9623174612727000,
    6.8580045866799000,
    6.7540696572849000,
    6.6730004123568000,
    6.6091276739286000,
    6.5142634292808000,
    6.4314934309626000,
    7.0167415697559000,
    7.0972438968873000,
    7.1745336898374000,
    7.1819036211945000,
    7.1938088949252000,
    7.1837933471835000,
    6.9441760917783000,
    7.6008558729558000,
    8.1649390806723000,
    8.0024226456183000,
    7.9729429201899000,
    7.9349594278110000,
    7.9011333326079000,
    7.8737323057674000,
    7.8463312789269000,
    7.8236545670589000,
    7.5532347780330000,
    7.5481325178627000,
    7.4818031356488000,
    7.7100820351200000,
    7.6843817616696000,
    7.6645396387851000,
    7.6511225842632000,
    7.5366051893298000,
    7.5655179969615000,
    7.4717875879071000,
    7.3960095757482000,
    7.3317588921222000,
    7.2480440308095000,
    6.6818821245051000,
    6.6053482219506000,
    6.4178874038418000,
    6.6781026725271000,
    7.1044248556455000,
    7.2282019079250000,
    7.2580595785512000,
    7.2943423175400000,
    7.3026571118916000,
    5.1801168810468000,
    5.1946677711621000,
    6.3067715156886000,
    6.4156197326550000,
    6.2504576812164000,
    6.0301156308990000,
    5.8507806345429000,
    5.7022481718075000,
    5.7220902946920000,
    5.4667883135781000,
    6.4870513750392000,
    6.7809037663287000,
    6.8459103403503000,
    6.7304480824224000,
    6.5940098660166000,
    6.4706107589349000,
    6.3572271995949000,
    6.2587724755680000,
    6.9570262285035000,
    7.3300581387321000,
    7.1868169087659000,
    7.0700318426457000,
    6.9804588307671000,
    6.4269580885890000,
    6.8455323951525000,
    6.7646521228233000,
    6.6977558228127000,
    6.6403081527471000,
    6.5994900713847000,
    6.5463887710938000,
    6.7765573965540000,
    6.7744786979661000,
    6.7217553428730000,
    6.6626069194173000,
    6.6019467151704000,
    6.5437431547092000,
    7.1571482107386000,
    7.5430302576924000,
    7.4169855342261000,
    7.2811142356170000,
    6.7901634236748000,
    6.6811262341095000,
    6.5681206199673000,
    6.4828939778634000,
    6.4161866504517000,
    6.3581720625894000,
    6.3097950772710000,
    6.7344165069993000,
    7.0020017070417000,
    7.0422528706074000,
    7.0254343093053000,
    6.9912302689044000,
    6.9494673245475000,
    6.9084602705862000,
    7.4324812873359000,
    7.8716536071795000,
    7.7250108704331000,
    7.6875942958509000,
    7.6494218308731000,
    7.6154067630711000,
    7.5876277910328000,
    7.5600377915934000,
    7.5367941619287000,
    7.2754450576500000,
    7.2487999212051000,
    7.2280129353261000,
    7.4207649862041000,
    7.3950647127537000,
    7.3746556720725000,
    7.3601047819572000,
    7.2607051949358000,
    7.2771458110401000,
    7.1790690322110000,
    7.0997005406730000,
    7.0333711584591000,
    6.9470106807618000,
    6.4742012383140000,
    6.3997460343474000,
    6.3164091182325000,
    6.6695989055766000,
    6.9961435564758000,
    7.0859055409533000,
    7.0944093079038000,
    7.0853386231566000,
    7.0619060208930000,
    7.0328042406624000,
    6.4543591154295000,
    5.7678216636258000,
    8.0390833298049000,
    7.2221547847602000,
    7.6416739543182000,
    6.7793919855375000,
    6.2901419269854000,
    5.9870298783498000,
    5.7761364579774000,
    5.6211789268794000,
    8.2443075722103000,
    7.6059581331261000,
    8.8716966005583000,
    7.8835588809102000,
    7.3017122488971000,
    6.9419084205915000,
    6.6962440420215000,
    6.5155862374731000,
    8.8450514641134000,
    8.2174734631665000,
    8.0630828498652000,
    7.8782676481410000,
    7.7594038834329000,
    7.7941748416305000,
    7.5978323113734000,
    7.5144953952585000,
    7.4564808073962000,
    7.4109384110613000,
    7.3841043020175000,
    7.3345934811057000,
    7.5488884082583000,
    7.9347704552121000,
    7.4657404647423000,
    7.1733998542440000,
    6.9778132143825000,
    6.8313594502350000,
    9.1717850876115000,
    8.6250873589938000,
    8.3401166798526000,
    8.2558349007432000,
    8.2006549018644000,
    8.1029560682331000,
    7.9682186052174000,
    7.9156842227232000,
    7.8930075108552000,
    7.8725984701740000,
    7.8627718950312000,
    7.6996885421805000,
    7.9914622348821000,
    8.4778777044507000,
    8.0337920970357000,
    7.7284123772133000,
    7.5354713537364000,
    7.3814586856329000,
    9.5790210382410000,
    9.5329117241094000,
    8.7278884527954000,
    8.7074794121142000,
    8.6511655776420000,
    8.6054342087082000,
    8.5640492095491000,
    8.5228531829889000,
    8.4933734575605000,
    7.9202195650968000,
    7.9963755224535000,
    8.6046783183126000,
    8.3852811309897000,
    8.3571242137536000,
    8.3374710634680000,
    8.3223532555560000,
    8.0566577815026000,
    9.0272210494530000,
    8.8609251624210000,
    8.7129596174823000,
    8.5663168807359000,
    8.4085247606544000,
    8.3302901047098000,
    8.1437741495955000,
    7.9411955235747000,
    7.6535792280489000,
    8.0492878501455000,
    8.5976863321533000,
    8.1364042182384000,
    7.8434966899434000,
    7.6673742277686000,
    7.5069364913025000,
    9.5990521337244000,
    5.7727349511972000,
    6.2750241190734000,
    7.2059031412548000,
    7.5059916283080000,
    7.1195426635575000,
    7.0583155415139000,
    6.6455993855163000,
    6.6658194535986000,
    6.2521584346065000,
    5.9815496729817000,
    7.4644176565500000,
    7.8858265520970000,
    7.6747441591257000,
    7.8410400461577000,
    7.3364832070947000,
    7.6603822416093000,
    7.2187532779800000,
    6.9129956129598000,
    8.2055681894358000,
    8.5247429089779000,
    8.2760549688255000,
    8.1942298335018000,
    8.0787675755739000,
    7.0114503369867000,
    7.9317468936297000,
    7.8206310054765000,
    7.7722540201581000,
    7.7100820351200000,
    7.6811692274883000,
    7.6171075164612000,
    7.5770453254944000,
    7.8648505936191000,
    7.4379614927040000,
    7.8926295656574000,
    7.5031570393245000,
    7.2304695791118000,
    8.5695294149172000,
    8.8864364632725000,
    8.5544116070052000,
    8.5181288680164000,
    7.4761339576818000,
    7.3822145760285000,
    7.2034464974691000,
    7.1063145816345000,
    7.0764569110083000,
    7.0144738985691000,
    6.9761124609924000,
    7.9274005238550000,
    7.9576361396790000,
    8.2851256535727000,
    7.8671182648059000,
    8.3954856513303000,
    8.0243434670907000,
    7.7580810752406000,
    9.0126701593377000,
    9.5712731616861000,
    8.9506871468985000,
    9.0255202960629000,
    8.9758205025522000,
    8.9331126952008000,
    8.8960740658164000,
    8.8584685186353000,
    8.8306895465970000,
    8.3665728436986000,
    8.5931509897797000,
    8.5357033197141000,
    8.6880152344275000,
    8.6536222214277000,
    8.6298116739663000,
    8.6094026332851000,
    8.2777557222156000,
    8.8665943403880000,
    8.8308785191959000,
    8.7195736584438000,
    8.6171505098400000,
    8.4661614033189000,
    7.5870608732361000,
    7.3427193028584000,
    7.0688980070523000,
    7.8508666213005000,
    7.9846592213217000,
    8.3580690767481000,
    7.9222982636847000,
    8.5079243476758000,
    8.1369711360351000,
    7.8595593608499000,
    9.0485749531287000,
    9.3152152901766000,
    6.3967224727650000,
    6.4643746631712000,
    6.9927420496956000,
    7.3321368373200000,
    7.5373610797254000,
    7.3774902610560000,
    6.9388848590091000,
    6.9063815719983000,
    6.5431762369125000,
    6.3060156252930000,
    7.2554139621666000,
    7.6222097766315000,
    8.0073359331897000,
    8.1301681224747000,
    7.6167295712634000,
    7.8249773752512000,
    7.4260562189733000,
    7.1539356765573000,
    7.9192747021023000,
    8.1692854504470000,
    8.0623269594696000,
    7.9695414134097000,
    7.8389613475698000,
    6.9585380092947000,
    7.6932634738179000,
    7.5929190238020000,
    7.5621164901813000,
    7.5110938884783000,
    7.4897399848026000,
    7.4423078624787000,
    7.9355263456077000,
    8.1645611354745000,
    7.7140504596969000,
    8.0402171653983000,
    7.6834368986751000,
    7.4377725201051000,
    8.3057236668528000,
    8.5370261279064000,
    8.2936294205232000,
    8.2405281202323000,
    7.4801023822587000,
    7.4228436847920000,
    7.2546580717710000,
    7.1754785528319000,
    7.1724549912495000,
    7.1193536909586000,
    7.0904408833269000,
    7.7595928560318000,
    8.2454414078037000,
    8.1241209993099000,
    8.0817911371563000,
    8.4767438688573000,
    8.1331916840571000,
    7.8918736752618000,
    8.7299671513833000,
    9.1942728268806000,
    8.8123592045037000,
    8.6696848923342000,
    8.6247094137960000,
    8.5835133872358000,
    8.5474196208459000,
    8.5117037996538000,
    8.4850586632089000,
    8.1791120255898000,
    8.3106369544242000,
    8.2170955179687000,
    8.3529668165778000,
    8.3221642829571000,
    8.3008103792814000,
    8.2783226400123000,
    8.0594923704861000,
    8.7182508502515000,
    8.6180953728345000,
    8.5476085934448000,
    8.4425398284564000,
    8.3049677764572000,
    7.7457978563121000,
    7.5332036825496000,
    7.2935864271444000,
    7.7369161441638000,
    8.0729094250080000,
    8.1768443544030000,
    8.1299791498758000,
    8.5812457160490000,
    8.2346699696664000,
    7.9812577145415000,
    8.7957296158005000,
    8.9661829000083000,
    8.8898379700527000,
    5.8471901551638000,
    6.0612961097175000,
    6.6427647965328000,
    6.9275465030751000,
    7.2355718392821000,
    7.0787245821951000,
    6.6435206869284000,
    6.6512685634833000,
    6.2908978173810000,
    6.0601622741241000,
    6.9356723248278000,
    7.2656184825072000,
    7.6231546396260000,
    7.4661184099401000,
    7.2915077285565000,
    7.5388728605166000,
    7.1407075946343000,
    6.8719885589985000,
    7.8281899094325000,
    7.8646616210202000,
    7.7365381989660000,
    7.6469651870874000,
    7.5477545726649000,
    6.6945432886314000,
    7.3608606723528000,
    7.2427527980403000,
    7.2047693056614000,
    7.1424083480244000,
    7.1119837596015000,
    7.0592604045084000,
    7.5677856681483000,
    7.4937084093795000,
    7.3918521785724000,
    7.7497662808890000,
    7.3892065621878000,
    7.1431642384200000,
    8.1190187391396000,
    8.1881827103370000,
    8.0543901103158000,
    7.9848481939206000,
    7.2178084149855000,
    7.0978108146840000,
    6.8999565036357000,
    6.7918641770649000,
    6.7671087666090000,
    6.6934094530380000,
    6.6476780841042000,
    7.3436641658529000,
    7.8346149777951000,
    7.7756555269383000,
    7.7047908023508000,
    8.1484984645680000,
    7.7869938828723000,
    7.5400066961100000,
    8.4533112665937000,
    8.7224082474273000,
    8.4243984589620000,
    8.3514550357866000,
    8.3061016120506000,
    8.2654725032871000,
    8.2261662027159000,
    8.1906393541227000,
    8.1628603820844000,
    7.9633053176460000,
    8.0009108648271000,
    7.8873383328882000,
    8.0233986040962000,
    7.9893835362942000,
    7.9667068244262000,
    7.9442190851571000,
    7.8722205249762000,
    8.2382604490455000,
    8.0987986710573000,
    8.0207529877116000,
    7.9094481269595000,
    7.7709312119658000,
    7.1505341697771000,
    6.9691204748331000,
    6.7682426022024000,
    7.3005784133037000,
    7.8584255252565000,
    7.8238435396578000,
    7.7546795684604000,
    8.2569687363366000,
    7.8867714150915000,
    7.6284458723952000,
    8.5217193473955000,
    8.6054342087082000,
    8.5491203742360000,
    8.3624154465228000,
    5.7045158429943000,
    6.0316274116902000,
    6.6380404815603000,
    6.9683645844375000,
    7.0683310892556000,
    6.9812147211627000,
    6.5577271270278000,
    6.5928760304232000,
    6.2198441201946000,
    5.9796599469927000,
    6.9294362290641000,
    7.3177749198036000,
    7.5475656000660000,
    7.7131055967024000,
    7.1911632785406000,
    7.4948422449729000,
    7.0849606779588000,
    6.8075489027736000,
    7.6397842283292000,
    7.9275894964539000,
    7.8359377859874000,
    7.6562248444335000,
    7.5730769009175000,
    6.6178204134780000,
    7.3997890277262000,
    7.2841377971994000,
    7.2455873870238000,
    7.1824705389912000,
    7.1516680053705000,
    7.0957321160961000,
    7.4836928616378000,
    7.3457428644408000,
    7.2875393039796000,
    7.7087592269277000,
    7.3387508782815000,
    7.0855275957555000,
    7.9771003173657000,
    8.2588584623256000,
    8.1825135323700000,
    7.9597148382669000,
    7.1134955403927000,
    7.0165525971570000,
    6.8302256146416000,
    6.7272355482411000,
    6.7036139733786000,
    6.6316154131977000,
    6.5862619894617000,
    7.3841043020175000,
    7.7696084037735000,
    7.6482879952797000,
    7.6189972424502000,
    8.1256327801011000,
    7.7573251848450000,
    7.5041019023190000,
    8.3752655832480000,
    8.8261542042234000,
    8.5553564699997000,
    8.4245874315609000,
    8.3775332544348000,
    8.3268885979296000,
    8.2907948315397000,
    8.2550790103476000,
    8.2273000383093000,
    8.0744212057992000,
    8.0405951105961000,
    7.9428962769648000,
    8.0868933973266000,
    8.0526893569257000,
    8.0296346998599000,
    8.0077138783875000,
    7.9976983306458000,
    8.2514885309685000,
    8.1373490812329000,
    8.0717755894146000,
    7.9661399066295000,
    7.8264891560424000,
    7.1167080745740000,
    6.9216883525092000,
    6.7039919185764000,
    7.3302471113310000,
    7.7919071704437000,
    7.6983657339882000,
    7.6675632003675000,
    8.2344809970675000,
    7.8586144978554000,
    7.5934859415987000,
    8.4268551027477000,
    8.6789445496803000,
    8.4782556496485000,
    8.2794564756057000,
    8.4270440753466000,
    5.6455563921375000,
    5.9855180975586000,
    6.6085607561319000,
    6.9381289686135000,
    7.0135290355746000,
    6.9337825988388000,
    6.5093501417094000,
    6.5528138394564000,
    6.1765693950465000,
    5.9346844684545000,
    6.9061925993994000,
    7.2903738929631000,
    7.4903069025993000,
    7.6686970359609000,
    7.1424083480244000,
    7.4574256703907000,
    7.0439536239975000,
    6.7637072598288000,
    7.6146508726755000,
    7.9035899763936000,
    7.7945527868283000,
    7.6263671738073000,
    7.5449199836814000,
    6.5813487018903000,
    7.3712541652923000,
    7.2550360169688000,
    7.2170525245899000,
    7.1528018409639000,
    7.1218103347443000,
    7.0651185550743000,
    7.4247334107810000,
    7.2954761531334000,
    7.2387843734634000,
    7.6724764879389000,
    7.2990666325125000,
    7.0428197884041000,
    7.9485654549318000,
    8.2327802436774000,
    8.1299791498758000,
    7.9234320992781000,
    7.0677641714589000,
    6.9708212282232000,
    6.7841163005100000,
    6.6801813711150000,
    6.6567487688514000,
    6.5834274004782000,
    6.5373180863466000,
    7.3487664260232000,
    7.7125386789057000,
    7.5983992291701000,
    7.5700533393351000,
    8.0899169589090000,
    7.7182078568727000,
    7.4617720401654000,
    8.3454079126218000,
    8.7951626980038000,
    8.5047118134945000,
    8.3986981855116000,
    8.3518329809844000,
    8.3021331874737000,
    8.2658504484849000,
    8.2301346272928000,
    8.2025446278534000,
    8.0283118916676000,
    8.0148948371457000,
    7.9192747021023000,
    8.0608151786784000,
    8.0264221656786000,
    8.0033675086128000,
    7.9814466871404000,
    7.9496992905252000,
    8.2033005182490000,
    8.0912397671013000,
    8.0273670286731000,
    7.9219203184869000,
    7.7822695678998000,
    7.0573706785194000,
    6.8623509564546000,
    6.6457883581152000,
    7.2909408107598000,
    7.7340815551803000,
    7.6475321048841000,
    7.6180523794557000,
    8.1997100388699000,
    7.8198751150809000,
    7.5517229972418000,
    8.3958635965281000,
    8.6524883858343000,
    8.4529333213959000,
    8.2369376408532000,
    8.3658169533030000,
    8.3066685298473000,
    5.6047383107751000,
    5.9416764546138000,
    6.5753015787255000,
    6.8980667776467000,
    6.9568372559046000,
    6.8929645174764000,
    6.4670202795558000,
    6.5178539086599000,
    6.1404756286566000,
    5.8976458390701000,
    6.8642406824436000,
    7.2518234827875000,
    7.4449534788633000,
    7.2397292364579000,
    7.1017792392609000,
    7.4217098491986000,
    7.0080488302065000,
    6.7270465756422000,
    7.5740217639120000,
    7.8690079907949000,
    7.7586479930373000,
    7.5887616266262000,
    7.5071254639014000,
    6.5511130860663000,
    7.3325147825178000,
    7.2164856067932000,
    7.1788800596121000,
    7.1136845129916000,
    7.0815591711786000,
    7.0246784189097000,
    7.3791910144461000,
    7.2610831401336000,
    7.1989111550955000,
    7.6367606667468000,
    7.2633508113204000,
    7.0065370494153000,
    7.9060466201793000,
    8.1949857238974000,
    8.0910507945024000,
    7.8775117577454000,
    7.0473551307777000,
    6.9369951330201000,
    6.7463217807300000,
    6.6429537691317000,
    6.6214108928571000,
    6.5543256202476000,
    6.5076493883193000,
    7.3062475912707000,
    7.6675632003675000,
    7.5626834079780000,
    7.5290462853738000,
    8.0525003843268000,
    7.6804133370927000,
    7.4237885477865000,
    8.3011883244792000,
    8.7509431098612000,
    8.4657834581211000,
    8.3609036657316000,
    8.3140384612044000,
    8.2650945580893000,
    8.2291897642983000,
    8.1934739431062000,
    8.1658839436668000,
    7.9888166184975000,
    7.9776672351624000,
    7.8756220317564000,
    8.0247214122885000,
    7.9903283992887000,
    7.9672737422229000,
    7.9453529207505000,
    7.9068025105749000,
    8.1513330535515000,
    8.0430517543818000,
    7.9795569611514000,
    7.8739212783663000,
    7.7350264181748000,
    7.0173084875526000,
    6.8236115736801000,
    6.6068600027418000,
    7.2474771130128000,
    7.6889171040432000,
    7.6120052562909000,
    7.5776122432911000,
    8.1634272998811000,
    7.7834034034932000,
    7.5150623130552000,
    8.3510770905888000,
    8.6128041400653000,
    8.4123042126324000,
    8.1947967512985000,
    8.3257547623362000,
    8.2666063388805000,
    8.2276779835071000,
    5.4354188621607000,
    5.9137085099766000,
    6.7270465756422000,
    7.0798584177885000,
    6.7385739041751000,
    6.7682426022024000,
    6.3492903504411000,
    6.4296037049736000,
    6.0238795351353000,
    5.7606407048676000,
    6.9936869126901000,
    7.4551579992039000,
    7.2688310166885000,
    7.5349044359397000,
    7.0069149946131000,
    7.3856160828087000,
    6.9458768451684000,
    6.6423868513350000,
    7.7155622404881000,
    8.0842477809420000,
    7.8444415529379000,
    7.7970094306140000,
    7.6668073099719000,
    6.5885296606485000,
    7.5105269706816000,
    7.3982772469350000,
    7.3567032751770000,
    7.2901849203642000,
    7.2569257429578000,
    7.1947537579197000,
    7.1766123884253000,
    7.5657069695604000,
    7.1061256090356000,
    7.6133280644832000,
    7.2206430039690000,
    6.9460658177673000,
    8.0589254526894000,
    8.4202410617862000,
    8.0997435340518000,
    7.9599038108658000,
    7.0086157480032000,
    6.9407745849981000,
    6.7652190406200000,
    6.6661973987964000,
    6.6452214403185000,
    6.5730339075387000,
    6.5269245934071000,
    7.4744332042917000,
    7.5245109430002000,
    7.9444080577560000,
    7.4840708068356000,
    8.0725314798102000,
    7.6891060766421000,
    7.4177414246217000,
    8.4790115400441000,
    9.0313784466288000,
    8.4882711973902000,
    8.5683955793238000,
    8.5207744844010000,
    8.4788225674452000,
    8.4432957188520000,
    8.4066350346654000,
    8.3792340078249000,
    7.9411955235747000,
    8.1488764097658000,
    8.0710196990190000,
    8.2367486682543000,
    8.2027336004523000,
    8.1789230529909000,
    8.1587029849086000,
    7.8421738817511000,
    8.3034559956660000,
    8.2949522287155000,
    8.1749546284140000,
    8.0738542880025000,
    7.9294792224429000,
    7.0602052675029000,
    6.8394852719877000,
    6.5981672631924000,
    7.3916632059735000,
    7.5426523124946000,
    7.5228101896101000,
    7.5335816277474000,
    8.1879937377381000,
    7.8000329921964000,
    7.5177079294398000,
    8.5220972925933000,
    8.8380594779541000,
    8.5336246211262000,
    8.1808127789799000,
    8.2409060654301000,
    8.2131270933918000,
    8.1758994914085000,
    8.3792340078249000
};

}
#endif
