# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: list.t,v 1.1 2000/11/23 23:36:17 muaddib Exp $

use strict;
use Test;
use AtomicData;
use AtomicData::List;
use AtomicData::Text;
use Data::Dumper;

use Error qw(:try);

my ($success,$problems);

plan tests => 17;

my $datum = AtomicData::List->new('AtomicData::Text');
ok $datum;
ok !$datum->data_count();
ok !$datum->set_value('this','that');
ok $datum->value() eq 'this';
ok join(",",$datum->value()) eq 'this,that';

$datum = AtomicData::List->new('AtomicData::Text');
ok $datum;
ok $datum->parameters({blank_ok => 0});
($success,$problems) = $datum->verify();
ok !$success;
ok @$problems;

$datum->set_value("");
($success,$problems) = $datum->verify();
ok !$success;
ok @$problems;

$datum->set_value("here");
($success,$problems) = $datum->verify();
ok $success;
ok !@$problems;

$datum->set_value();
($success,$problems) = $datum->verify();
ok !$success;
ok @$problems;

$datum->set_value("");
($success,$problems) = $datum->verify();
ok !$success;
ok @$problems;

