class Puppet::Rails::ParamValue < ActiveRecord::Base
    belongs_to :param_name
    belongs_to :resource

    def value
        val = self[:value]
        if val =~ /^--- \!/
            YAML.load(val)
        else
            val
        end
    end

    # I could not find a cleaner way to handle making sure that resource references
    # were consistently serialized and deserialized.
    def value=(val)
        if val.is_a?(Puppet::Parser::Resource::Reference)
            self[:value] = YAML.dump(val)
        else
            self[:value] = val
        end
    end
end

# $Id: param_value.rb 2706 2007-07-18 19:47:09Z luke $
