/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Misc helperfunctions used throughout the program 
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __HELPER_H__
#define __HELPER_H__

gboolean misc_str_is_equal (const gchar *s1, const gchar *s2);
gboolean misc_str_is_only_whitespace (const gchar *s1);
gboolean misc_validate_username (const gchar *user);
gboolean misc_command_exists (const gchar *cmd);

gint misc_stop_server (void);
gint misc_start_server (void);

gint misc_close_connection (guint pid);
gint misc_get_pureftpd_pid (void);
GList *misc_get_user_ids (void);
GList *misc_get_group_ids (void);
gboolean misc_create_passwd_file (void);
gboolean misc_create_system_account (gboolean create_user, gboolean create_group);
gchar *misc_crypt_passwd (const gchar * const pwd);

#define MISC_VALID_STRING(s) ((s != NULL && *(s) != 0))

#define pur_warning(...) \
    fprintf (stderr, "%s, %s:%d *WARNING* ", __FILE__, __FUNCTION__, __LINE__); \
    fprintf (stderr, __VA_ARGS__)

#define pur_error(...) \
    fprintf (stderr, "%s, %s:%d *ERROR* ", __FILE__, __FUNCTION__, __LINE__); \
    fprintf (stderr, __VA_ARGS__)
#define debug_print(...) \
{\
  g_print ("%s :", __FUNCTION__);\
  g_print (__VA_ARGS__); \
}

#endif /* __HELPER_H__ */
