/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Configuration back-end.
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __CFG_H__
#define __CFG_H__
#define RCFILE ".pureadminrc"

typedef enum
{
	LOG_SYSLOG,
	LOG_CUSTOM,
	NUM_LOGMETHODS
} logmethod_t;

typedef struct conf_ 
{
	guint default_uid, default_gid;
	gchar *default_home;
	gchar *cmd_purepw, *cmd_ftpwho, *cmd_startstop;
	gchar *cmd_useradd, *cmd_groupadd;
	gchar *pwfile, *pdbfile;
	gchar *logfile;
	gchar *uname_encoding;
	gboolean seen_usrdlg_welcome;
	gboolean resolve_hostnames;
	gboolean show_fam_errmsg;
	gboolean save_window_geometry;
	gboolean use_system_encoding;
	gboolean use_tray_icon;
	logmethod_t logmethod;
	gint win_pos[2];
	gint win_size[2];
	gint div_pos;
} cfg_t;

extern cfg_t cfg;


/* cfg_set_defaults: Sets sane default values for the cfg variables.
 *		     In an OOP-language, this would be the constructor */
void cfg_set_defaults (void);

/* cfg_fill_missing: Tries to fill cfg-variables with good values taken from the
 *		     users' system. See also cfg_find_* below. */
void cfg_fill_missing (void);

/* cfg_read/write_settings: Reads or writes the settings from/to the users
 *			    configuration file (~/.pureadminrc). */
gboolean cfg_read_settings (void);
gboolean cfg_write_settings (void);

/* Free's all allocated memory */
void cfg_terminate (void);

/* cfg_find_*:  These functions will try to find valid values
 *		for their respective configuration variable.
 *		Values are found by probing the file system for
 *		known location of files and looking in system
 *		files for configuration.
 *
 *  Note: You need to free all strings returned by these functions!
 */
gchar *cfg_find_default_home (void);
gchar *cfg_find_pwfile (void);
gchar *cfg_find_pdbfile (void);
guint cfg_find_ftpuser_uid (void);
guint cfg_find_ftpgroup_gid (void);

#endif /* __CFG_H__ */
