/* 
    Default SIMD (non-)functionality
    added by T.Grill

    This is used when there's no implementation of SIMD code 
    for the current platform and/or compiler
*/

#ifndef __M_SIMD_DEF_H
#define __M_SIMD_DEF_H

/* These are the functions that can be coded for SIMD */

/* functions in d_ugen.c */
#define zero_perf_simd          zero_perf8

/* functions in d_dac.c */
#define copy_perf_simd          copy_perf8

/* functions in d_ctl.c */
#define sig_tilde_perf_simd     sig_tilde_perf8

/* functions in d_arithmetic.c */
#define plus_perf_simd          plus_perf8
#define scalarplus_perf_simd    scalarplus_perf8
#define minus_perf_simd         minus_perf8
#define scalarminus_perf_simd   scalarminus_perf8
#define times_perf_simd         times_perf8
#define scalartimes_perf_simd   scalartimes_perf8
#define sqr_perf_simd           sqr_perf8
#define over_perf_simd          over_perf8
#define scalarover_perf_simd    scalarover_perf8
#define min_perf_simd           min_perf8
#define scalarmin_perf_simd     scalarmin_perf8
#define max_perf_simd           max_perf8
#define scalarmax_perf_simd     scalarmax_perf8

/* functions in d_math.c */
#define clip_perf_simd          clip_perform  /* SIMD not implemented */
#define sigwrap_perf_simd       sigwrap_perform  /* SIMD not implemented */
#define sigsqrt_perf_simd       sigsqrt_perform  /* SIMD not implemented */
#define sigrsqrt_perf_simd      sigrsqrt_perform /* SIMD not implemented */

#endif /* __M_SIMD_DEF_H */
