#!/usr/bin/env python

# Copyright (C) 2005 Maciej Katafiasz
#
# Author: Maciej Katafiasz
#
# This file is part of Purrr programme.
#
# Purrr is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2, or (at your
# option) any later version.
#
# Purrr is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Purrr; see the file COPYING. If not, write to the
# Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.



import sys, os, glob, shutil
import optparse
from constants import name, version

known_actions = "install"
usage = "%prog [options] " + known_actions
parser = optparse.OptionParser(usage = usage)
parser.set_defaults(nautilus = True, prefix = "/usr/local/")
parser.add_option("--prefix", action="store", dest="prefix",
                  help="Installation prefix directory")
parser.add_option("--enable-nautilus", action="store_true", dest="nautilus",
                  help="Install support for Nautilus")
parser.add_option("--disable-nautilus", action="store_false", dest="nautilus")

options, actions = parser.parse_args()
options.prefix = options.prefix.rstrip("/") + "/"

INSTALL_FILES = glob.glob("*.py") + ["README", "logo128.png", "purrr.glade"]
NAUTILUS_SCRIPT = "Mass rename"
BINARY_WRAPPER = "purrr"

def ensure_dir(d):
    cwd = os.getcwd()
    try:
        os.chdir(d)
        os.chdir(cwd)
    except OSError:
        os.makedirs(d)
    return d

def create_executable(text, outlocation, outfile):
    drt = ensure_dir(outlocation)
    scriptfile = open(drt + outfile, "w")
    scriptfile.write(text)
    scriptfile.close()
    os.chmod(drt + outfile, 0755)
    
    
for act in actions:
    if act == "install":
        nautilus_script = open("purrr.sh", "r").read() % (options.prefix + "bin/purrr")
        binary_wrapper = open("purrr.in", "r").read() % (options.prefix + "lib/purrr")
        
        constants = open("constants.py.in", "r").read() % (options.prefix + "lib/purrr")
        open("constants.py", "w").write(constants)

        cwd = os.getcwd() + "/"
        location = options.prefix + "lib/purrr/"
        ensure_dir(location)
        for f in INSTALL_FILES:
            shutil.copy(cwd + f, location + f)

        location = options.prefix + "bin/"
        create_executable(binary_wrapper, location, BINARY_WRAPPER)

        if options.nautilus:
            location = os.environ["HOME"] + "/.gnome2/nautilus-scripts/"
            create_executable(nautilus_script, location, NAUTILUS_SCRIPT)
            
        os.chdir(cwd)
    elif act == "dist":
        cwd = os.getcwd()
        tmp = os.tempnam(os.getcwd(), "dist")
        os.mkdir(tmp)
        os.system("cp -R $(ls | grep -v %s | grep -v '{arch}' ) %s" % (os.path.basename(tmp), tmp + "/"))
        os.chdir(tmp)
        os.system("rm -rf *~ *.bak *.pyc *.pyo .* semantic.cache")
        os.chdir(cwd)
        os.system("mv %s %s-%s" % (os.path.basename(tmp), name.lower(), version))
        os.system("tar czf %s-%s.tgz %s-%s" % (name.lower(), version, name.lower(), version))
        os.chdir(cwd)
        os.system("rm -rf %s-%s" % (name.lower(), version))
    else:
        parser.print_help()
if not actions:
    parser.print_help()
    
