/*
 * Copyright (C) 2016 Fanout, Inc.
 *
 * This file is part of Pushpin.
 *
 * Pushpin is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * Pushpin is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SEQUENCER_H
#define SEQUENCER_H

#include <QObject>

class PublishLastIds;
class PublishItem;

class Sequencer : public QObject
{
	Q_OBJECT

public:
	Sequencer(PublishLastIds *publishLastIds, QObject *parent = 0);
	~Sequencer();

	// note: may emit signals
	void addItem(const PublishItem &item);

	void clearPendingForChannel(const QString &channel);

signals:
	void itemReady(const PublishItem &item);

private:
	class Private;
	friend class Private;
	Private *d;
};

#endif
