/*
 * Copyright (C) 1999  Ross Combs (rocombs@cs.nmsu.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_ADBANNER_TYPES
#define INCLUDED_ADBANNER_TYPES

typedef struct adbanner
#ifdef ADBANNER_INTERNAL_ACCESS
{
    unsigned int id;
    unsigned int extensiontag;
    unsigned int delay; /* in seconds */
    unsigned int next; /* adid or 0 */
    char const * filename;
    char const * link;
    char const * client;
}
#endif
t_adbanner;

#endif


/*****/
#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_ADBANNER_PROTOS
#define INCLUDED_ADBANNER_PROTOS

#define JUST_NEED_TYPES
#include "connection.h"
#undef JUST_NEED_TYPES

extern t_adbanner * adbanner_pick(t_connection const * c, unsigned int prev_id);
extern t_adbanner * adbanner_get(t_connection const * c, unsigned int id);
extern unsigned int adbanner_get_id(t_adbanner const * ad);
extern unsigned int adbanner_get_extensiontag(t_adbanner const * ad);
extern char const * adbanner_get_filename(t_adbanner const * ad);
extern char const * adbanner_get_link(t_adbanner const * ad);
extern char const * adbanner_get_client(t_adbanner const * ad);

extern int adbannerlist_create(char const * filename);
extern int adbannerlist_destroy(void);

#endif
#endif
