/*
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * Copyright (C) 2000,2001  Marco Ziech (mmz@gmx.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_ACCOUNT_TYPES
#define INCLUDED_ACCOUNT_TYPES

#include "storage.h"
#ifndef JUST_NEED_TYPES
#define JUST_NEED_TYPES
#include "common/list.h"
#include "clan.h"
#undef JUST_NEED_TYPES
#else
#include "common/list.h"
#include "clan.h"
#endif

#ifdef ACCOUNT_INTERNAL_ACCESS
typedef struct attribute_struct
{
    char const *              key;
    char const *              val;
    int			      dirty;  // 1 = needs to be saved, 0 = unchanged
    struct attribute_struct * next;
} t_attribute;
#endif

#define ACCOUNT_CLIENTTAG_UNKN 0x00; // used for all non warcraft 3 clients so far
#define ACCOUNT_CLIENTTAG_WAR3 0x01;
#define ACCOUNT_CLIENTTAG_W3XP 0x02;

#define ACCOUNT_FLAG_NONE	0
#define ACCOUNT_FLAG_LOADED	1
#define ACCOUNT_FLAG_ACCESSED	2
#define ACCOUNT_FLAG_DIRTY	4
#define ACCOUNT_FLAG_FLOADED	8	/* friend loaded */

struct connection;

typedef struct account_struct
#ifdef ACCOUNT_INTERNAL_ACCESS
{
    t_attribute * attrs;
    char	* name;     /* profiling proved 99% of getstrattr its from get_name */
    unsigned int  namehash; /* cached from attrs */
    unsigned int  uid;      /* cached from attrs */
    unsigned int  flags;
    unsigned int  age;      /* number of times it has not been accessed */
    struct connection * conn;
    t_storage_info * storage;
    t_clanmember * clanmember;
    t_list * friends;
}
#endif
t_account;

#endif

/*****/
#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_ACCOUNT_PROTOS
#define INCLUDED_ACCOUNT_PROTOS

#define JUST_NEED_TYPES
#include "common/hashtable.h"
#include "connection.h"
#undef JUST_NEED_TYPES

extern unsigned int maxuserid;

extern int accountlist_reload(void);
extern t_account * account_load_new(char const * name, unsigned uid);
extern int account_check_name(char const * name);
extern t_account * account_create(char const * username, char const * passhash1) ;
extern t_account * create_vaccount(const char *username, unsigned int uid);
extern void account_destroy(t_account * account);
extern unsigned int account_get_uid(t_account const * account);
extern int account_match(t_account * account, char const * username);
extern int account_save(t_account * account, unsigned int delta);
#ifdef DEBUG_ACCOUNT
extern char const * account_get_strattr_real(t_account * account, char const * key, char const * fn, unsigned int ln);
#define account_get_strattr(A,K) account_get_strattr_real(A,K,__FILE__,__LINE__)
#else
extern char const * account_get_strattr(t_account * account, char const * key);
#endif
extern int account_unget_strattr(char const * val);
extern int account_set_strattr(t_account * account, char const * key, char const * val);

extern char const * account_get_first_key(t_account * account);
extern char const * account_get_next_key(t_account * account, char const * key);

extern int accountlist_create(void);
extern int accountlist_destroy(void);
extern t_hashtable * accountlist(void);
extern t_hashtable * accountlist_uid(void);
extern int accountlist_load_default(void);
extern void accountlist_unload_default(void);
extern unsigned int accountlist_get_length(void);
extern int accountlist_save(unsigned int delta, int *syncdeltap);
extern t_account * accountlist_find_account(char const * username);
extern t_account * accountlist_find_account_by_uid(unsigned int uid);
extern t_account * accountlist_find_account_by_storage(t_storage_info *);
extern int accountlist_allow_add(void);
extern t_account * accountlist_add_account(t_account * account);
// aaron
//extern int accounts_rank_all(void);
extern void accounts_get_attr(char const *);
/* names and passwords */
#ifdef DEBUG_ACCOUNT
extern char const * account_get_name_real(t_account * account, char const * fn, unsigned int ln);
# define account_get_name(A) account_get_name_real(A,__FILE__,__LINE__)
#else
extern char const * account_get_name(t_account * account);
#endif


// THEUNDYING MUTUAL FRIEND CHECK 7/27/02 UPDATED!
// moved to account.c/account.h by Soar to direct access struct t_account
extern int account_check_mutual( t_account * account,  int myuserid);
extern t_list * account_get_friends(t_account * account);

//clan thingy by DJP & Soar
extern int account_set_clanmember(t_account * account, t_clanmember * clanmember);
extern t_clanmember * account_get_clanmember(t_account * account);
extern t_clan * account_get_clan(t_account * account);
extern t_clan * account_get_creating_clan(t_account * account);

int account_set_conn(t_account * account, t_connection * conn);
t_connection * account_get_conn(t_account * account);

#endif
#endif

#include "account_wrap.h"
