#-*- coding: utf-8 -*-


licence="""
    file burettelistwidget.py: part of the package pyacidobasic version %s:

    Copyright (C) 2010 Georges Khaznadar <georgesk@ofset.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from becherlistwidget import BecherListWidget

class BuretteListWidget(BecherListWidget):

    def renseigneParametres(self,ab):
        """
        Renseigne les paramètres manquants pour l'acide/base ajouté
        """
        ab.c=QInputDialog.getDouble(None,u"burette", QString("Entrez la concentration (%s)" %ab.nom),0.1,0.0,50,3)[0]

    def vide(self):
        """
        Supprime les contenus de la liste
        et réactive la réception des drops
        """
        BecherListWidget.vide(self)
        self.setAcceptDrops(True)
        
    def dropEvent(self, event):
        BecherListWidget.dropEvent(self, event)
        # interdit les drops dès qu'on a un produit là.
        if self.count()>0:
            self.setAcceptDrops(False)

    def nouveauTexte(self,ab):
        """
        Le nouveau texte à afficher concernent l'acide/base
        @param ab : l'acide/base à considérer
        """
        return "%s %s mol/L" %(ab.nom,ab.c)

    def chargeNette(self,pH,v):
       """
       Renvoie la charge nette de ce qui a coulé de la burette, en
       fonction du pH, compte non tenu des ions H+. UNité : le Faraday.
       @param pH le pH
       @param v le volume versé.
       """
       if len (self.contenu) >0:
           ab=self.contenu[0]
           ab.v=v
           return ab.chargeNette(pH)
       else:
           return 0.0
       
    def chargeEau(self,pH,v):
       """
       renvoie la charge électrique porté par les protons et les ions
       hydroxyde, en fonction du pH et du volume v versé de la burette
       @param pH le pH
       @param v le volume versé.
       """
       return (10**(-pH)-10**(pH-14))*v*1e-3
    
    def charge(self, pH, v):
        """
        Renvoie la charge électrique totale, en fonction du pH
        et du volume v versé de la burette
        @param pH le pH
        @param v le volume versé.
        """
        return self.chargeNette(pH,v) + self.chargeEau(pH,v)
