"""A Python version of anx"""
import re
import sys
import annodex
from optparse import OptionParser

def search_meta(regexp, metas):
    match = 0
    for meta in metas:
        if reg.search(str(meta.name)) or reg.search(str(meta.content)):
            match = 1
            break
    return match

def main():
    # Generate option parser
    parser = OptionParser(usage = "%prog [options] pattern file",
                          description = "Extract (rip) data from annodex media.")
    parser.add_option("--head",
                      action="store_true", dest="search_head",
                      default=False,
                      help="Search only the CMML head element (ignore clips)")
    parser.add_option("--meta",
                      action="store_true", dest="search_meta",
                      default=False,
                      help="Search only the CMML meta elements (ignore clip descriptions)")
    parser.add_option("-o", "--output",
                      action="store", type="string", dest="output",
                      help="Specify output filename (default is stdout).")
    (options, args) = parser.parse_args()

    # Get input filename
    if len(args) != 2:
        parser.print_help()
        return

    pattern = args[0]
    filename = args[1]
    reg = re.compile(pattern)

    # Setup output file
    output = sys.stdout
    if options.output:
        output = open(options.output, "w")

    # Generate anx object
    anx = annodex.Reader(filename)

    match = 0
    if reg.search(str(anx.head.title)):
        match = 1
    if not match:
        match = search_meta(anx.head.meta)

    if match:
        print >> output, anx.head._xml()

    # Now do the actual work
    if not options.search_head:
        for clip in anx.clips:
            match = 0
            if not options.search_meta and clip.desc:
                if reg.search(str(clip.desc)):
                     match = 1
            if not match:
                match = search_meta(clip.meta)
            if match:
                print >> output, clip._xml()

if __name__ == "__main__":
    main()
