#!/usr/bin/python
# -*- coding: utf-8 -*-

#  Copyright © 2012  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import print_function, division

import sys
import re

from bcpath import path

srcdir = path('/usr/include/GL')
dstdir = path('pybiklib')
filenames = ['gl.h', #'glext.h'
]
dstfilename = dstdir / 'gl.pxd'

def convert_file(*psrc):
    src = [(_psrc, _psrc.text()) for _psrc in psrc]
    yield '\n\n# from {}:\n'.format(psrc[0])
    yield "cdef extern from '{}/{}':".format(psrc[0].dirname.basename, psrc[0].basename)
    for match in re.finditer(r'^\#define[ \t]+(\w+).*?$', src[0][1], re.MULTILINE | re.DOTALL):
        if match.group(1).startswith('GL_'):
            yield match.expand(r'    enum: \1')
            
    for psrc, tsrc in src:
        yield '\n\n# from {}:\n'.format(psrc)
        for match in re.finditer(r'^(typedef[\s\w]*);.*?$', tsrc, re.MULTILINE | re.DOTALL):
            mg1 = match.group(1)
            if mg1.find('_t') == -1 and not (mg1[-2:].isalpha() and mg1[-2:].isupper()):
                yield match.expand(r'c\1')
            
    for psrc, tsrc in src:
        yield '\n\n# from {} with:\n'.format(psrc)
        yield "cdef extern from '{}/{}':".format(psrc.dirname.basename, psrc.basename)
        for match in re.finditer(r'^GLAPI([\s\w*]*?)G?L?APIENTRY([^(]*)\(([^)]*)\);(.*?)$', tsrc,
                                                            re.MULTILINE | re.DOTALL):
            mg2s2 = match.group(2).strip()[-2:]
            if mg2s2.isalpha() and mg2s2.isupper():
                continue
            for mgf in (match.group(1).find, match.group(3).find):
                if not mgf('GLsizeiptr') == mgf('GLintptr') == mgf('64') == mgf('GLsync') == -1:
                    break
            else:
                if match.group(3).strip() == 'void':
                    template = r'    cdef\1\2()\4'
                else:
                    template = r'    cdef\1\2(\3)\4'
                yield match.expand(template).replace('const ', '').replace(' in,', ' in_,').replace('/*', '#/*')
                
def main():
    pdst = dstfilename
    with open(pdst, 'w') as fdst:
        print('# {}'.format(pdst), file=fdst)
        print('# generated with {}'.format(sys.argv[0]), file=fdst)
        psrc = srcdir / 'gl.h'
        psrcext = srcdir / 'glext.h'
        for token in convert_file(psrc, psrcext):
            print(token, file=fdst)
            

if __name__ == '__main__':
    main()
    

