/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;

public class RotatedLatLon
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "rotated_lat_lon";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double lon = this.readAttributeDouble(ctv, "grid_south_pole_longitude", Double.NaN);
        double lat = this.readAttributeDouble(ctv, "grid_south_pole_latitude", Double.NaN);
        double angle = this.readAttributeDouble(ctv, "grid_south_pole_angle", Double.NaN);
        ucar.unidata.geoloc.projection.RotatedLatLon proj = new ucar.unidata.geoloc.projection.RotatedLatLon(lat, lon, angle);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

