#!/bin/sh
set -eu
VER=""
while [ $# -gt 1 ]; do
	case "$1" in
		"--upstream-version")
			VER="$2"
			shift
			;;
		*)
			echo "Unknown parameter $1" >&2
			exit 1
			;;
	esac
	shift
done
INFILE="$1"
shift

echo "Repacking source to remove non-free files..."

mkdir "pyfiglet-$VER+dfsg.orig"
tar -x --exclude=pyfiglet/fonts --exclude=figfont.txt --exclude=.gitignore \
    --strip-component=1 -C "pyfiglet-$VER+dfsg.orig" -f "$INFILE"
GZIP=--best tar -cz --owner root --group root --mode a+rX \
    -f "pyfiglet_$VER+dfsg.orig.tar.gz" "pyfiglet-$VER+dfsg.orig"
rm -f "$INFILE"
rm -rf "pyfiglet-$VER+dfsg.orig"
