#!/usr/bin/env python

# check version
import sys
if sys.version < '2.3':
    sys.stderr.write('This module requires Python 2.3 or later.\n')
    sys.exit(1)

# import statements
import os, fnmatch, shutil
from distutils.core import setup, Extension
from distutils.util import get_platform
from distutils.file_util import copy_file
from distutils.command.install_lib import install_lib as _install_lib
from distutils.dir_util import mkpath

# debug
DISTUTILS_DEBUG = True


# subclass install_lib to override install()
class install_lib(_install_lib):
    """
    subclass install_lib to override it.
    """

    def __remove(self, item):
        """
        removes item
        """
        path = os.path.join(os.path.dirname(self.install_dir), item)
        if os.path.isfile(path):
            try:
                os.remove(path)
                print 'file %s removed' % path
            except OSError, err:
                print 'could not remove file: %s, %s' % (path, err)
        elif os.path.isdir(path):
            try:
                shutil.rmtree(path)
                print 'directory %s removed' % path
            except OSError, err:
                print 'could not remove directory: %s, %s' % (path, err)

    def install(self):
        """
        1- removes previously installed components (sanity)
        2- install components in install_dir/pyinotify/
        """
        # FIXME: dirty dirty
        # remove old pyinotify's files, dirs
        # relative to ../install_dir
        to_remove = ['pyinotify.pth', 'pyinotify', 'pyinotify.pyc',
                     'pyinotify.py', 'pyinotify.pyo', 'inotify.so']
        for trm in to_remove:
            self.__remove(trm)

        # files patterns to copy and install
        patterns = ['*.py', '*.so']
        excludes = ['autopath.py', '__init__.py'] # only full filenames

        if os.path.isdir(self.build_dir):
            if not os.path.isdir(self.install_dir):
                mkpath(self.install_dir)
            tmp = []
            for root, dirs, files in os.walk(self.build_dir):
                for p in patterns:
                    tmp.extend(fnmatch.filter(files, p))
                break
            outfiles = []
            for i in tmp:
                for excl in excludes:
                    if excl == i:
                        break
                else:
                    dst_name, copied = copy_file(os.path.join(root, i),
                                                 self.install_dir)
                    if copied:
                        outfiles.append(dst_name)
        else:
            self.warn("'%s' does not exist -- no Python modules to install" %
                      self.build_dir)
            return
        return outfiles


# get platform
platform = get_platform()

# check linux platform
if platform[:5] != "linux":
    raise Exception, "inotify not available under %s" % platform

# add -fpic if x86_64 arch
if get_platform() in ["linux-x86_64"]:
    os.environ["CFLAGS"] = "-fpic"

# sources for ext module
ext_mod_src = ['src/pyinotify/inotify.c']

# dst for ext module
ext_mod = Extension('_inotify', ext_mod_src)


classif=[
    'Development Status :: 3 - Alpha',
    'Environment :: Console',
    'Intended Audience :: Developers',
    'License :: OSI Approved :: GNU General Public License (GPL)',
    'Natural Language :: English',
    'Operating System :: POSIX :: Linux',
    'Programming Language :: Python',
    'Programming Language :: C',
    'Topic :: Software Development :: Libraries',
    'Topic :: System :: Monitoring'
    ]


setup(
    name='pyinotify',
    version='0.5.2',
    description='wrapper for inotify, utilities',
    author='Sebastien Martini',
    author_email='sebastien.martini@gmail.com',
    license='GPL 2+',
    platforms='Linux',
    classifiers=classif,
    url='http://pyinotify.sourceforge.net',
    download_url='http://sourceforge.net/project/showfiles.php?group_id=154373',
    package_dir = {'': 'src/pyinotify'},
    ext_modules=[ext_mod],
    extra_path='pyinotify',
    py_modules=['pyinotify', 'inotify'],
    cmdclass={'install_lib': install_lib}
    )
