# -*- coding: iso-8859-1 -*-
#
# rec.py - example of ProcessEvent subclassing
# Copyright (C) 2006  Sbastien Martini <sebastien.martini@gmail.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

import os
# please read src/examples/README
try:
    # import local build
    import autopath
    from src.pyinotify.pyinotify import ProcessEvent, EventsCodes
except ImportError:
    # import global (installed) pyinotify
    from pyinotify import ProcessEvent, EventsCodes


#
# /!\ natively supported (auto_add option) in 0.6.0
#

class PRec(ProcessEvent):
    """
    Add watches on every new directory
    """
    def __init__(self, watch_manager):
        # no need to call ProcessEvent.__init__(self)
        self._watch_manager = watch_manager

    def process_IN_CREATE(self, event):
        """
        New directory created => add a new watch on it
        """
        # output general informations
        super(PRec, self).process_default(event)
        # add watch
        if event.is_dir:
            path_ = os.path.join(event.path, event.name)
            self._watch_manager.add_watch(path_,
                                          EventsCodes.ALL_EVENTS,
                                          proc_fun=self)

