from distutils.core import setup
import pykversion

setup(name="pykaraoke",
      version=pykversion.PYKARAOKE_VERSION_STRING,
      description = 'PyKaraoke = CD+G/MPEG/KAR Karaoke Player',
      maintainer = 'Kelvin Lawson',
      maintainer_email = 'kelvin@kibosh.org',
      url = 'http://www.kibosh.org/pykaraoke',
      license = 'LGPL',
      long_description = 'PyKaraoke - CD+G/MPEG/KAR Karaoke Player',
      py_modules=["pykaraoke", "pycdg","pympg","pykar","pykversion"],
      data_files=[('bin', ['install/pykaraoke',
                           'install/pycdg',
                           'install/pykar',
                           'install/pympg']),
                  ('share/pykaraoke/icons',
                       ['icons/audio_16.png',
                        'icons/folder_close_16.png',
                        'icons/folder_open_16.png', 
                        'icons/note.ico']),
                  ('share/pykaraoke/fonts', ['fonts/vera.ttf'])],
      classifiers=['Development Status :: 5 - Production/Stable',
                   'Environment :: X11 Applications',
                   'Environment :: Win32 (MS Windows)',
                   'Intended Audience :: End Users/Desktop',
                   'License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)',
                   'Operating System :: Microsoft :: Windows',
                   'Operating System :: POSIX',
                   'Programming Language :: Python',
                   'Topic :: Multimedia :: Sound/Audio :: Players'])
