from py.builtin import reversed
from py.test import raises

def test_reversed():
    r = reversed("hello")
    assert iter(r) is r
    assert len(r) == 5
    assert r.next() == "o"
    assert r.next() == "l"
    assert r.next() == "l"
    assert r.next() == "e"
    assert len(r) == 1
    assert r.next() == "h"
    assert len(r) == 0
    raises(StopIteration, r.next)
    assert len(r) == 0
    assert list(reversed(list(reversed("hello")))) == ['h','e','l','l','o']
    raises(TypeError, reversed, reversed("hello"))
