from __future__ import generators
import py
from py.__.test import config 

class MyClass:
    def getoptions(self):
        yield config.Option('-v', action="count", dest="verbose", help="verbose")

def xtest_verbose():
    obj = MyClass()
    args = config.parseargs(['-v', 'hello'], obj)
    assert args == ['hello']
    assert hasattr(obj, 'option')
    assert hasattr(obj.option, 'verbose')
    assert obj.option.verbose

def xtest_verbose_default():
    obj = MyClass()
    args = config.parseargs(['hello'], obj)
    assert args, ['hello']
    assert hasattr(obj, 'option')
    assert hasattr(obj.option, 'verbose')
    assert not obj.option.verbose

def test_tmpdir():
    d1 = py.test.ensuretemp('hello') 
    d2 = py.test.ensuretemp('hello') 
    assert d1 == d2
    assert d1.check(dir=1) 

def test_config_options(): 
    o = py.test.ensuretemp('configoptions') 
    o.ensure("conftest.py").write(py.code.Source(""" 
        import py
        Option = py.test.Config.Option
        option = py.test.Config.addoptions("testing group", 
            Option('-g', '--glong', action="store", default=42,
                   type="int", dest="gdest", help="g value."), 
            )
        """))
    old = o.chdir() 
    try: 
        config, args = py.test.Config.parse(['-g', '17'])
        assert config.option.gdest == 17 
    finally: 
        old.chdir() 
    
#def test_config_order():
#    from py.__.test import config
#    o = py.test.ensuretemp('configorder') 
#    o.ensure('conftest.py').write('x=1 ; import py ; py._x = [x]')
#    o.ensure('a/conftest.py').write('x=2 ; import py ; py._x.append(x)')
#    o.ensure('a/b/c/conftest.py').write('x=3 ; import py ; py._x.append(x)')
#    cfg = config.Config()
#    cfg.readconfiguration(o)
#    assert cfg.getfirst('x') == 1
#    assert py._x == [1]
#
#    cfg = config.Config()
#    cfg.readconfiguration(o.join('a/b/c'))
#    assert cfg.getfirst('x') == 1
#    assert py._x == [1,2,3]
#
#def test_getconfigvalue():
#    from py.__.test import config
#    cfg = config.Config()
#    o = py.test.ensuretemp('configtest') 
#    o.ensure('conftest.py').write('x=1')
#    assert cfg.getconfigvalue(o, 'x') == 1
#    py.test.raises(ValueError, "cfg.getconfigvalue(o, 'y')")
