import Plugin1DBase
import numpy
import PyMca.PyMca_Icons as PyMca_Icons
from scipy.interpolate import splrep, splprep, splev

derive = PyMca_Icons.derive
smooth = PyMca_Icons.smooth

class SciPyPlugins(Plugin1DBase.Plugin1DBase):
    def __init__(self, plotWindow, **kw):
        Plugin1DBase.Plugin1DBase.__init__(self, plotWindow, **kw)
        self.methodDict = {'Spline 1000':[self.spline,
                                        "Spline zoomed active curve",
                                        None],
                          'Spline 100':[self.spline,
                                        "Spline zoomed active curve",
                                        None]}
        if 1:
            text  = "Spline-Smooth zoomed active curve\n"
            text += "with a knot each 5 data points" 
            self.methodDict['Smooth  5'] = [self.splineSmooth, text, smooth]
            text  = "Spline-Smooth zoomed active curve\n"
            text += "with a knot each 10 data points" 
            self.methodDict['Smooth 10'] = [self.splineSmooth, text, smooth]

    #Methods to be implemented by the plugin
    def getMethods(self, plottype=None):
        """
        A list with the NAMES  associated to the callable methods
        that are applicable to the specified plot.

        Plot type can be "SCAN", "MCA", None, ...        
        """
        names = self.methodDict.keys()
        names.sort()
        return names

    def getMethodToolTip(self, name):
        """
        Returns the help associated to the particular method name or None.
        """
        return self.methodDict[name][1]

    def getMethodPixmap(self, name):
        """
        Returns the pixmap associated to the particular method name or None.
        """
        return self.methodDict[name][2]

    def applyMethod(self, name):
        """
        The plugin is asked to apply the method associated to name.
        """
        try:
            if name == "Spline 1000":
                self.spline(1000)
            elif name == "Spline 100":
                self.spline(100)
            elif name.upper().startswith("SMOOTH"):
                self.splineSmooth(int(name.split()[-1]))
            else:
                apply(self.methodDict[name][0])
        except:
            import sys
            print sys.exc_info()
        return

    def _getSplineFriendlyActiveCurve(self):
        activeCurve = self.getActiveCurve()
        if activeCurve is None:
            return None
        x, y, legend, info = activeCurve [0:4]
        xmin, xmax =self.getGraphXLimits()
        i1 = numpy.nonzero((x >= xmin) & (x <= xmax))
        x = numpy.take(x, i1)
        y = numpy.take(y, i1)
        #sort
        i1 = x.argsort()
        x = numpy.take(x, i1)
        y = numpy.take(y, i1)

        #remove duplicates
        x=x.ravel()
        i1 = numpy.nonzero((x[1:] > x[:-1]))
        x = numpy.take(x, i1)
        y = numpy.take(y, i1)
        
        x.shape = -1
        y.shape = -1

        return [x, y, legend, info]

    def spline(self, npoints):
        activeCurve = self._getSplineFriendlyActiveCurve()
        if activeCurve is None:
            return None
        x, y, legend, info = activeCurve [0:4]
        tck = splrep(x,y)

        x = numpy.linspace(x[0], x[-1], npoints)
        y = splev( x, tck)
        
        info['ylabel'] = info['ylabel']
        operations = info.get("operations", [])
        operations.append("spline")
        info['operations'] = operations
        legend = legend+" splined"
        self.addCurve(x, y, legend=legend, info=info, replot=True)
        
    def splineSmooth(self, knotdelta):
        activeCurve = self._getSplineFriendlyActiveCurve()
        if activeCurve is None:
            return None
        x, y, legend, info = activeCurve[0:4]
        npoints = x.shape[0]
        tck = splrep(x,y,t=x[knotdelta:npoints:knotdelta])

        #evaluate y at the same points
        y = splev( x, tck)

        info['ylabel'] = info['ylabel']
        operations = info.get("operations", [])
        operations.append("smooth %d" % knotdelta)
        info['operations'] = operations
        legend = legend+" smooth %d"  % knotdelta
        self.addCurve(x, y, legend=legend, info=info, replot=True)



MENU_TEXT = "Splines"
def getPlugin1DInstance(plotWindow, **kw):
    ob = SciPyPlugins(plotWindow)
    return ob

if __name__ == "__main__":
    from PyMca import Plot1D
    x = numpy.arange(100.)
    y = x * x
    plot = Plot1D.Plot1D()
    plot.addCurve(x, y, "dummy")
    plot.addCurve(x+100, -x*x)
    plugin = getPlugin1DInstance(plot)
    for method in plugin.getMethods():
        print method, ":", plugin.getMethodToolTip(method)
    plugin.applyMethod(plugin.getMethods()[0])
    curves = plugin.getAllCurves()
    for curve in curves:
        print curve[2]
    print "LIMITS = ", plugin.getGraphYLimits()
