#!/usr/bin/env python
# initial 20080124 bernhard@intevation.de
# 20080124-2: removed some superflous imports
# This script is Free Software under GNU GPL v>=2.
"""A test applicaton for gpg_get_key() protocol.CMS.

Tested on Debian Sid with  
    python-pyme    0.7.0-3
    libgpgme11     1.1.6-1 
    gpgsm          2.0.8-1
"""

import sys
from pyme import core
from pyme.constants import protocol

def printgetkeyresults(keyfpr):
    """Run gpgme_get_key()."""

    # gpgme_check_version() necessary for initialisation according to 
    # gogme 1.1.6 and this is not done automatically in pyme-0.7.0
    print "gpgme version:", core.check_version(None)
    c = core.Context()
    c.set_protocol(protocol.CMS)

    key = c.get_key(keyfpr, False)

    print "got key: ", key.subkeys.fpr
    uid = key.uids
    while (uid):
        print uid.uid
        uid = uid.next

def main():
    if len(sys.argv) < 2:
        print "fingerprint or unique key ID for gpgme_get_key()"
        sys.exit(1)

    printgetkeyresults(sys.argv[1])


if __name__ == "__main__":
    main()
