/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.BytesInputStream;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.ModbusUtil;

public class ModbusTCPTransport
implements ModbusTransport {
    private DataInputStream m_Input;
    private DataOutputStream m_Output;
    private BytesInputStream m_ByteIn;

    public ModbusTCPTransport(Socket socket) {
        try {
            this.setSocket(socket);
        }
        catch (IOException ex) {
            if (Modbus.debug) {
                System.out.println("ModbusTCPTransport::Socket invalid.");
            }
            throw new IllegalStateException("Socket invalid.");
        }
    }

    public void setSocket(Socket socket) throws IOException {
        this.prepareStreams(socket);
    }

    public void close() throws IOException {
        this.m_Input.close();
        this.m_Output.close();
    }

    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            msg.writeTo(this.m_Output);
            this.m_Output.flush();
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to write.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModbusRequest readRequest() throws ModbusIOException {
        try {
            ModbusRequest req = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                byte[] buffer = this.m_ByteIn.getBuffer();
                if (this.m_Input.read(buffer, 0, 6) == -1) {
                    throw new EOFException("Premature end of stream (Header truncated).");
                }
                short bf = ModbusUtil.registerToShort(buffer, 4);
                if (this.m_Input.read(buffer, 6, bf) == -1) {
                    throw new ModbusIOException("Premature end of stream (Message truncated).");
                }
                this.m_ByteIn.reset(buffer, 6 + bf);
                this.m_ByteIn.skip(7);
                int functionCode = this.m_ByteIn.readUnsignedByte();
                this.m_ByteIn.reset();
                req = ModbusRequest.createModbusRequest(functionCode);
                req.readFrom(this.m_ByteIn);
            }
            return req;
        }
        catch (EOFException eoex) {
            throw new ModbusIOException(true);
        }
        catch (SocketException sockex) {
            throw new ModbusIOException(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModbusResponse readResponse() throws ModbusIOException {
        try {
            ModbusResponse res = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                byte[] buffer = this.m_ByteIn.getBuffer();
                if (this.m_Input.read(buffer, 0, 6) == -1) {
                    throw new ModbusIOException("Premature end of stream (Header truncated).");
                }
                short bf = ModbusUtil.registerToShort(buffer, 4);
                if (this.m_Input.read(buffer, 6, bf) == -1) {
                    throw new ModbusIOException("Premature end of stream (Message truncated).");
                }
                this.m_ByteIn.reset(buffer, 6 + bf);
                this.m_ByteIn.skip(7);
                int functionCode = this.m_ByteIn.readUnsignedByte();
                this.m_ByteIn.reset();
                res = ModbusResponse.createModbusResponse(functionCode);
                res.readFrom(this.m_ByteIn);
            }
            return res;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    private void prepareStreams(Socket socket) throws IOException {
        this.m_Input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.m_Output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.m_ByteIn = new BytesInputStream(256);
    }
}

