/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.WriteMultipleCoilsResponse;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.util.BitVector;

public final class WriteMultipleCoilsRequest
extends ModbusRequest {
    private int m_Reference;
    private BitVector m_Coils;

    public WriteMultipleCoilsRequest() {
        this.setFunctionCode(15);
        this.setDataLength(5);
    }

    public WriteMultipleCoilsRequest(int ref, int count) {
        this.setFunctionCode(15);
        this.setReference(ref);
        this.m_Coils = new BitVector(count);
        this.setDataLength(this.m_Coils.byteSize() + 5);
    }

    public WriteMultipleCoilsRequest(int ref, BitVector bv) {
        this.setFunctionCode(15);
        this.setReference(ref);
        this.m_Coils = bv;
        this.setDataLength(this.m_Coils.byteSize() + 5);
    }

    public ModbusResponse createResponse() {
        WriteMultipleCoilsResponse response = null;
        DigitalOut[] douts = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            douts = procimg.getDigitalOutRange(this.m_Reference, this.m_Coils.size());
            for (int i = 0; i < douts.length; ++i) {
                douts[i].set(this.m_Coils.getBit(i));
            }
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = new WriteMultipleCoilsResponse(this.m_Reference, this.m_Coils.size());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public int getBitCount() {
        if (this.m_Coils == null) {
            return 0;
        }
        return this.m_Coils.size();
    }

    public int getByteCount() {
        return this.m_Coils.byteSize();
    }

    public boolean getCoilStatus(int index) throws IndexOutOfBoundsException {
        return this.m_Coils.getBit(index);
    }

    public void setCoilStatus(int index, boolean b) throws IndexOutOfBoundsException {
        this.m_Coils.setBit(index, b);
    }

    public BitVector getCoils() {
        return this.m_Coils;
    }

    public void setCoils(BitVector bv) {
        this.m_Coils = bv;
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.m_Coils.size());
        dout.writeByte(this.m_Coils.byteSize());
        dout.write(this.m_Coils.getBytes());
    }

    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        int bitcount = din.readUnsignedShort();
        int count = din.readUnsignedByte();
        byte[] data = new byte[count];
        for (int k = 0; k < count; ++k) {
            data[k] = din.readByte();
        }
        this.m_Coils = BitVector.createBitVector(data, bitcount);
        this.setDataLength(count + 5);
    }
}

