/*
 * Setting info table and indices
 *
 * WARNING: do not delete or change indices since they are used in session objects
 *
 * Include this file exactly twice:
 * 1) in Setting.h to define the enum with all cSetting_<name> indices
 * 2) in Setting.cpp with SETTINGINFO_IMPLEMENTATION defined, to have
 *    `SettingInfo` statically defined there
 *
 */
#ifdef SETTINGINFO_IMPLEMENTATION
// for Setting.cpp

#define REC__(idx, name)             {#name, cSetting_blank,   cSettingLevel_unused}
#define REC_b(idx, name, level, val) {#name, cSetting_boolean, cSettingLevel_ ## level, SettingInfoItem(val, 0, 1)}
#define REC_i(idx, name, level, ...) {#name, cSetting_int,     cSettingLevel_ ## level, SettingInfoItem(__VA_ARGS__)}
#define REC_f(idx, name, level, ...) {#name, cSetting_float,   cSettingLevel_ ## level, SettingInfoItem(__VA_ARGS__)}
#define REC_3(idx, name, level, ...) {#name, cSetting_float3,  cSettingLevel_ ## level, SettingInfoItem(__VA_ARGS__)}
#define REC_s(idx, name, level, val) {#name, cSetting_string,  cSettingLevel_ ## level, val}
#define REC_c(idx, name, level, val) {#name, cSetting_color,   cSettingLevel_ ## level, val}

union SettingInfoItem {
  int i[3];
  float f[3];
  const char * s;

  // constructors
  SettingInfoItem(int i0=0, int i1=0, int i2=0) {
    i[0] = i0;
    i[1] = i1;
    i[2] = i2;
  }
  SettingInfoItem(float f0, float f1=0.f, float f2=0.f) {
    f[0] = f0;
    f[1] = f1;
    f[2] = f2;
  }
  SettingInfoItem(const char *sval) {
    s = sval;
  }
};

const static struct {
  const char * name;
  unsigned char type;
  unsigned char level;

  // default value
  // for type int and float, can also hold allowd min/max values
  SettingInfoItem value;

  // only call this for int or float type
  bool hasMinMax() const {
    return value.i[1] != value.i[2];
  };

} SettingInfo[] = {

#else
// for Setting.h

#define REC__(idx, name)      cSetting_ ## name ## _unused_ ## idx
#define REC_b(idx, name, ...) cSetting_ ## name = idx
#define REC_i(idx, name, ...) cSetting_ ## name = idx
#define REC_f(idx, name, ...) cSetting_ ## name = idx
#define REC_3(idx, name, ...) cSetting_ ## name = idx
#define REC_s(idx, name, ...) cSetting_ ## name = idx
#define REC_c(idx, name, ...) cSetting_ ## name = idx

// legacy names
#define cSetting_ortho                  cSetting_orthoscopic
#define cSetting_pqr_workarounds        cSetting_pqr_no_chain_id
#define cSetting_ray_shadows            cSetting_ray_shadow

// for min/max
#define MAX_SPHERE_QUALITY 4 /* NUMBER_OF_SPHERE_LEVELS-1 */

enum {
#endif

  REC_f(   0, bonding_vdw_cutoff                      , unused    , 0.2F ),
  REC_f(   1, min_mesh_spacing                        , ostate    , 0.6F ),
  REC_i(   2, dot_density                             , ostate    , 2 ),
  REC_i(   3, dot_mode                                , global    , 0 ),
  REC_f(   4, solvent_radius                          , ostate    , 1.4F ),
  REC_i(   5, sel_counter                             , global    , 0 ),
  REC_c(   6, bg_rgb                                  , global    , "0x000000" ),
  REC_f(   7, ambient                                 , global    , 0.14F ),
  REC_f(   8, direct                                  , global    , 0.45F ),
  REC_f(   9, reflect                                 , global    , 0.45F ),
  REC_3(  10, light                                   , global    , -0.4F, -0.4F, -1.0F ),
  REC_f(  11, power                                   , global    , 1.0F ),
  REC_i(  12, antialias                               , global    , 1 ),
  REC_i(  13, cavity_cull                             , ostate    , 10 ),
  REC_f(  14, gl_ambient                              , unused    , 0.12F ),
  REC_b(  15, single_image                            , global    , 0 ),
  REC_f(  16, movie_delay                             , global    , 30.0F ),
  REC_f(  17, ribbon_power                            , ostate    , 2.0F ),
  REC_f(  18, ribbon_power_b                          , ostate    , 0.5F ),
  REC_i(  19, ribbon_sampling                         , ostate    , 1 ),
  REC_f(  20, ribbon_radius                           , ostate    , 0.0F ),
  REC_f(  21, stick_radius                            , bond      , 0.25F ),
  REC_i(  22, hash_max                                , global    , 100 ),
  REC_b(  23, orthoscopic                             , global    , 0 ),
  REC_f(  24, spec_reflect                            , global    , -1.0F ),
  REC_f(  25, spec_power                              , global    , -1.0F ),
  REC_f(  26, sweep_angle                             , global    , 20.0F ),
  REC_f(  27, sweep_speed                             , global    , 0.75F ),
  REC_b(  28, dot_hydrogens                           , ostate    , 1 ),
  REC_f(  29, dot_radius                              , ostate    , 0.0F ),
  REC_b(  30, ray_trace_frames                        , global    , 0 ),
  REC_b(  31, cache_frames                            , global    , 0 ),
  REC_b(  32, trim_dots                               , ostate    , 1 ),
  REC_i(  33, cull_spheres                            , ostate    , 0 ),
  REC_f(  34, test1                                   , global    , 3.0F ),
  REC_f(  35, test2                                   , global    , -0.5F ),
  REC_f(  36, surface_best                            , ostate    , 0.25F ),
  REC_f(  37, surface_normal                          , ostate    , 0.5F ),
  REC_i(  38, surface_quality                         , ostate    , 0 ),
  REC_b(  39, surface_proximity                       , ostate    , 1 ),
  REC_b(  40, normal_workaround                       , global    , 0 ),
  REC_f(  41, stereo_angle                            , global    , 2.1F ),
  REC_f(  42, stereo_shift                            , global    , 2.0F ),
  REC_b(  43, line_smooth                             , global    , 1 ),
  REC_f(  44, line_width                              , bond      , 1.49F ),    /* under 1.5F to retain SGI antialiasing */
  REC_b(  45, half_bonds                              , ostate    , 0 ),
  REC_i(  46, stick_quality                           , ostate    , 8, 3, 100 ), /* no actual max */
  REC_f(  47, stick_overlap                           , ostate    , 0.2F ),
  REC_f(  48, stick_nub                               , ostate    , 0.7F ),
  REC_b(  49, all_states                              , object    , 0 ),
  REC_b(  50, pickable                                , ostate    , 1 ),
  REC_b(  51, auto_show_lines                         , global    , 1 ),
  REC_f(  52, idle_delay                              , global    , 1.5F ),
  REC_f(  53, no_idle                                 , global    , 2000.0F ),  /* 1/500th of a sec. */
  REC_f(  54, fast_idle                               , global    , 10000.0F ), /* 1/100th of a sec. */
  REC_f(  55, slow_idle                               , global    , 40000.0F ), /* 1/25th of a sec. */
  REC_f(  56, rock_delay                              , global    , 30.0F ),
  REC_i(  57, dist_counter                            , global    , 0 ),
  REC_f(  58, dash_length                             , ostate    , 0.15F ),
  REC_f(  59, dash_gap                                , ostate    , 0.45F ),
  REC_i(  60, auto_zoom                               , global    , -1 ),
  REC_i(  61, overlay                                 , global    , 0 ),
  REC_b(  62, text                                    , global    , 0 ),
  REC_i(  63, button_mode                             , global    , 0 ),
  REC_b(  64, valence                                 , bond      , 0 ),
  REC_f(  65, nonbonded_size                          , ostate    , 0.25F ),
  REC_c(  66, label_color                             , atom      , "-6" ),
  REC_f(  67, ray_trace_fog                           , global    , -1.0F ),
  REC_f(  68, spheroid_scale                          , ostate    , 1.0F ),
  REC_f(  69, ray_trace_fog_start                     , global    , -1.0F ),
  REC_f(  70, spheroid_smooth                         , global    , 1.1F ),
  REC_f(  71, spheroid_fill                           , global    , 1.30F ),
  REC_b(  72, auto_show_nonbonded                     , global    , 1 ),
  REC_b(  73, cache_display                           , global    , 1 ),
  REC_f(  74, mesh_radius                             , ostate    , 0.000F ),
  REC_b(  75, backface_cull                           , global    , 0 ),
  REC_f(  76, gamma                                   , global    , 1.0F ),
  REC_f(  77, dot_width                               , ostate    , 2.0F ),
  REC_b(  78, auto_show_selections                    , global    , 1 ),
  REC_b(  79, auto_hide_selections                    , global    , 1 ),
  REC_f(  80, selection_width                         , global    , 3.0F ),
  REC_f(  81, selection_overlay                       , global    , 1.0F ),
  REC_b(  82, static_singletons                       , object    , 1 ),
  REC__(  83,  ),
  REC_b(  84, depth_cue                               , global    , 1 ),
  REC_f(  85, specular                                , global    , 1.0F ),
  REC_f(  86, shininess                               , global    , 55.0F ),
  REC_i(  87, sphere_quality                          , ostate    , 1, 0, MAX_SPHERE_QUALITY ),
  REC_f(  88, fog                                     , global    , 1.0F ),
  REC_b(  89, isomesh_auto_state                      , global    , 0 ),
  REC_f(  90, mesh_width                              , ostate    , 1.0F ),
  REC_i(  91, cartoon_sampling                        , ostate    , -1 ),
  REC_f(  92, cartoon_loop_radius                     , ostate    , 0.2F ),
  REC_f(  93, cartoon_loop_quality                    , ostate    , -1.F ),
  REC_f(  94, cartoon_power                           , ostate    , 2.0F ),
  REC_f(  95, cartoon_power_b                         , ostate    , 0.52F ),
  REC_f(  96, cartoon_rect_length                     , ostate    , 1.40F ),
  REC_f(  97, cartoon_rect_width                      , ostate    , 0.4F ),
  REC_i(  98, internal_gui_width                      , global    , cOrthoRightSceneMargin ),
  REC_b(  99, internal_gui                            , object    , 1 ),
  REC_f( 100, cartoon_oval_length                     , ostate    , 1.35F ),
  REC_f( 101, cartoon_oval_width                      , ostate    , 0.25F ),
  REC_f( 102, cartoon_oval_quality                    , ostate    , -1.F ),
  REC_f( 103, cartoon_tube_radius                     , ostate    , 0.5F ),
  REC_f( 104, cartoon_tube_quality                    , ostate    , -1.F ),
  REC_i( 105, cartoon_debug                           , ostate    , 0 ),
  REC_f( 106, ribbon_width                            , ostate    , 3.0F ),
  REC_f( 107, dash_width                              , ostate    , 2.5F ),
  REC_f( 108, dash_radius                             , ostate    , 0.00F ),
  REC_f( 109, cgo_ray_width_scale                     , ostate    , -0.15F ),
  REC_f( 110, line_radius                             , ostate    , 0.0F ),
  REC_b( 111, cartoon_round_helices                   , ostate    , 1 ),
  REC_i( 112, cartoon_refine_normals                  , ostate    , -1 ),
  REC_b( 113, cartoon_flat_sheets                     , ostate    , 1 ),
  REC_b( 114, cartoon_smooth_loops                    , ostate    , 0 ),
  REC_f( 115, cartoon_dumbbell_length                 , ostate    , 1.60F ),
  REC_f( 116, cartoon_dumbbell_width                  , ostate    , 0.17F ),
  REC_f( 117, cartoon_dumbbell_radius                 , ostate    , 0.16F ),
  REC_b( 118, cartoon_fancy_helices                   , ostate    , 0 ),
  REC_b( 119, cartoon_fancy_sheets                    , ostate    , 1 ),
  REC_b( 120, ignore_pdb_segi                         , global    , 0 ),
  REC_f( 121, ribbon_throw                            , ostate    , 1.35F ),
  REC_f( 122, cartoon_throw                           , ostate    , 1.35F ),
  REC_i( 123, cartoon_refine                          , ostate    , 5 ),
  REC_i( 124, cartoon_refine_tips                     , ostate    , 10 ),
  REC_b( 125, cartoon_discrete_colors                 , ostate    , 0 ),
  REC_i( 126, normalize_ccp4_maps                     , global    , 1 ),
  REC_f( 127, surface_poor                            , ostate    , 0.85F ),
  REC_i( 128, internal_feedback                       , global    , 1 ),
  REC_f( 129, cgo_line_width                          , ostate    , 1.00F ),
  REC_f( 130, cgo_line_radius                         , ostate    , -0.05F ),
  /* 0 = off, 1 = regular (PML), 2 = python (PYM) */
  REC_i( 131, logging                                 , global    , 0, 0, 2 ),
  REC_b( 132, robust_logs                             , global    , 0 ),
  REC_b( 133, log_box_selections                      , global    , 1 ),
  REC_b( 134, log_conformations                       , global    , 1 ),
  REC_f( 135, valence_size                            , ostate    , 0.060F ),
  REC_f( 136, surface_miserable                       , ostate    , 2.0F ),
  REC_i( 137, ray_opaque_background                   , global    , -1 ),
  REC_f( 138, transparency                            , atom      , 0.0F ),
  REC_i( 139, ray_texture                             , ostate    , 0 ),
  REC_3( 140, ray_texture_settings                    , ostate    , 0.1F, 5.0F, 1.0F ),
  REC_b( 141, suspend_updates                         , global    , 0 ),
  REC_b( 142, full_screen                             , unused    , 0 ),
  REC_i( 143, surface_mode                            , ostate    , 0 ),        /* by flag is the default */
  REC_c( 144, surface_color                           , atom      , "-1" ),
  REC_i( 145, mesh_mode                               , ostate    , 0 ),        /* by flag is the default */
  REC_c( 146, mesh_color                              , atom      , "-1" ),
  REC_b( 147, auto_indicate_flags                     , global    , 0 ),
  REC_i( 148, surface_debug                           , global    , 0 ),
  REC_f( 149, ray_improve_shadows                     , global    , 0.1F ),
  REC_b( 150, smooth_color_triangle                   , global    , 0 ),
  REC_i( 151, ray_default_renderer                    , global    , 0 ),
  REC_f( 152, field_of_view                           , global    , 20.0F ),
  REC_f( 153, reflect_power                           , global    , 1.0F ),
  REC_b( 154, preserve_chempy_ids                     , global    , 0 ),
  REC_f( 155, sphere_scale                            , atom      , 1.0F ),
  REC_i( 156, two_sided_lighting                      , ostate    , -1 ),
  REC_f( 157, secondary_structure                     , global    , 2.0F ),
  REC_b( 158, auto_remove_hydrogens                   , global    , 0 ),
  REC_b( 159, raise_exceptions                        , global    , 1 ),
  REC_b( 160, stop_on_exceptions                      , global    , 0 ),
  REC_b( 161, sculpting                               , ostate    , 0 ),
  REC_b( 162, auto_sculpt                             , global    , 0 ),
  REC_f( 163, sculpt_vdw_scale                        , ostate    , 0.97F ),
  REC_f( 164, sculpt_vdw_scale14                      , ostate    , 0.90F ),
  REC_f( 165, sculpt_vdw_weight                       , ostate    , 1.0F ),
  REC_f( 166, sculpt_vdw_weight14                     , ostate    , 0.2F ),
  REC_f( 167, sculpt_bond_weight                      , ostate    , 2.25F ),
  REC_f( 168, sculpt_angl_weight                      , ostate    , 1.0F ),
  REC_f( 169, sculpt_pyra_weight                      , ostate    , 1.0F ),
  REC_f( 170, sculpt_plan_weight                      , ostate    , 1.0F ),
  REC_i( 171, sculpting_cycles                        , object    , 10 ),
  REC_f( 172, sphere_transparency                     , atom      , 0.0F ),
  REC_c( 173, sphere_color                            , atom      , "-1" ),
  REC_i( 174, sculpt_field_mask                       , ostate    , 0x1FF ),
  REC_f( 175, sculpt_hb_overlap                       , ostate    , 1.0F ),
  REC_f( 176, sculpt_hb_overlap_base                  , ostate    , 0.35F ),
  REC_b( 177, legacy_vdw_radii                        , unused    , 0 ),
  REC_b( 178, sculpt_memory                           , ostate    , 1 ),
  REC_i( 179, connect_mode                            , global    , 0 ),
  REC_b( 180, cartoon_cylindrical_helices             , ostate    , 0 ),
  REC_f( 181, cartoon_helix_radius                    , ostate    , 2.25F ),
  REC_f( 182, connect_cutoff                          , global    , 0.35F ),
  REC_b( 183, save_pdb_ss                             , unused    , 0 ),
  REC_f( 184, sculpt_line_weight                      , ostate    , 1.0F ),
  REC_i( 185, fit_iterations                          , global    , 1000 ),
  REC_f( 186, fit_tolerance                           , global    , 0.0000001F ),
  REC_s( 187, batch_prefix                            , global    , "tmp_pymol" ),
  REC_i( 188, stereo_mode                             , global    , 2, 1, 12 ),        /* crosseye by default */
  REC_i( 189, cgo_sphere_quality                      , global    , 1, 0, MAX_SPHERE_QUALITY ),
  REC_b( 190, pdb_literal_names                       , global    , 0 ),
  REC_b( 191, wrap_output                             , global    , 0 ),
  REC_f( 192, fog_start                               , global    , 0.45F ),
  REC_i( 193, state                                   , object    , 1 ),
  REC_i( 194, frame                                   , global    , 1 ),
  REC_b( 195, ray_shadow                              , global    , 1 ),
  REC_i( 196, ribbon_trace_atoms                      , atom      , 0 ),
  REC_i( 197, security                                , global    , 1 ),
  REC_f( 198, stick_transparency                      , bond      , 0.0F ),
  REC_b( 199, ray_transparency_shadows                , global    , 1 ),
  REC_i( 200, session_version_check                   , global    , 0 ),
  REC_f( 201, ray_transparency_specular               , global    , 0.6F ),
  REC_b( 202, stereo_double_pump_mono                 , global    , 0 ),
  REC_b( 203, sphere_solvent                          , ostate    , 0 ),
  REC_i( 204, mesh_quality                            , ostate    , 2 ),
  REC_i( 205, mesh_solvent                            , ostate    , 0 ),
  REC_b( 206, dot_solvent                             , ostate    , 0 ),
  REC_f( 207, ray_shadow_fudge                        , global    , 0.001F ),
  REC_f( 208, ray_triangle_fudge                      , global    , 0.0000001F ),
  REC_i( 209, debug_pick                              , global    , 0 ),
  REC_c( 210, dot_color                               , atom      , "-1" ),
  REC_f( 211, mouse_limit                             , global    , 100.0F ),
  REC_f( 212, mouse_scale                             , global    , 1.3F ),
  REC_i( 213, transparency_mode                       , ostate    , 2 ),
  REC_b( 214, clamp_colors                            , global    , 1 ),
  REC_f( 215, pymol_space_max_red                     , global    , 0.90F ),
  REC_f( 216, pymol_space_max_green                   , global    , 0.75F ),
  REC_f( 217, pymol_space_max_blue                    , global    , 0.90F ),
  REC_f( 218, pymol_space_min_factor                  , global    , 0.15F ),
  REC_b( 219, roving_origin                           , global    , 1 ),
  REC_f( 220, roving_lines                            , global    , 10.0F ),
  REC_f( 221, roving_sticks                           , global    , 6.0F ),
  REC_f( 222, roving_spheres                          , global    , 0.0F ),
  REC_f( 223, roving_labels                           , global    , 0.0F ),
  REC_f( 224, roving_delay                            , global    , 0.2F ),
  REC_s( 225, roving_selection                        , global    , "all" ),
  REC_b( 226, roving_byres                            , global    , 1 ),
  REC_f( 227, roving_ribbon                           , global    , -7.0F ),
  REC_f( 228, roving_cartoon                          , global    , 0.0F ),
  REC_f( 229, roving_polar_contacts                   , global    , 7.0F ),
  REC_f( 230, roving_polar_cutoff                     , global    , 3.31F ),
  REC_f( 231, roving_nonbonded                        , global    , 0.0F ),
  REC_i( 232, float_labels                            , ostate    , 0 ),
  REC_b( 233, roving_detail                           , global    , 0 ),
  REC_f( 234, roving_nb_spheres                       , global    , 8.0F ),
  REC_c( 235, ribbon_color                            , atom      , "-1" ),
  REC_c( 236, cartoon_color                           , atom      , "-1" ),
  REC_i( 237, ribbon_smooth                           , object    , 0 ),
  REC_b( 238, auto_color                              , global    , 1 ),
  REC_i( 239, auto_color_next                         , global    , 0 ),
  REC_c( 240, ray_interior_color                      , ostate    , "-1" ),
  REC_c( 241, cartoon_highlight_color                 , ostate    , "-1" ),
  REC_f( 242, coulomb_units_factor                    , global    , 557.00000F ),
  REC_f( 243, coulomb_dielectric                      , global    , 2.0F ),
  REC_b( 244, ray_interior_shadows                    , global    , 0 ),
  REC_i( 245, ray_interior_texture                    , global    , -1 ),
  REC_s( 246, roving_map1_name                        , global    , "" ),
  REC_s( 247, roving_map2_name                        , global    , "" ),
  REC_s( 248, roving_map3_name                        , global    , "" ),
  REC_f( 249, roving_map1_level                       , global    , 1.0F ),
  REC_f( 250, roving_map2_level                       , global    , 2.0F ),
  REC_f( 251, roving_map3_level                       , global    , 3.0F ),
  REC_f( 252, roving_isomesh                          , global    , 8.0F ),
  REC_f( 253, roving_isosurface                       , global    , 0.0F ),
  REC_b( 254, scenes_changed                          , global    , 1 ),
  REC_f( 255, gaussian_b_adjust                       , global    , 0.0F ),
  REC_b( 256, pdb_standard_order                      , global    , 1 ),
  REC_i( 257, cartoon_smooth_first                    , ostate    , 1 ),
  REC_i( 258, cartoon_smooth_last                     , ostate    , 1 ),
  REC_i( 259, cartoon_smooth_cycles                   , ostate    , 2 ),
  REC_i( 260, cartoon_flat_cycles                     , ostate    , 4 ),
  REC_i( 261, max_threads                             , object    , 1 ),
  REC_i( 262, show_progress                           , global    , 1 ),
  REC_i( 263, use_display_lists                       , unused    , 0 ),
  REC_i( 264, cache_memory                            , global    , 0 ),        /* doesn't seem to do any good :( */
  REC_b( 265, simplify_display_lists                  , unused    , 0 ),
  REC_i( 266, retain_order                            , object    , 0 ),
  REC_i( 267, pdb_hetatm_sort                         , object    , 0 ),
  REC_i( 268, pdb_use_ter_records                     , global    , 1 ),
  REC_i( 269, cartoon_trace_atoms                     , atom      , 0 ),
  REC_i( 270, ray_oversample_cutoff                   , global    , 120 ),
  /* note that this setting is ad-hoc and calibrated such that a
     gaussian_resolution of 2.0 returns maps with the straight atomic
     scattering factors (unblurred).  At resolution of 4.0, they are
     blurred 2X, 8.0:4X, and so forth....  */
  REC_f( 271, gaussian_resolution                     , global    , 2.0F ),
  REC_f( 272, gaussian_b_floor                        , global    , 0.0F ),
  REC_i( 273, sculpt_nb_interval                      , ostate    , 17 ),
  REC_f( 274, sculpt_tors_weight                      , ostate    , 0.05F ),
  REC_f( 275, sculpt_tors_tolerance                   , ostate    , 0.05F ),
  REC_b( 276, stick_ball                              , ostate    , false ),
  REC_f( 277, stick_ball_ratio                        , ostate    , 1.0F ),
  REC_b( 278, stick_fixed_radius                      , ostate    , false ),
  REC_f( 279, cartoon_transparency                    , ostate    , 0.0F ),
  REC_b( 280, dash_round_ends                         , ostate    , 1 ),
  REC_f( 281, h_bond_max_angle                        , global    , 63.0F ),
  REC_f( 282, h_bond_cutoff_center                    , global    , 3.6F ),
  REC_f( 283, h_bond_cutoff_edge                      , global    , 3.2F ),
  REC_f( 284, h_bond_power_a                          , global    , 1.6F ),
  REC_f( 285, h_bond_power_b                          , global    , 5.0F ),
  REC_f( 286, h_bond_cone                             , global    , 180.0F ),
  REC_f( 287, ss_helix_psi_target                     , global    , -48.0F ),
  REC_f( 288, ss_helix_psi_include                    , global    , 55.0F ),
  REC_f( 289, ss_helix_psi_exclude                    , global    , 85.0F ),
  REC_f( 290, ss_helix_phi_target                     , global    , -57.0F ),
  REC_f( 291, ss_helix_phi_include                    , global    , 55.0F ),
  REC_f( 292, ss_helix_phi_exclude                    , global    , 85.0F ),
  REC_f( 293, ss_strand_psi_target                    , global    , 124.0F ),
  REC_f( 294, ss_strand_psi_include                   , global    , 40.0F ),
  REC_f( 295, ss_strand_psi_exclude                   , global    , 90.0F ),
  REC_f( 296, ss_strand_phi_target                    , global    , -129.0F ),
  REC_f( 297, ss_strand_phi_include                   , global    , 40.0F ),
  REC_f( 298, ss_strand_phi_exclude                   , global    , 100.0F ),
  REC_b( 299, movie_loop                              , object    , 1 ),
  REC_b( 300, pdb_retain_ids                          , global    , 0 ),
  REC_b( 301, pdb_no_end_record                       , global    , 0 ),
  REC_f( 302, cgo_dot_width                           , ostate    , 2.0F ),
  REC_f( 303, cgo_dot_radius                          , ostate    , -1.0F ),
  REC_b( 304, defer_updates                           , global    , 0 ),
  REC_b( 305, normalize_o_maps                        , global    , 1 ),
  REC_b( 306, swap_dsn6_bytes                         , global    , 1 ),
  REC_b( 307, pdb_insertions_go_first                 , global    , 0 ),
  REC_b( 308, roving_origin_z                         , global    , 1 ),
  REC_f( 309, roving_origin_z_cushion                 , global    , 3.0F ),
  REC_f( 310, specular_intensity                      , global    , 0.5F ),
  REC_i( 311, overlay_lines                           , global    , 5 ),
  REC_f( 312, ray_transparency_spec_cut               , global    , 0.9F ),
  REC_b( 313, internal_prompt                         , global    , 1 ),
  REC_b( 314, normalize_grd_maps                      , global    , 0 ),
  REC_b( 315, ray_blend_colors                        , global    , 0 ),
  REC_f( 316, ray_blend_red                           , global    , 0.17F ),
  REC_f( 317, ray_blend_green                         , global    , 0.25F ),
  REC_f( 318, ray_blend_blue                          , global    , 0.14F ),
  REC_f( 319, png_screen_gamma                        , global    , 2.4F ),
  REC_f( 320, png_file_gamma                          , global    , 1.0F ),
  REC_b( 321, editor_label_fragments                  , global    , 0 ),
  REC_i( 322, internal_gui_control_size               , global    , 18 ),
  REC_b( 323, auto_dss                                , global    , 1 ),
  REC_i( 324, transparency_picking_mode               , ostate    , 2 ),        /* auto */
  REC_i( 325, virtual_trackball                       , global    , 1 ),
  /* 0/4 = no reformatting, 
     1   = pdb compliant,
     2   = amber compliant,
     3   = pdb I/O, but iupac inside
     */
  REC_i( 326, pdb_reformat_names_mode                 , global    , 0, 0, 4 ),
  REC_f( 327, ray_pixel_scale                         , global    , 1.30F ),
  REC_i( 328, label_font_id                           , ostate    , 5 ),
  REC_b( 329, pdb_conect_all                          , global    , 0 ),
  REC_s( 330, button_mode_name                        , global    , "" ),
  REC_i( 331, surface_type                            , ostate    , 0 ),
  REC_b( 332, dot_normals                             , ostate    , 1 ),
  REC_b( 333, session_migration                       , global    , 1 ),
  REC_b( 334, mesh_normals                            , ostate    , 1 ),
  /* 0 = lines, 1 = points (, 2 = solid, 3 = gradient ) */
  REC_i( 335, mesh_type                               , ostate    , 0, 0, 1 ),
  REC_b( 336, dot_lighting                            , ostate    , 1 ),
  REC_b( 337, mesh_lighting                           , ostate    , 0 ),
  REC_b( 338, surface_solvent                         , ostate    , 0 ),
  REC_i( 339, triangle_max_passes                     , global    , 5 ),
  REC_f( 340, ray_interior_reflect                    , global    , 0.4F ),
  REC_i( 341, internal_gui_mode                       , global    , 0 ),
  REC_s( 342, surface_carve_selection                 , ostate    , "" ),
  REC_i( 343, surface_carve_state                     , ostate    , 0 ),
  REC_f( 344, surface_carve_cutoff                    , ostate    , 0.0F ),
  REC_s( 345, surface_clear_selection                 , ostate    , "" ),
  REC_i( 346, surface_clear_state                     , ostate    , 0 ),
  REC_f( 347, surface_clear_cutoff                    , ostate    , 0.0F ),
  REC_f( 348, surface_trim_cutoff                     , ostate    , 0.2F ),
  REC_f( 349, surface_trim_factor                     , ostate    , 2.0F ),
  REC_i( 350, ray_max_passes                          , global    , 25 ),
  REC_b( 351, active_selections                       , global    , true ),
  REC_f( 352, ray_transparency_contrast               , global    , 1.0F ),
  REC_b( 353, seq_view                                , object    , 0 ),
  REC_i( 354, mouse_selection_mode                    , global    , 1 ),
  REC_i( 355, seq_view_label_spacing                  , object    , 5 ),
  REC_i( 356, seq_view_label_start                    , object    , 1 ),
  REC_i( 357, seq_view_format                         , object    , 0 ),
  REC_i( 358, seq_view_location                       , global    , 0 ),
  REC_b( 359, seq_view_overlay                        , global    , 0 ),
  REC_b( 360, auto_classify_atoms                     , global    , 1 ),
  REC_i( 361, cartoon_nucleic_acid_mode               , ostate    , 4 ),
  REC_c( 362, seq_view_color                          , ostate    , "-1" ),
  REC_i( 363, seq_view_label_mode                     , global    , 2 ),
  REC_i( 364, surface_ramp_above_mode                 , ostate    , 0 ),
  REC_b( 365, stereo                                  , global    , 0 ),
  REC_i( 366, wizard_prompt_mode                      , global    , 1 ),
  REC_f( 367, coulomb_cutoff                          , global    , 10.0F ),
  REC_b( 368, slice_track_camera                      , object    , 0 ),
  REC_f( 369, slice_height_scale                      , object    , 1.0F ),
  REC_b( 370, slice_height_map                        , object    , 0 ),
  REC_f( 371, slice_grid                              , object    , 0.3F ),
  REC_b( 372, slice_dynamic_grid                      , object    , 0 ),
  REC_f( 373, slice_dynamic_grid_resolution           , object    , 3.0F ),
  REC_b( 374, pdb_insure_orthogonal                   , global    , 1 ),
  REC_f( 375, ray_direct_shade                        , global    , 0.0F ),     /* only meaningful with one light source */
  REC_c( 376, stick_color                             , bond      , "-1" ),
  REC_f( 377, cartoon_putty_radius                    , ostate    , 0.40F ),
  REC_f( 378, cartoon_putty_quality                   , ostate    , -1.F ),
  REC_f( 379, cartoon_putty_scale_min                 , ostate    , 0.6F ),
  REC_f( 380, cartoon_putty_scale_max                 , ostate    , 4.0F ),
  REC_f( 381, cartoon_putty_scale_power               , ostate    , 1.5F ),
  REC_f( 382, cartoon_putty_range                     , ostate    , 2.0F ),
  REC_b( 383, cartoon_side_chain_helper               , atom      , 0 ),
  REC_b( 384, surface_optimize_subsets                , ostate    , 1 ),
  REC_i( 385, multiplex                               , global    , -1 ),
  REC_b( 386, texture_fonts                           , unused    , 0 ),
  REC_b( 387, pqr_no_chain_id                         , global    , 1 ),
  REC_b( 388, animation                               , global    , 1 ),
  REC_f( 389, animation_duration                      , global    , 0.75F ),
  REC_i( 390, scene_animation                         , global    , -1 ),
  REC_b( 391, line_stick_helper                       , ostate    , 1 ),
  REC_i( 392, ray_orthoscopic                         , global    , -1 ),
  REC_i( 393, ribbon_side_chain_helper                , atom      , 0 ),
  REC_f( 394, selection_width_max                     , global    , 10.0F ),
  REC_f( 395, selection_width_scale                   , global    , 2.0F ),
  REC_s( 396, scene_current_name                      , global    , "" ),
  REC_b( 397, presentation                            , global    , 0 ),
  REC_i( 398, presentation_mode                       , global    , 1 ),
  REC_b( 399, pdb_truncate_residue_name               , global    , false ),
  REC_b( 400, scene_loop                              , global    , 0 ),
  REC_i( 401, sweep_mode                              , global    , 0 ),
  REC_f( 402, sweep_phase                             , global    , 0.0F ),
  REC_b( 403, scene_restart_movie_delay               , global    , 1 ),
  REC_b( 404, mouse_restart_movie_delay               , global    , 0 ),
  REC_f( 405, angle_size                              , ostate    , 0.6666F ),
  REC_f( 406, angle_label_position                    , ostate    , 0.5F ),
  REC_f( 407, dihedral_size                           , ostate    , 0.6666F ),
  REC_f( 408, dihedral_label_position                 , ostate    , 1.2F ),
  REC_i( 409, defer_builds_mode                       , ostate    , 0 ),
  REC_b( 410, seq_view_discrete_by_state              , object    , 1 ),
  REC_f( 411, scene_animation_duration                , global    , 2.25F ),
  REC_s( 412, wildcard                                , object    , "*" ),
  REC_s( 413, atom_name_wildcard                      , object    , "" ),
  REC_b( 414, ignore_case                             , global    , 1 ), // 0 in 1.8.0.[0-4]
  REC_b( 415, presentation_auto_quit                  , global    , 1 ),
  REC_b( 416, editor_auto_dihedral                    , global    , 1 ),
  REC_b( 417, presentation_auto_start                 , global    , 1 ),
  REC_b( 418, validate_object_names                   , global    , 1 ),
  REC_b( 419, unused_boolean_def_true                 , unused    , 1 ),
  REC_b( 420, auto_show_spheres                       , global    , 0 ),
  REC_i( 421, sphere_mode                             , ostate    , 9, -1, 9 ),
  REC_f( 422, sphere_point_max_size                   , ostate    , 18.0f ),
  REC_f( 423, sphere_point_size                       , global    , 1.0f ),
  REC_b( 424, pdb_honor_model_number                  , global    , false ),
  REC_b( 425, rank_assisted_sorts                     , global    , true ),
  REC_i( 426, ribbon_nucleic_acid_mode                , ostate    , 0 ),
  REC_i( 427, cartoon_ring_mode                       , ostate    , 0 ),
  REC_f( 428, cartoon_ring_width                      , ostate    , 0.125F ),
  REC_c( 429, cartoon_ring_color                      , ostate    , "-1" ),
  REC_i( 430, cartoon_ring_finder                     , ostate    , 1 ),
  REC_i( 431, cartoon_tube_cap                        , ostate    , 2 ),
  REC_i( 432, cartoon_loop_cap                        , ostate    , 1 ),
  REC_i( 433, nvidia_bugs                             , global    , 0 ),
  REC_f( 434, image_dots_per_inch                     , global    , 0.0F ),
  REC_b( 435, opaque_background                       , global    , 1 ),
  REC_b( 436, draw_frames                             , global    , 0 ),
  REC_b( 437, show_alpha_checker                      , global    , 1 ),
  /* -1: automatic behavior based on implied intent
      0: coordinates (pre-1.0 legacy default mode)
      1: per-object matrices (TTTs: version 1.0 default mode?)
      2: per-state matrices (partially implemented)
      3: per-group matrices (may come in the future) */
  REC_i( 438, matrix_mode                             , ostate    , -1, -1, 2 ),
  REC_b( 439, editor_auto_origin                      , global    , 1 ),
  REC_s( 440, session_file                            , global    , "" ),
  REC_f( 441, cgo_transparency                        , ostate    , 0.0F ),
  REC_b( 442, legacy_mouse_zoom                       , global    , 0 ),
  REC_b( 443, auto_number_selections                  , global    , 0 ),
  REC_i( 444, sculpt_vdw_vis_mode                     , ostate    , 0 ),
  REC_f( 445, sculpt_vdw_vis_min                      , ostate    , -0.1F ),
  REC_f( 446, sculpt_vdw_vis_mid                      , ostate    , 0.1F ),
  REC_f( 447, sculpt_vdw_vis_max                      , ostate    , 0.3F ),
  REC_i( 448, cartoon_ladder_mode                     , ostate    , 1 ),
  REC_f( 449, cartoon_ladder_radius                   , ostate    , 0.25F ),
  REC_c( 450, cartoon_ladder_color                    , ostate    , "-1" ),
  REC_c( 451, cartoon_nucleic_acid_color              , ostate    , "-1" ),
  REC_f( 452, cartoon_ring_transparency               , ostate    , -1.0F ),
  REC_f( 453, label_size                              , ostate    , 14.0F ),
  REC_f( 454, spec_direct                             , global    , 0.0F ),
  REC_i( 455, light_count                             , global    , 2, 1, 8 ),  /* 1: ambient, 2-8: directed */
  REC_3( 456, light2                                  , global    , -0.55F, -0.7F, 0.15F ),
  REC_3( 457, light3                                  , global    , 0.3F, -0.6F, -0.2F ),
  REC_b( 458, hide_underscore_names                   , global    , 1 ),
  REC_b( 459, selection_round_points                  , global    , 0 ),
  REC_i( 460, distance_exclusion                      , global    , 5 ),
  REC_i( 461, h_bond_exclusion                        , global    , 3 ),
  REC_i( 462, label_shadow_mode                       , global    , 0 ),
  REC_3( 463, light4                                  , global    , -1.2F, 0.3F, -0.2F ),
  REC_3( 464, light5                                  , global    , 0.3F, 0.6F, -0.75F ),
  REC_3( 465, light6                                  , global    , -0.3F, 0.5F, 0.0F ),
  REC_3( 466, light7                                  , global    , 0.9F, -0.1F, -0.15F ),
  REC_c( 467, label_outline_color                     , ostate    , "-1" ),
  REC_i( 468, ray_trace_mode                          , global    , 0 ),
  REC_f( 469, ray_trace_gain                          , global    , 0.12F ),
  REC_b( 470, selection_visible_only                  , global    , 0 ),
  REC_3( 471, label_position                          , ostate    , 0.0F, 0.0F, 1.75F ),
  REC_f( 472, ray_trace_depth_factor                  , global    , 0.1F ),
  REC_f( 473, ray_trace_slope_factor                  , global    , 0.6F ),
  REC_f( 474, ray_trace_disco_factor                  , global    , 0.05F ),
  REC_f( 475, ray_shadow_decay_factor                 , global    , 0.0F ),
  REC_i( 476, ray_interior_mode                       , global    , 0 ),
  REC_f( 477, ray_legacy_lighting                     , global    , 0.0F ),
  REC_b( 478, sculpt_auto_center                      , global    , 0 ),
  REC_i( 479, pdb_discrete_chains                     , global    , -1 ),
  REC_i( 480, pdb_unbond_cations                      , global    , 1 ),
  REC_f( 481, sculpt_tri_scale                        , ostate    , 1.025F ),   /* allow for some play here... */
  REC_f( 482, sculpt_tri_weight                       , ostate    , 1.0F ),
  REC_i( 483, sculpt_tri_min                          , ostate    , 2 ),
  REC_i( 484, sculpt_tri_max                          , ostate    , 18 ),
  REC_i( 485, sculpt_tri_mode                         , ostate    , 0 ),
  REC_s( 486, pdb_echo_tags                           , global    , "HEADER, TITLE, COMPND" ),
  REC_b( 487, connect_bonded                          , global    , 0 ),
  REC_f( 488, spec_direct_power                       , global    , 55.0F ),
  REC_3( 489, light8                                  , global    , 1.3F, 2.0F, 0.8F ),
  REC_3( 490, light9                                  , global    , -1.7F, -0.5F, 1.2F ),
  REC_f( 491, ray_shadow_decay_range                  , global    , 1.8F ),
  REC_i( 492, spec_count                              , global    , -1 ),
  REC_f( 493, sculpt_min_scale                        , ostate    , 0.975F ),
  REC_f( 494, sculpt_min_weight                       , ostate    , 0.75F ),
  REC_f( 495, sculpt_min_min                          , ostate    , 4.0F ),
  REC_f( 496, sculpt_min_max                          , ostate    , 12.0F ),
  REC_f( 497, sculpt_max_scale                        , ostate    , 1.025F ),
  REC_f( 498, sculpt_max_weight                       , ostate    , 0.75F ),
  REC_f( 499, sculpt_max_min                          , ostate    , 4.0F ),
  REC_f( 500, sculpt_max_max                          , ostate    , 12.0F ),
  REC_i( 501, surface_circumscribe                    , ostate    , -1 ),
  REC_f( 502, sculpt_avd_weight                       , ostate    , 4.0F ),
  REC_f( 503, sculpt_avd_gap                          , ostate    , -1.0F ),
  REC_f( 504, sculpt_avd_range                        , ostate    , -1.0F ),
  REC_i( 505, sculpt_avd_excl                         , ostate    , 7 ),
  REC_b( 506, async_builds                            , object    , 0 ),
  REC_s( 507, fetch_path                              , global    , "." ),
  REC_f( 508, cartoon_ring_radius                     , ostate    , -1.0F ),
  REC_b( 509, ray_color_ramps                         , ostate    , 0 ),
  REC_f( 510, ray_hint_camera                         , global    , 2.15F ),
  REC_f( 511, ray_hint_shadow                         , global    , 0.65F ),
  REC_f( 512, stick_valence_scale                     , ostate    , 1.0F ),
  REC_s( 513, seq_view_alignment                      , global    , "" ),
  REC_i( 514, seq_view_unaligned_mode                 , global    , 0 ),
  REC_c( 515, seq_view_unaligned_color                , global    , "-1" ),
  REC_s( 516, seq_view_fill_char                      , global    , "-" ),
  REC_c( 517, seq_view_fill_color                     , global    , "104" ),    
  REC_c( 518, seq_view_label_color                    , global    , "front" ),
  REC_f( 519, surface_carve_normal_cutoff             , ostate    , -1.0F ),
  REC_i( 520, trace_atoms_mode                        , ostate    , 5 ),
  REC_b( 521, session_changed                         , global    , 0 ),
  REC_b( 522, ray_clip_shadows                        , global    , 0 ),
  REC_f( 523, mouse_wheel_scale                       , global    , 0.5F ),
  REC_f( 524, nonbonded_transparency                  , atom      , 0.0F ),
  REC_b( 525, ray_spec_local                          , global    , 0 ),
  REC_c( 526, line_color                              , bond      , "-1" ),
  REC_f( 527, ray_label_specular                      , global    , 1.0F ),
  REC_i( 528, mesh_skip                               , ostate    , 0 ),
  REC_i( 529, label_digits                            , ostate    , 1 ),
  REC_i( 530, label_distance_digits                   , ostate    , -1 ),
  REC_i( 531, label_angle_digits                      , ostate    , -1 ),
  REC_i( 532, label_dihedral_digits                   , ostate    , -1 ),
  REC_b( 533, surface_negative_visible                , object    , 0 ),
  REC_c( 534, surface_negative_color                  , object    , "red" ),
  REC_b( 535, mesh_negative_visible                   , object    , 0 ),
  REC_c( 536, mesh_negative_color                     , object    , "red" ),
  REC_i( 537, group_auto_mode                         , global    , 1 ),
  REC_i( 538, group_full_member_names                 , global    , 0 ),
  REC_f( 539, gradient_max_length                     , ostate    , 100.0F ),
  REC_f( 540, gradient_min_length                     , ostate    , 2.0F ),
  REC_f( 541, gradient_min_slope                      , ostate    , 0.00001F ),
  REC_f( 542, gradient_normal_min_dot                 , ostate    , 0.70F ),
  REC_f( 543, gradient_step_size                      , ostate    , 0.25F ),
  REC_i( 544, gradient_spacing                        , ostate    , 3 ),
  REC_f( 545, gradient_symmetry                       , ostate    , 0.0F ),
  REC_c( 546, ray_trace_color                         , global    , "-6" ),
  REC_b( 547, group_arrow_prefix                      , global    , 0 ),
  REC_b( 548, suppress_hidden                         , global    , true ),
  REC_b( 549, session_compression                     , global    , 0 ),
  REC_f( 550, movie_fps                               , global    , 30.0f ),
  REC_f( 551, ray_transparency_oblique                , global    , 0.0F ),
  REC_f( 552, ray_trace_trans_cutoff                  , global    , 0.05F ),
  REC_f( 553, ray_trace_persist_cutoff                , global    , 0.10F ),
  REC_f( 554, ray_transparency_oblique_power          , global    , 1.0F ),
  REC_f( 555, ray_scatter                             , global    , 0.0F ),
  REC_b( 556, h_bond_from_proton                      , global    , 1 ),
  REC_b( 557, auto_copy_images                        , global    , 0 ),
  REC_i( 558, moe_separate_chains                     , global    , -1 ),
  REC_b( 559, transparency_global_sort                , global    , 0 ),
  REC_b( 560, hide_long_bonds                         , ostate    , 0 ),
  REC_b( 561, auto_rename_duplicate_objects           , global    , 0 ),
  REC_b( 562, pdb_hetatm_guess_valences               , global    , 1 ),
  REC_i( 563, ellipsoid_quality                       , global    , 1 ),
  REC_i( 564, cgo_ellipsoid_quality                   , global    , -1 ),
  REC_b( 565, movie_animate_by_frame                  , global    , 0 ),
  REC_b( 566, ramp_blend_nearby_colors                , global    , 0 ),
  REC_i( 567, auto_defer_builds                       , global    , 500 ),      /* X or more states, then automatically defer builds */
  REC_f( 568, ellipsoid_probability                   , ostate    , 0.5F ),
  REC_f( 569, ellipsoid_scale                         , atom      , 1.0F ),
  REC_c( 570, ellipsoid_color                         , atom      , "-1" ),
  REC_f( 571, ellipsoid_transparency                  , atom      , 0.0F ),
  REC_i( 572, movie_rock                              , global    , -1 ),
  REC_i( 573, cache_mode                              , ostate    , 0 ),
  REC_c( 574, dash_color                              , ostate    , "-1" ),
  REC_c( 575, angle_color                             , ostate    , "-1" ),
  REC_c( 576, dihedral_color                          , ostate    , "-1" ),
  REC_i( 577, grid_mode                               , global    , 0, 0, 3 ),
  REC_i( 578, cache_max                               , global    , 25000000 ), /* default: ~100 MB cache */
  REC_i( 579, grid_slot                               , object    , -1 ),
  REC_i( 580, grid_max                                , global    , -1 ),
  REC_i( 581, cartoon_putty_transform                 , ostate    , cPuttyTransformNormalizedNonlinear ),
  REC_b( 582, rock                                    , global    , 0 ),
  REC_i( 583, cone_quality                            , global    , 18 ),
  REC_b( 584, pdb_formal_charges                      , global    , 1 ),
  REC_i( 585, ati_bugs                                , global    , 0 ),
  REC_i( 586, geometry_export_mode                    , global    , 0 ),
  REC_b( 587, mouse_grid                              , global    , 1 ),
  REC_f( 588, mesh_cutoff                             , ostate    , 0.0F ),
  REC_s( 589, mesh_carve_selection                    , ostate    , "" ),
  REC_i( 590, mesh_carve_state                        , ostate    , 0 ),
  REC_f( 591, mesh_carve_cutoff                       , ostate    , 0.0F ),
  REC_s( 592, mesh_clear_selection                    , ostate    , "" ),
  REC_i( 593, mesh_clear_state                        , ostate    , 0 ),
  REC_f( 594, mesh_clear_cutoff                       , ostate    , 0.0F ),
  REC_i( 595, mesh_grid_max                           , ostate    , 80 ),
  REC_i( 596, session_cache_optimize                  , global    , 0 ),
  REC_f( 597, sdof_drag_scale                         , global    , 0.5F ),
  REC_i( 598, scene_buttons_mode                      , unused    , 1 ),
  REC_b( 599, scene_buttons                           , global    , 1 ),
  REC_b( 600, map_auto_expand_sym                     , object    , 1 ),
  REC_b( 601, image_copy_always                       , global    , 0 ),
  REC_i( 602, max_ups                                 , global    , 0 ),
  REC_i( 603, auto_overlay                            , global    , 0 ),
  REC_c( 604, stick_ball_color                        , ostate    , "-1" ),
  REC_f( 605, stick_h_scale                           , ostate    , 1.0F ),
  REC_f( 606, sculpt_pyra_inv_weight                  , ostate    , 10.0F ),
  REC_b( 607, keep_alive                              , global    , 0 ),
  REC_i( 608, fit_kabsch                              , global    , 0 ),
  REC_f( 609, stereo_dynamic_strength                 , global    , 0.5F ),
  REC_b( 610, dynamic_width                           , global    , 1 ),
  REC_f( 611, dynamic_width_factor                    , global    , 0.06f ),
  REC_f( 612, dynamic_width_min                       , global    , 0.75f ),
  REC_f( 613, dynamic_width_max                       , global    , 2.5f ),
  REC_i( 614, draw_mode                               , global    , 0 ),
  REC_i( 615, clean_electro_mode                      , global    , 1 ),
  REC_i( 616, valence_mode                            , ostate    , 1 ),
  REC_b( 617, show_frame_rate                         , global    , 0 ),
  REC_i( 618, movie_panel                             , global    , 1 ),
  REC_f( 619, mouse_z_scale                           , global    , 1.0f ),
  REC_b( 620, movie_auto_store                        , object    , -1 ),
  REC_b( 621, movie_auto_interpolate                  , object    , 1 ),
  REC_i( 622, movie_panel_row_height                  , global    , 15 ),
  REC_i( 623, scene_frame_mode                        , global    , -1 ),
  REC_i( 624, surface_cavity_mode                     , ostate    , 0 ),
  REC_f( 625, surface_cavity_radius                   , ostate    , 7.0F ),
  REC_f( 626, surface_cavity_cutoff                   , ostate    , -3.0F ),
  REC_f( 627, motion_power                            , object    , 0.0F ),
  REC_f( 628, motion_bias                             , object    , -1.0F ),
  REC_i( 629, motion_simple                           , object    , 0 ),
  REC_f( 630, motion_linear                           , object    , 0.0F ),
  REC_i( 631, motion_hand                             , object    , 1 ),
  REC_b( 632, pdb_ignore_conect                       , global    , 0 ),
  REC_b( 633, editor_bond_cycle_mode                  , object    , 1 ),        /* >0 -> include aromatic */
  REC_i( 634, movie_quality                           , global    , 90 ),
  REC_s( 635, label_anchor                            , global    , "CA" ),
  REC_s( 636, fetch_host                              , global    , "pdb" ),
  REC_b( 637, dynamic_measures                        , object    , 1 ),
  REC_f( 638, neighbor_cutoff                         , global    , 3.5F ),
  REC_f( 639, heavy_neighbor_cutoff                   , global    , 3.5F ),
  REC_f( 640, polar_neighbor_cutoff                   , global    , 3.5F ),
  REC_f( 641, surface_residue_cutoff                  , global    , 2.5F ),
  REC_b( 642, surface_use_shader                      , global    , 1 ),
  REC_b( 643, cartoon_use_shader                      , global    , 1 ),
  REC_b( 644, stick_use_shader                        , global    , 1 ),
  REC_b( 645, line_use_shader                         , global    , 1 ),
  REC_b( 646, sphere_use_shader                       , global    , 1 ),
  REC_b( 647, use_shaders                             , ostate    , 0 ),
  REC_b( 648, shaders_from_disk                       , global    , 0 ),
  REC_i( 649, volume_bit_depth                        , object    , 16 ),
  REC_c( 650, volume_color                            , unused    , "-1" ),
  REC_f( 651, volume_layers                           , object    , 256.f ),
  REC_f( 652, volume_data_range                       , object    , 5.0f ),
  REC_i( 653, auto_defer_atom_count                   , global    , 0 ),
  REC_s( 654, default_refmac_names                    , global    , "FWT PHWT DELFWT PHDELWT" ),
  REC_s( 655, default_phenix_names                    , global    , "2FOFCWT PH2FOFCWT FOFCWT PHFOFCWT" ),
  REC_s( 656, default_phenix_no_fill_names            , global    , "2FOFCWT_no_fil PH2FOFCWT_no_fill None None" ),
  REC_s( 657, default_buster_names                    , global    , "2FOFCWT PH2FOFCWT FOFCWT PHFOFCWT" ),
  REC_s( 658, default_fofc_map_rep                    , global    , "volume" ),
  REC_s( 659, default_2fofc_map_rep                   , global    , "volume" ),
  REC_s( 660, atom_type_format                        , global    , "mol2" ),
  REC_b( 661, autoclose_dialogs                       , global    , 1 ),
  REC_b( 662, bg_gradient                             , global    , 0 ),
  REC_c( 663, bg_rgb_top                              , global    , "0x00004D" ),
  REC_c( 664, bg_rgb_bottom                           , global    , "0x333380" ),
  REC_b( 665, ray_volume                              , global    , 0 ),
  REC_f( 666, ribbon_transparency                     , ostate    , 0.0F ),
  REC_i( 667, state_counter_mode                      , object    , -1, -1, 2 ),        /* -1/1=as fraction; 0=off; 2=no fraction */
  REC_b( 668, cgo_use_shader                          , global    , 1 ),
  REC_b( 669, cgo_shader_ub_color                     , global    , 0 ),
  REC_b( 670, cgo_shader_ub_normal                    , global    , 0 ),
  REC_i( 671, cgo_lighting                            , object    , 1 ),
  REC_b( 672, mesh_use_shader                         , global    , 1 ),
  REC_i( 673, stick_debug                             , global    , 0 ),
  REC_i( 674, cgo_debug                               , global    , 0 ),
  REC_i( 675, stick_round_nub                         , ostate    , 0 ),
  REC_i( 676, stick_good_geometry                     , ostate    , 0 ),
  REC_b( 677, stick_as_cylinders                      , global    , 1 ),
  REC_b( 678, mesh_as_cylinders                       , global    , 0 ),
  REC_b( 679, line_as_cylinders                       , global    , 0 ),
  REC_b( 680, ribbon_as_cylinders                     , global    , 0 ),
  REC_b( 681, ribbon_use_shader                       , global    , 1 ),
  REC_b( 682, excl_display_lists_shaders              , unused    , 0 ),
  REC_b( 683, dash_use_shader                         , global    , 1 ),
  REC_b( 684, dash_as_cylinders                       , global    , 1 ),
  REC_b( 685, nonbonded_use_shader                    , global    , 1 ),
  REC_b( 686, nonbonded_as_cylinders                  , global    , 0 ),
  REC_b( 687, cylinders_shader_filter_faces           , unused    , 1 ),
  REC_f( 688, nb_spheres_size                         , ostate    , 0.25f ),
  REC_i( 689, nb_spheres_quality                      , ostate    , 1, 0, MAX_SPHERE_QUALITY ),
  REC_i( 690, nb_spheres_use_shader                   , global    , 1, 0, 2 ),
  REC_b( 691, render_as_cylinders                     , global    , 1 ),
  REC_b( 692, alignment_as_cylinders                  , global    , 0 ),
  /* 0 - none, 1 - just ladder, 2 - just strand, 3 - both ladder and strand */
  REC_i( 693, cartoon_nucleic_acid_as_cylinders       , global    , 1, 0, 3 ),
  REC_b( 694, cgo_shader_ub_flags                     , global    , 0 ),
  REC_i( 695, antialias_shader                        , global    , 0 ),        /* 0 - none, 1 - fxaa, 2 - smaa */
  REC_f( 696, offscreen_rendering_multiplier          , unused    , 4.f ),
  REC_b( 697, cylinder_shader_ff_workaround           , unused    , 1 ),
  REC_i( 698, surface_color_smoothing                 , global    , 1 ),
  REC_f( 699, surface_color_smoothing_threshold       , global    , 0.05f ),
  REC_b( 700, dot_use_shader                          , global    , 1 ),
  REC_b( 701, dot_as_spheres                          , ostate    , 0 ),
  REC_i( 702, ambient_occlusion_mode                  , ostate    , 0 ),
  REC_f( 703, ambient_occlusion_scale                 , ostate    , 25.f ),
  REC_i( 704, ambient_occlusion_smooth                , ostate    , 10 ),
  REC_b( 705, smooth_half_bonds                       , global    , 1 ),
  REC_i( 706, anaglyph_mode                           , global    , 4, 0, 4 ),  /* 0 = true; 1 = gray; 2 = color; 3 = half color; 4 = optimized */
  REC_i( 707, edit_light                              , global    , 1 ),
  REC_b( 708, suspend_undo                            , global    , 0 ),
  REC_i( 709, suspend_undo_atom_count                 , global    , 1000 ),
  REC_b( 710, suspend_deferred                        , global    , 0 ),
  REC_b( 711, pick_surface                            , ostate    , 0 ),
  REC_s( 712, bg_image_filename                       , global    , "" ),
  /* 0 = streched; 1 = centered; 2 = tiled, 3 = centered&repeated */
  REC_i( 713, bg_image_mode                           , global    , 0, 0, 3 ),
  REC_3( 714, bg_image_tilesize                       , global    , 100.F, 100.F, 0.f ),     /* XY in pixels, Z unused */
  REC_b( 715, bg_image_linear                         , global    , 1 ),
  REC_s( 716, load_object_props_default               , global    , "" ),
  REC_s( 717, load_atom_props_default                 , global    , "" ),
  REC_3( 718, label_placement_offset                  , astate    , 0.f, 0.f, 0.f ),
  REC_b( 719, pdb_conect_nodup                        , global    , 1 ),
  REC_b( 720, label_connector                         , astate    , 0 ),
  // 0 - line from target to closest corner/midpoint
  // 1 - line from target to center (stops at bbx)
  // 2 - 2 lines from target to bbx corner (with bend at label_connector_ext_length distance */
  // 3 - line from target to closest corner or edge of bounds
  // 4 - line from target to closest corner/midpoint
  REC_i( 721, label_connector_mode                    , astate    , 0, 0, 4 ),
  REC_c( 722, label_connector_color                   , astate    , "-6" ),
  REC_f( 723, label_connector_width                   , astate    , 2.f ),
  REC_f( 724, label_connector_ext_length              , astate    , 2.5f ),
  REC_c( 725, label_bg_color                          , astate    , "-1" ),
  REC_b( 726, use_geometry_shaders                    , global    , 1 ),
  // 0 - world/label_position
  // 1 - label_screen_point (-1. - 1.)
  // 2 - label_screen_point (in pixels)
  REC_i( 727, label_relative_mode                     , astate    , 0, 0, 2 ),
  REC_3( 728, label_screen_point                      , astate    , 0.f, 0.f, 0.f ),
  REC_f( 729, label_multiline_spacing                 , astate    , 1.2f ),
  REC_f( 730, label_multiline_justification           , astate    , 1.f ),
  REC_3( 731, label_padding                           , astate    , 0.2F, 0.2F, 0.0F ),
  REC_f( 732, label_bg_transparency                   , astate    , .6f ),
  REC_b( 733, label_bg_outline                        , astate    , 0 ),
  REC_b( 734, ray_label_connector_flat                , astate    , 1 ),
  REC_f( 735, dash_transparency                       , ostate    , 0.0f ),
  REC_i( 736, pick_labels                             , ostate    , 1 ),
  REC_i( 737, label_z_target                          , astate    , 0 ),
  REC_b( 738, session_embeds_data                     , global    , 1 ),
  REC_i( 739, volume_mode                             , global    , 1 ),
  REC_b( 740, trilines                                , global    , 0 ),
  REC_i( 741, collada_export_lighting                 , global    , 0 ),
  REC_i( 742, collada_geometry_mode                   , global    , 0 ),
  REC_b( 743, precomputed_lighting                    , global    , 0 ),
  REC_b( 744, chromadepth                             , global    , 0 ),
  REC_f( 745, pse_export_version                      , global    , 0.f ),
  REC_b( 746, cif_use_auth                            , global    , 1 ),
  REC_s( 747, assembly                                , global    , "" ),
  REC_b( 748, cif_keepinmemory                        , global    , 0 ),
  REC_b( 749, pse_binary_dump                         , global    , 0 ),
  REC_i( 750, cartoon_gap_cutoff                      , ostate    , 0 ),
  REC_b( 751, ignore_case_chain                       , global    , 0 ),
  REC_f( 752, valence_zero_scale                      , ostate    , 0.2f ),
  REC_i( 753, valence_zero_mode                       , ostate    , 1, 0, 2 ), // 0: skip, 1: dashed, 2: solid
  REC_i( 754, auto_show_classified                    , global    , 0, 0, 3 ), // 0: off, 1: as, 2: show, 3: simple
  REC_b( 755, collada_background_box                  , global    , 0 ),
  REC_b( 756, pick32bit                               , unused    , 1 ),
  REC_b( 757, cartoon_all_alt                         , ostate    , 0 ),
  REC_i( 758, display_scale_factor                    , unused    , 1 ),
  REC_b( 759, pick_shading                            , global    , 0 ),

#ifdef SETTINGINFO_IMPLEMENTATION
#undef SETTINGINFO_IMPLEMENTATION
#else
  // last item in enum, automatically equals last index + 1
  cSetting_INIT
#endif
};

#undef REC__
#undef REC_b
#undef REC_i
#undef REC_f
#undef REC_3
#undef REC_s
#undef REC_c
