# mount.py
# Copyright (C) 2008 Stefan J. Betz <stefan_betz@gmx.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import re
import socket
import host
import nmblookup
import smbclient
from pyneighborhood.misc import sharepath, print_debug

class AddWindow(object):
    """
    The Add-Dialog
    """

    def __init__(self, mainwindow):
        """
        Constructor
        """
        self.mainwindow = mainwindow
        self.xml = gtk.glade.XML(sharepath() + "/pyNeighborhood.glade", "addwindow")
        self.xml.signal_autoconnect(self)
        self.window = self.xml.get_widget("addwindow")
        self.url = self.xml.get_widget("urlentry")
        # RE for the URL Entry:
        # Group 1 = Host or IP
        # Group 2 = Share
        self.urlre = re.compile("^//(.*)/(.*)$")
        self.ipre = re.compile("^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$")
        self.nmblookup = nmblookup.nmblookup()
        self.smbclient = smbclient.smbclient()

    def response_handler(self, widget, response_id):
        """
        Response Handler
        """
        if response_id == gtk.RESPONSE_CANCEL:
            self.window.destroy()
            return gtk.FALSE
        elif response_id == gtk.RESPONSE_OK:
            match = self.urlre.match(self.url.get_text())
            if match != None:
                h = host.host()
                if self.ipre.match(match.group(1)) == None:
                    try:
                        h.ip = socket.gethostbyname(match.group(1))
                    except socket.gaierror:
                        print_debug("Cant not Resolve host " + match.group(1))
                else:
                    h.ip = match.group(1)
                try:
                    h.dns_name = socket.gethostbyaddr(h.ip)[0]
                except socket.gaierror:
                    print_debug("Cant not reverse Lookup IP " + h.ip)
                self.nmblookup.retrieve_host(h)
                self.nmblookup.retrieve_workgroup(h)
                if match.group(2) == "":
                    self.smbclient.shares(h)
                else:
                    h.shares[match.group(2)] = "Manual appended Share"
                if h.ip != "" and h.name != "" and h.workgroup != "":
                    i = None
                    if not self.mainwindow.host_objects.has_key(h.workgroup):
                        self.mainwindow.host_objects[h.workgroup] = {}
                        gtk.gdk.threads_enter()
                        i = self.mainwindow.treestore.append(None)
                        self.mainwindow.treestore.set_value(i, self.mainwindow.NAME, h.workgroup)
                        self.mainwindow.treestore.set_value(i, self.mainwindow.ICON, self.mainwindow.GROUP_ICON)
                        self.mainwindow.treestore.set_value(i, self.mainwindow.IS_WORKGROUP, True)
                        gtk.gdk.threads_leave()
                    else:
                        for subrow in self.mainwindow.treestore:
                            if subrow[self.mainwindow.NAME] == h.workgroup and subrow[self.mainwindow.IS_WORKGROUP] == True:
                                i = subrow.iter
                    if not self.mainwindow.host_objects[h.workgroup].has_key(h.name):
                        self.mainwindow.host_objects[h.workgroup][h.name] = h
                        gtk.gdk.threads_enter()
                        i = self.mainwindow.treestore.append(i)
                        self.mainwindow.treestore.set_value(i, self.mainwindow.NAME, h.name)
                        self.mainwindow.treestore.set_value(i, self.mainwindow.ICON, self.mainwindow.HOST_ICON)
                        self.mainwindow.treestore.set_value(i, self.mainwindow.IS_HOST, True)
                        gtk.gdk.threads_leave()
                    else:
                        subiter = self.mainwindow.treestore.iter_children(i)
                        while subiter != None:
                            if self.mainwindow.treestore.get_value(subiter, self.mainwindow.NAME) == h.name:
                                if self.mainwindow.treestore.get_value(subiter, self.mainwindow.IS_HOST) == True:
                                    i = subiter
                            subiter = self.mainwindow.treestore.iter_next(subiter)
                    for each in h.shares.keys():
                        gtk.gdk.threads_enter()
                        s = self.mainwindow.treestore.append(i)
                        self.mainwindow.treestore.set_value(s, self.mainwindow.NAME, each)
                        self.mainwindow.treestore.set_value(s, self.mainwindow.COMMENT, h.shares[each])
                        self.mainwindow.treestore.set_value(s, self.mainwindow.ICON, self.mainwindow.SHARE_ICON)
                        self.mainwindow.treestore.set_value(s, self.mainwindow.IS_SHARE, True)
                        gtk.gdk.threads_leave()
            else:
                print_debug("Syntax not compatible")
            self.window.destroy()
            return gtk.TRUE
