# mount.py
# Copyright (C) 2008 Stefan J. Betz <stefan_betz@gmx.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import threading
import re
import gettext
import os
from pyneighborhood import config
from pyneighborhood.misc import sharepath

_ = gettext.gettext

class MountWindow(threading.Thread):
    """
    The Mount Dialog
    """

    def __init__(self, mainwindow, host, share, iter):
        """
        Constructor
        """
        threading.Thread.__init__(self)
        self.mainwindow = mainwindow
        self.host = host
        self.share = share
        self.iter = iter
        self.xml = gtk.glade.XML(sharepath() + "/pyNeighborhood.glade", "mount")
        self.xml.signal_autoconnect(self)
        self.window = self.xml.get_widget("mount")
        self.workgroupentry = self.xml.get_widget("workgroup-entry")
        self.workgroupentry.set_text(host.workgroup)
        self.hostentry = self.xml.get_widget("host-entry")
        self.hostentry.set_text(host.name)
        self.shareentry = self.xml.get_widget("share-entry")
        self.shareentry.set_text(share)
        self.type = self.xml.get_widget("type-combo")
        self.anontoggle = self.xml.get_widget("anonymous-button")
        self.authtoggle = self.xml.get_widget("user-pass-button")
        self.user = self.xml.get_widget("user-entry")
        self.user.set_text(config.get("Main", "username"))
        self.password = self.xml.get_widget("password-entry")
        self.password.set_text(config.get("Main", "password"))
        self.individual = self.xml.get_widget("individual-button")
        self.choose_mountpoint = self.xml.get_widget("mountpoint-chooser")
        if os.access(config.get("Main", "mount_directory"), os.F_OK):
            self.choose_mountpoint.set_current_folder(config.get("Main", "mount_directory"))
        if config.get("CIFS", "enable") == "True":
            self.type.insert_text(0, "CIFS")
        if config.get("SMB", "enable") == "True":
            self.type.append_text("SMB")
        self.type.set_active(0)
        self.errorre = re.compile("^.* ([0-9]+) = (.*)")

    def logon_toggle(self, widget):
        """
        Logon Options Toggle Callback
        """
        if self.authtoggle.get_active() == True:
            self.user.set_sensitive(True)
            self.password.set_sensitive(True)
        else:
            self.user.set_sensitive(False)
            self.password.set_sensitive(False)
    
    def mountpoint_toggled(self, button):
        """
        Individual Mountpoint Toggle Callback
        """
        if button.get_active() == True:
            self.xml.get_widget("mountpoint-chooser").set_sensitive(True)
        else:
            self.xml.get_widget("mountpoint-chooser").set_sensitive(False)

    def response_handler(self, widget, response_id):
        """
        Response Handler
        """
        if response_id == gtk.RESPONSE_CANCEL:
            self.window.destroy()
        elif response_id == gtk.RESPONSE_APPLY:
            self.start()
            self.window.hide_all()

    def run(self):
        """
        Make it real!
        """
        self.mountpoint = self.choose_mountpoint.get_current_folder()
        self.individual_toggle = self.individual.get_active()
        if self.anontoggle.get_active() == True:
            if self.individual_toggle == True:
                mountpoint, error = self.host.mount(self.share, self.type.get_active_text(), target=self.mountpoint)
            elif self.individual_toggle == False:
                mountpoint, error = self.host.mount(self.share, self.type.get_active_text())
        elif self.authtoggle.get_active() == True:
            if self.individual_toggle == True:
                mountpoint, error = self.host.mount(self.share, self.type.get_active_text(),
                                                    username=self.user.get_text(), password=self.password.get_text(),
                                                    target=self.mountpoint)
            elif self.individual_toggle == False:
                  mountpoint, error = self.host.mount(self.share, self.type.get_active_text(),
                                                    username=self.user.get_text(), password=self.password.get_text())
        if error != None:
            dialog = gtk.MessageDialog(self.window, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, _("Mount Error:"))
            dialog.format_secondary_text(error)
            def response(dialog, responseid):
                dialog.destroy()
            dialog.connect("response", response)
            dialog.show()
        else:
            gtk.gdk.threads_enter()
            self.mainwindow.treestore.set_value(self.iter, self.mainwindow.MOUNTPOINT, mountpoint)
            gtk.gdk.threads_leave()
            self.mainwindow.reload_mounts()
        #self.window.destroy() # Commented out for the Dialog above! FIXME Please!
