# smbclient.py
# Copyright (C) 2008 Stefan J. Betz <stefan_betz@gmx.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import subprocess
import copy
import re
from pyneighborhood import config
from pyneighborhood.misc import print_debug

class smbclient(object):
    """
    Parser for the smbclient Application
    """

    def __init__(self):
        """
        Constructor
        """
        self.sharere = re.compile("^ *\t(.*)(Disk) *(.*)$", re.M)
        self.anonsharelookupcommand = [ config.get("Main", "smbclient"), "-N", "-L" ]

    def hosts(self):
        """
        Get the List of Hosts
        """
        pass

    def shares(self, host):
        """
        Get the List of Share to host
        """
        if host.ip == "":
            return
        host.shares = {}
        print_debug("Scanning for Shares:" + host.ip)
        command = copy.copy(self.anonsharelookupcommand)
        command.append(host.ip)
        process = subprocess.Popen(command,
                                   executable = command[0],
                                   stdout = subprocess.PIPE,
                                   stderr = subprocess.STDOUT )
        process.wait()
        output = process.stdout.read()
        print_debug(command, output)
        match = self.sharere.search(output)
        while match != None:
            host.shares[match.group(1).rstrip()] = match.group(3).rstrip()
            match = self.sharere.search(output, match.end())
        print_debug("Shares found: " + str(host.shares))
