# smbtree.py
# Copyright (C) 2008 Stefan J. Betz <stefan_betz@gmx.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import nmblookup
import host
import workgroup
import subprocess
import re
from pyneighborhood import config
from pyneighborhood.misc import print_debug

class smbtree(object):
    """
    Parser for the smbtree Application
    """

    def __init__(self):
        """
        Objekt Construktor
        """
        self.nmbobj = nmblookup.nmblookup()
        self.hostsre = re.compile("(.*)\n(\t\\\\(.*)\t\t(.*))")
        self.hostscommand = [ config.get("Main", "smbtree"), "-S", "-N" ]
        self.workgroupscommand = [ config.get("Main", "smbtree"), "-D", "-N" ]

    def workgroups(self):
        """
        Get the List of Workgroups
        """
        print_debug("Scanning for Workgroups via smbtree...")
        process = subprocess.Popen(self.workgroupscommand, executable = self.workgroupscommand[0], stdout = subprocess.PIPE)
        process.wait()
        output = process.stdout.read()
        print_debug(self.workgroupscommand, output)
        for workgroupitem in output.split("\n"):
            if workgroupitem != "":
                workgroupobj = workgroup.workgroup()
                workgroupobj.name = workgroupitem
                self.nmbobj.retrieve_master(workgroupobj)
                print_debug(workgroupobj)
                yield workgroupobj

    def hosts(self):
        """
        Get the List of Hosts
        """
        print_debug("Scanning for hosts via smbtree...")
        process = subprocess.Popen(self.hostscommand, executable = self.hostscommand[0], stdout = subprocess.PIPE)
        process.wait()
        output = process.stdout.read()
        print_debug(self.hostscommand, output)
        match = self.hostsre.match(output)
        while match != None:
            thishost = host.host()
            thishost.name = match.group(3).strip().lstrip("\\")
            thishost.comment = match.group(4).strip()
            self.nmbobj.retrieve_ip(thishost)
            self.nmbobj.retrieve_workgroup(thishost)
            match = self.hostsre.match(output, match.end())
            print_debug(thishost.name)
            yield thishost
