# Pyntor::Barslider - Slide in top and bottom bar
# Copyright (C) 2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *

class Barslider:
	def init(self, options):
		self.height = options["height"]

	def render(self, screen, page, globalpage):
		fillcolor = (0, 0, 0)
		linecolor = (255, 255, 255)

		y = screen.get_height()
		for i in range(self.height):
			screen.fill(fillcolor, ((0, i * 3), (screen.get_width(), 3)))
			screen.fill(linecolor, ((0, i * 3 + 4), (screen.get_width(), 1)))
			if i < 27:
				screen.fill(fillcolor, ((0, y - i * 3), (screen.get_width(), 3)))
				screen.fill(linecolor, ((0, y - i * 3 - 1), (screen.get_width(), 1)))

			if pygame.display.get_surface():
				pygame.display.update()

component = Barslider()

parameters = (
	("height", "Number of pixels to slide into the screen", 32),
)

metainfo = {
	"version": "0.1",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Barslider: Slides top and bottom bars into the screen

Usage: 'barslider' [-height <height>]
 Where <height> is the number of pixels which the bar should slide from the
 top and the bottom

Display: yes

Interactivity: no (but contains timer events)
"""

