'''OpenGL extension NV.fence

Overview (from the spec)
	
	The goal of this extension is provide a finer granularity of
	synchronizing GL command completion than offered by standard OpenGL,
	which offers only two mechanisms for synchronization: Flush and Finish.
	Since Flush merely assures the user that the commands complete in a
	finite (though undetermined) amount of time, it is, thus, of only
	modest utility.  Finish, on the other hand, stalls CPU execution
	until all pending GL commands have completed.  This extension offers
	a middle ground - the ability to "finish" a subset of the command
	stream, and the ability to determine whether a given command has
	completed or not.
	
	This extension introduces the concept of a "fence" to the OpenGL
	command stream.  Once the fence is inserted into the command stream, it
	can be queried for a given condition - typically, its completion.
	Moreover, the application may also request a partial Finish -- that is,
	all commands prior to the fence will be forced to complete until control
	is returned to the calling process.  These new mechanisms allow for
	synchronization between the host CPU and the GPU, which may be accessing
	the same resources (typically memory).
	
	This extension is useful in conjunction with NV_vertex_array_range
	to determine when vertex information has been pulled from the
	vertex array range.  Once a fence has been tested TRUE or finished,
	all vertex indices issued before the fence must have been pulled.
	This ensures that the vertex data memory corresponding to the issued
	vertex indices can be safely modified (assuming no other outstanding
	vertex indices are issued subsequent to the fence).

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/NV/fence.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_ALL_COMPLETED_NV = constant.Constant( 'GL_ALL_COMPLETED_NV', 0x84F2 )
GL_FENCE_STATUS_NV = constant.Constant( 'GL_FENCE_STATUS_NV', 0x84F3 )
GL_FENCE_CONDITION_NV = constant.Constant( 'GL_FENCE_CONDITION_NV', 0x84F4 )
glDeleteFencesNV = platform.createExtensionFunction( 
	'glDeleteFencesNV', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLsizei, arrays.GLuintArray,),
	doc = 'glDeleteFencesNV( GLsizei(n), GLuintArray(fences) ) -> None',
	argNames = ('n', 'fences',),
)

glGenFencesNV = platform.createExtensionFunction( 
	'glGenFencesNV', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLsizei, arrays.GLuintArray,),
	doc = 'glGenFencesNV( GLsizei(n), GLuintArray(fences) ) -> None',
	argNames = ('n', 'fences',),
)

glIsFenceNV = platform.createExtensionFunction( 
	'glIsFenceNV', dll=platform.GL,
	resultType=constants.GLboolean, 
	argTypes=(constants.GLuint,),
	doc = 'glIsFenceNV( GLuint(fence) ) -> constants.GLboolean',
	argNames = ('fence',),
)

glTestFenceNV = platform.createExtensionFunction( 
	'glTestFenceNV', dll=platform.GL,
	resultType=constants.GLboolean, 
	argTypes=(constants.GLuint,),
	doc = 'glTestFenceNV( GLuint(fence) ) -> constants.GLboolean',
	argNames = ('fence',),
)

glGetFenceivNV = platform.createExtensionFunction( 
	'glGetFenceivNV', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLenum, arrays.GLintArray,),
	doc = 'glGetFenceivNV( GLuint(fence), GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('fence', 'pname', 'params',),
)

glFinishFenceNV = platform.createExtensionFunction( 
	'glFinishFenceNV', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLuint,),
	doc = 'glFinishFenceNV( GLuint(fence) ) -> None',
	argNames = ('fence',),
)

glSetFenceNV = platform.createExtensionFunction( 
	'glSetFenceNV', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLenum,),
	doc = 'glSetFenceNV( GLuint(fence), GLenum(condition) ) -> None',
	argNames = ('fence', 'condition',),
)


def glInitFenceNV():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_NV_fence' )
