'''OpenGL extension NV.primitive_restart

Overview (from the spec)
	
	This extension allows applications to easily and inexpensively
	restart a primitive in its middle.  A "primitive restart" is simply
	the same as an End command, followed by another Begin command with
	the same mode as the original.  The typical expected use of this
	feature is to draw a mesh with many triangle strips, though primitive
	restarts are legal for all primitive types, even for points (where
	they are not useful).
	
	Although the EXT_multi_draw_arrays extension did reduce the overhead
	of such drawing techniques, they still remain more expensive than one
	would like.
	
	This extension provides an extremely lightweight primitive restart,
	which is accomplished by allowing the application to choose a special
	index number that signals that a primitive restart should occur,
	rather than a vertex being provoked.  This index can be an arbitrary
	32-bit integer for maximum application convenience.
	
	In addition, for full orthogonality, a special OpenGL command is
	provided to restart primitives when in immediate mode.  This command
	is not likely to increase performance in any significant fashion, but
	providing it greatly simplifies the specification and implementation
	of display list compilation and indirect rendering.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/NV/primitive_restart.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_PRIMITIVE_RESTART_NV = constant.Constant( 'GL_PRIMITIVE_RESTART_NV', 0x8558 )
glget.addGLGetConstant( GL_PRIMITIVE_RESTART_NV, (1,) )
GL_PRIMITIVE_RESTART_INDEX_NV = constant.Constant( 'GL_PRIMITIVE_RESTART_INDEX_NV', 0x8559 )
glget.addGLGetConstant( GL_PRIMITIVE_RESTART_INDEX_NV, (1,) )
glPrimitiveRestartNV = platform.createExtensionFunction( 
	'glPrimitiveRestartNV', dll=platform.GL,
	resultType=None, 
	argTypes=(),
	doc = 'glPrimitiveRestartNV(  ) -> None',
	argNames = (),
)

glPrimitiveRestartIndexNV = platform.createExtensionFunction( 
	'glPrimitiveRestartIndexNV', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLuint,),
	doc = 'glPrimitiveRestartIndexNV( GLuint(index) ) -> None',
	argNames = ('index',),
)


def glInitPrimitiveRestartNV():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_NV_primitive_restart' )
